/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import java.lang.reflect.Field;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.ThreadPerChannelEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.group.DefaultChannelGroup;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.DefaultPromise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GlobalEventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.SingleThreadEventExecutor;

@Disabled(value="Flaky test; See: https://github.com/netty/netty/issues/11551")
public class ThreadPerChannelEventLoopGroupTest {
    private static final ChannelHandler NOOP_HANDLER = new ChannelHandlerAdapter(){

        public boolean isSharable() {
            return true;
        }
    };

    @Test
    public void testTerminationFutureSuccessInLog() throws Exception {
        for (int i = 0; i < 2; ++i) {
            ThreadPerChannelEventLoopGroup loopGroup = new ThreadPerChannelEventLoopGroup(64);
            ThreadPerChannelEventLoopGroupTest.runTest(loopGroup);
        }
    }

    @Test
    public void testTerminationFutureSuccessReflectively() throws Exception {
        Field terminationFutureField = ThreadPerChannelEventLoopGroup.class.getDeclaredField("terminationFuture");
        terminationFutureField.setAccessible(true);
        final Exception[] exceptionHolder = new Exception[1];
        for (int i = 0; i < 2; ++i) {
            ThreadPerChannelEventLoopGroup loopGroup = new ThreadPerChannelEventLoopGroup(64);
            DefaultPromise<Void> promise = new DefaultPromise<Void>((EventExecutor)GlobalEventExecutor.INSTANCE){

                public Promise<Void> setSuccess(Void result) {
                    try {
                        return super.setSuccess((Object)result);
                    }
                    catch (IllegalStateException e) {
                        exceptionHolder[0] = e;
                        throw e;
                    }
                }
            };
            terminationFutureField.set(loopGroup, promise);
            ThreadPerChannelEventLoopGroupTest.runTest(loopGroup);
        }
        GlobalEventExecutor.INSTANCE.awaitTermination(100L, TimeUnit.MILLISECONDS);
        Assertions.assertNull((Object)exceptionHolder[0]);
    }

    private static void runTest(ThreadPerChannelEventLoopGroup loopGroup) throws InterruptedException {
        int taskCount = 100;
        TestEventExecutor testExecutor = new TestEventExecutor();
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)testExecutor);
        while (taskCount-- > 0) {
            EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{NOOP_HANDLER});
            loopGroup.register((ChannelPromise)new DefaultChannelPromise((Channel)channel, (EventExecutor)testExecutor));
            channelGroup.add((Object)channel);
        }
        channelGroup.close().sync();
        loopGroup.shutdownGracefully(100L, 200L, TimeUnit.MILLISECONDS).sync();
        Assertions.assertTrue((boolean)loopGroup.isTerminated());
    }

    private static class TestEventExecutor
    extends SingleThreadEventExecutor {
        TestEventExecutor() {
            super(null, (ThreadFactory)new DefaultThreadFactory("test"), false);
        }

        protected void run() {
            do {
                Runnable task;
                if ((task = this.takeTask()) == null) continue;
                task.run();
                this.updateLastExecutionTime();
            } while (!this.confirmShutdown());
        }
    }
}

