/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.pool;

import java.net.SocketAddress;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelHealthChecker;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPoolHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelPoolTestUtils;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.CountingChannelPoolHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.SimpleChannelPool;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;

public class SimpleChannelPoolTest {
    @Test
    public void testAcquire() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).sync().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, (ChannelPoolHandler)handler);
        Channel channel = (Channel)pool.acquire().sync().getNow();
        pool.release(channel).syncUninterruptibly();
        Channel channel2 = (Channel)pool.acquire().sync().getNow();
        Assertions.assertSame((Object)channel, (Object)channel2);
        Assertions.assertEquals((int)1, (int)handler.channelCount());
        pool.release(channel2).syncUninterruptibly();
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable((ChannelPool)pool, channel2){
            final /* synthetic */ ChannelPool val$pool;
            final /* synthetic */ Channel val$channel2;
            {
                this.val$pool = channelPool;
                this.val$channel2 = channel;
            }

            public void execute() throws Throwable {
                this.val$pool.release(this.val$channel2).syncUninterruptibly();
            }
        });
        Assertions.assertFalse((boolean)channel.isActive());
        Assertions.assertEquals((int)2, (int)handler.acquiredCount());
        Assertions.assertEquals((int)2, (int)handler.releasedCount());
        sc.close().sync();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testBoundedChannelPoolSegment() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).sync().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, handler, ChannelHealthChecker.ACTIVE){
            private final Queue<Channel> queue;
            {
                this.queue = new LinkedBlockingQueue<Channel>(1);
            }

            protected Channel pollChannel() {
                return this.queue.poll();
            }

            protected boolean offerChannel(Channel ch) {
                return this.queue.offer(ch);
            }
        };
        Channel channel = (Channel)pool.acquire().sync().getNow();
        Channel channel2 = (Channel)pool.acquire().sync().getNow();
        pool.release(channel).syncUninterruptibly().getNow();
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable((ChannelPool)pool, channel2){
            final /* synthetic */ ChannelPool val$pool;
            final /* synthetic */ Channel val$channel2;
            {
                this.val$pool = channelPool;
                this.val$channel2 = channel;
            }

            public void execute() throws Throwable {
                this.val$pool.release(this.val$channel2).syncUninterruptibly();
            }
        });
        channel2.close().sync();
        Assertions.assertEquals((int)2, (int)handler.channelCount());
        Assertions.assertEquals((int)2, (int)handler.acquiredCount());
        Assertions.assertEquals((int)1, (int)handler.releasedCount());
        sc.close().sync();
        channel.close().sync();
        channel2.close().sync();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testUnhealthyChannelIsNotOffered() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, (ChannelPoolHandler)handler);
        Channel channel1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        pool.release(channel1).syncUninterruptibly();
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertSame((Object)channel1, (Object)channel2);
        channel1.close().syncUninterruptibly();
        pool.release(channel1).syncUninterruptibly();
        Channel channel3 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertNotSame((Object)channel1, (Object)channel3);
        sc.close().syncUninterruptibly();
        channel3.close().syncUninterruptibly();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testUnhealthyChannelIsOfferedWhenNoHealthCheckRequested() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        Bootstrap cb = new Bootstrap();
        cb.remoteAddress((SocketAddress)addr);
        ((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class);
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(cb, (ChannelPoolHandler)handler, ChannelHealthChecker.ACTIVE, false);
        Channel channel1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        channel1.close().syncUninterruptibly();
        Future releaseFuture = pool.release(channel1, channel1.eventLoop().newPromise()).syncUninterruptibly();
        MatcherAssert.assertThat((Object)releaseFuture.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
        Channel channel2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Assertions.assertNotSame((Object)channel1, (Object)channel2);
        sc.close().syncUninterruptibly();
        channel2.close().syncUninterruptibly();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testBootstrap() {
        SimpleChannelPool pool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler());
        try {
            Assertions.assertNotNull((Object)pool.bootstrap());
        }
        finally {
            pool.close();
        }
    }

    @Test
    public void testHandler() {
        CountingChannelPoolHandler handler = new CountingChannelPoolHandler();
        SimpleChannelPool pool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)handler);
        try {
            Assertions.assertSame((Object)handler, (Object)pool.handler());
        }
        finally {
            pool.close();
        }
    }

    @Test
    public void testHealthChecker() {
        ChannelHealthChecker healthChecker = ChannelHealthChecker.ACTIVE;
        SimpleChannelPool pool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler(), healthChecker);
        try {
            Assertions.assertSame((Object)healthChecker, (Object)pool.healthChecker());
        }
        finally {
            pool.close();
        }
    }

    @Test
    public void testReleaseHealthCheck() {
        SimpleChannelPool healthCheckOnReleasePool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler(), ChannelHealthChecker.ACTIVE, true);
        try {
            Assertions.assertTrue((boolean)healthCheckOnReleasePool.releaseHealthCheck());
        }
        finally {
            healthCheckOnReleasePool.close();
        }
        SimpleChannelPool noHealthCheckOnReleasePool = new SimpleChannelPool(new Bootstrap(), (ChannelPoolHandler)new CountingChannelPoolHandler(), ChannelHealthChecker.ACTIVE, false);
        try {
            Assertions.assertFalse((boolean)noHealthCheckOnReleasePool.releaseHealthCheck());
        }
        finally {
            noHealthCheckOnReleasePool.close();
        }
    }

    @Test
    public void testCloseAsync() throws Exception {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)group)).remoteAddress((SocketAddress)addr);
        SimpleChannelPool pool = new SimpleChannelPool(bootstrap, (ChannelPoolHandler)new CountingChannelPoolHandler());
        Channel ch1 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        Channel ch2 = (Channel)pool.acquire().syncUninterruptibly().getNow();
        pool.release(ch1).get(1L, TimeUnit.SECONDS);
        pool.release(ch2).get(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)ch1.isOpen());
        Assertions.assertTrue((boolean)ch2.isOpen());
        pool.closeAsync().get(1L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)ch1.isOpen());
        Assertions.assertFalse((boolean)ch2.isOpen());
        sc.close().sync();
        pool.close();
        group.shutdownGracefully();
    }

    @Test
    public void testChannelAcquiredException() throws InterruptedException {
        LocalAddress addr = new LocalAddress(ChannelPoolTestUtils.getLocalAddrId());
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            protected void initChannel(LocalChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
            }
        });
        Channel sc = sb.bind((SocketAddress)addr).syncUninterruptibly().channel();
        Bootstrap bootstrap = ((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group((EventLoopGroup)group)).remoteAddress((SocketAddress)addr);
        final NullPointerException exception = new NullPointerException();
        SimpleChannelPool pool = new SimpleChannelPool(bootstrap, new ChannelPoolHandler(){

            public void channelReleased(Channel ch) {
            }

            public void channelAcquired(Channel ch) {
                throw exception;
            }

            public void channelCreated(Channel ch) {
            }
        });
        try {
            pool.acquire().sync();
        }
        catch (NullPointerException e) {
            Assertions.assertSame((Object)e, (Object)exception);
        }
        sc.close().sync();
        pool.close();
        group.shutdownGracefully();
    }
}

