/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.group.DefaultChannelGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.DatagramChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.AbstractNioChannelTest;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GlobalEventExecutor;

public class NioDatagramChannelTest
extends AbstractNioChannelTest<NioDatagramChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBindMultiple() throws Exception {
        DefaultChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
        NioEventLoopGroup group = new NioEventLoopGroup();
        try {
            for (int i = 0; i < 100; ++i) {
                Bootstrap udpBootstrap = new Bootstrap();
                ((Bootstrap)((Bootstrap)((Bootstrap)udpBootstrap.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                    }
                });
                DatagramChannel datagramChannel = (DatagramChannel)udpBootstrap.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
                channelGroup.add((Channel)datagramChannel);
            }
            Assertions.assertEquals((int)100, (int)channelGroup.size());
        }
        finally {
            channelGroup.close().sync();
            group.shutdownGracefully().sync();
        }
    }

    @Override
    protected NioDatagramChannel newNioChannel() {
        return new NioDatagramChannel();
    }

    @Override
    protected NetworkChannel jdkChannel(NioDatagramChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.TCP_NODELAY;
    }
}

