/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.channel.AddressedEnvelope;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultAddressedEnvelope;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.DatagramPacket;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.DatagramPacketEncoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.MessageToMessageEncoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.string.StringEncoder;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.SocketUtils;

public class DatagramPacketEncoderTest {
    private EmbeddedChannel channel;

    @BeforeEach
    public void setUp() {
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new DatagramPacketEncoder((MessageToMessageEncoder)new StringEncoder(CharsetUtil.UTF_8))});
    }

    @AfterEach
    public void tearDown() {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testEncode() {
        this.testEncode(false);
    }

    @Test
    public void testEncodeWithSenderIsNull() {
        this.testEncode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testEncode(boolean senderIsNull) {
        InetSocketAddress recipient = SocketUtils.socketAddress((String)"127.0.0.1", (int)10000);
        InetSocketAddress sender = senderIsNull ? null : SocketUtils.socketAddress((String)"127.0.0.1", (int)20000);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{new DefaultAddressedEnvelope((Object)"netty", (SocketAddress)recipient, (SocketAddress)sender)}));
        DatagramPacket packet = (DatagramPacket)this.channel.readOutbound();
        try {
            Assertions.assertEquals((Object)"netty", (Object)((ByteBuf)packet.content()).toString(CharsetUtil.UTF_8));
            Assertions.assertEquals((Object)recipient, (Object)packet.recipient());
            Assertions.assertEquals((Object)sender, (Object)packet.sender());
        }
        finally {
            packet.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnmatchedMessageType() {
        InetSocketAddress recipient = SocketUtils.socketAddress((String)"127.0.0.1", (int)10000);
        InetSocketAddress sender = SocketUtils.socketAddress((String)"127.0.0.1", (int)20000);
        DefaultAddressedEnvelope envelope = new DefaultAddressedEnvelope((Object)1L, (SocketAddress)recipient, (SocketAddress)sender);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{envelope}));
        DefaultAddressedEnvelope output = (DefaultAddressedEnvelope)this.channel.readOutbound();
        try {
            Assertions.assertSame((Object)envelope, (Object)output);
        }
        finally {
            output.release();
        }
    }

    @Test
    public void testUnmatchedType() {
        String netty = "netty";
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{netty}));
        Assertions.assertSame((Object)netty, (Object)this.channel.readOutbound());
    }

    @Test
    public void testIsNotSharable() {
        DatagramPacketEncoderTest.testSharable(false);
    }

    @Test
    public void testIsSharable() {
        DatagramPacketEncoderTest.testSharable(true);
    }

    private static void testSharable(boolean sharable) {
        TestMessageToMessageEncoder wrapped = new TestMessageToMessageEncoder(sharable);
        DatagramPacketEncoder encoder = new DatagramPacketEncoder((MessageToMessageEncoder)wrapped);
        Assertions.assertEquals((Object)wrapped.isSharable(), (Object)encoder.isSharable());
    }

    private static final class TestMessageToMessageEncoder
    extends MessageToMessageEncoder<AddressedEnvelope<ByteBuf, InetSocketAddress>> {
        private final boolean sharable;

        TestMessageToMessageEncoder(boolean sharable) {
            this.sharable = sharable;
        }

        protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<ByteBuf, InetSocketAddress> msg, List<Object> out) {
        }

        public boolean isSharable() {
            return this.sharable;
        }
    }
}

