/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.EncoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.MessageToMessageEncoder;

public class MessageToMessageEncoderTest {
    @Test
    public void testException() {
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new MessageToMessageEncoder<Object>(){

            protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
                throw new Exception();
            }
        }});
        Assertions.assertThrows(EncoderException.class, (Executable)new Executable(){

            public void execute() {
                channel.writeOutbound(new Object[]{new Object()});
            }
        });
    }

    @Test
    public void testIntermediateWriteFailures() {
        MessageToMessageEncoder<Object> encoder = new MessageToMessageEncoder<Object>(){

            protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
                out.add(new Object());
                out.add(msg);
            }
        };
        final Exception firstWriteException = new Exception();
        ChannelOutboundHandlerAdapter writeThrower = new ChannelOutboundHandlerAdapter(){
            private boolean firstWritten;

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (this.firstWritten) {
                    ctx.write(msg, promise);
                } else {
                    this.firstWritten = true;
                    promise.setFailure((Throwable)firstWriteException);
                }
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{writeThrower, encoder});
        Object msg = new Object();
        ChannelFuture write = channel.writeAndFlush(msg);
        Assertions.assertSame((Object)firstWriteException, (Object)write.cause());
        Assertions.assertSame((Object)msg, (Object)channel.readOutbound());
        Assertions.assertFalse((boolean)channel.finish());
    }
}

