/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractCompressionTest;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractDecoderTest
extends AbstractCompressionTest {
    protected static final ByteBuf WRAPPED_BYTES_SMALL = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])BYTES_SMALL)).asReadOnly();
    protected static final ByteBuf WRAPPED_BYTES_LARGE = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.wrappedBuffer((byte[])BYTES_LARGE)).asReadOnly();
    protected EmbeddedChannel channel;
    protected byte[] compressedBytesSmall = this.compress(BYTES_SMALL);
    protected byte[] compressedBytesLarge = this.compress(BYTES_LARGE);

    protected AbstractDecoderTest() throws Exception {
    }

    protected abstract byte[] compress(byte[] var1) throws Exception;

    @BeforeEach
    public final void initChannel() {
        this.channel = this.createChannel();
    }

    protected abstract EmbeddedChannel createChannel();

    @AfterEach
    public void destroyChannel() {
        if (this.channel != null) {
            this.channel.finishAndReleaseAll();
            this.channel = null;
        }
    }

    public ByteBuf[] smallData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])this.compressedBytesSmall);
        ByteBuf direct = Unpooled.directBuffer((int)this.compressedBytesSmall.length);
        direct.writeBytes(this.compressedBytesSmall);
        return new ByteBuf[]{heap, direct};
    }

    public ByteBuf[] largeData() {
        ByteBuf heap = Unpooled.wrappedBuffer((byte[])this.compressedBytesLarge);
        ByteBuf direct = Unpooled.directBuffer((int)this.compressedBytesLarge.length);
        direct.writeBytes(this.compressedBytesLarge);
        return new ByteBuf[]{heap, direct};
    }

    @ParameterizedTest
    @MethodSource(value={"smallData"})
    public void testDecompressionOfSmallChunkOfData(ByteBuf data) throws Exception {
        this.testDecompression(WRAPPED_BYTES_SMALL.duplicate(), data);
    }

    @ParameterizedTest
    @MethodSource(value={"largeData"})
    public void testDecompressionOfLargeChunkOfData(ByteBuf data) throws Exception {
        this.testDecompression(WRAPPED_BYTES_LARGE.duplicate(), data);
    }

    @ParameterizedTest
    @MethodSource(value={"largeData"})
    public void testDecompressionOfBatchedFlowOfData(ByteBuf data) throws Exception {
        this.testDecompressionOfBatchedFlow(WRAPPED_BYTES_LARGE.duplicate(), data);
    }

    protected void testDecompression(ByteBuf expected, ByteBuf data) throws Exception {
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{data}));
        ByteBuf decompressed = AbstractDecoderTest.readDecompressed(this.channel);
        Assertions.assertEquals((Object)expected, (Object)decompressed);
        decompressed.release();
    }

    protected void testDecompressionOfBatchedFlow(ByteBuf expected, ByteBuf data) throws Exception {
        ByteBuf compressedBuf;
        int compressedLength = data.readableBytes();
        int written = 0;
        int length = rand.nextInt(100);
        while (written + length < compressedLength) {
            compressedBuf = data.retainedSlice(written, length);
            this.channel.writeInbound(new Object[]{compressedBuf});
            written += length;
            length = rand.nextInt(100);
        }
        compressedBuf = data.slice(written, compressedLength - written);
        Assertions.assertTrue((boolean)this.channel.writeInbound(new Object[]{compressedBuf.retain()}));
        ByteBuf decompressedBuf = AbstractDecoderTest.readDecompressed(this.channel);
        Assertions.assertEquals((Object)expected, (Object)decompressedBuf);
        decompressedBuf.release();
        data.release();
    }

    protected static ByteBuf readDecompressed(EmbeddedChannel channel) {
        ByteBuf msg;
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        while ((msg = (ByteBuf)channel.readInbound()) != null) {
            decompressed.addComponent(true, msg);
        }
        return decompressed;
    }

    protected static void tryDecodeAndCatchBufLeaks(EmbeddedChannel channel, ByteBuf data) {
        try {
            channel.writeInbound(new Object[]{data});
        }
        finally {
            ByteBuf inflated;
            while ((inflated = (ByteBuf)channel.readInbound()) != null) {
                inflated.release();
            }
            channel.finish();
        }
    }
}

