/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.marshalling.Marshaller;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling.AbstractMarshallingTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling.CompatibleMarshallingDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling.DefaultUnmarshallerProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling.UnmarshallerProvider;

public abstract class AbstractCompatibleMarshallingDecoderTest
extends AbstractMarshallingTest {
    private final String testObject = new String("test");

    @Test
    public void testSimpleUnmarshalling() throws IOException {
        MarshallerFactory marshallerFactory = this.createMarshallerFactory();
        MarshallingConfiguration configuration = this.createMarshallingConfig();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(Integer.MAX_VALUE)});
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Marshaller marshaller = marshallerFactory.createMarshaller(configuration);
        marshaller.start(Marshalling.createByteOutput((OutputStream)bout));
        marshaller.writeObject((Object)this.testObject);
        marshaller.finish();
        marshaller.close();
        byte[] testBytes = bout.toByteArray();
        ch.writeInbound(new Object[]{this.input(testBytes)});
        Assertions.assertTrue((boolean)ch.finish());
        String unmarshalled = (String)ch.readInbound();
        Assertions.assertEquals((Object)this.testObject, (Object)unmarshalled);
        Assertions.assertNull((Object)ch.readInbound());
    }

    protected ByteBuf input(byte[] input) {
        return Unpooled.wrappedBuffer((byte[])input);
    }

    @Test
    public void testFragmentedUnmarshalling() throws IOException {
        MarshallerFactory marshallerFactory = this.createMarshallerFactory();
        MarshallingConfiguration configuration = this.createMarshallingConfig();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{this.createDecoder(Integer.MAX_VALUE)});
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Marshaller marshaller = marshallerFactory.createMarshaller(configuration);
        marshaller.start(Marshalling.createByteOutput((OutputStream)bout));
        marshaller.writeObject((Object)this.testObject);
        marshaller.finish();
        marshaller.close();
        byte[] testBytes = bout.toByteArray();
        ByteBuf buffer = this.input(testBytes);
        ByteBuf slice = buffer.readRetainedSlice(2);
        ch.writeInbound(new Object[]{slice});
        ch.writeInbound(new Object[]{buffer});
        Assertions.assertTrue((boolean)ch.finish());
        String unmarshalled = (String)ch.readInbound();
        Assertions.assertEquals((Object)this.testObject, (Object)unmarshalled);
        Assertions.assertNull((Object)ch.readInbound());
    }

    @Test
    public void testTooBigObject() throws IOException {
        MarshallerFactory marshallerFactory = this.createMarshallerFactory();
        MarshallingConfiguration configuration = this.createMarshallingConfig();
        ChannelHandler mDecoder = this.createDecoder(4);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{mDecoder});
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Marshaller marshaller = marshallerFactory.createMarshaller(configuration);
        marshaller.start(Marshalling.createByteOutput((OutputStream)bout));
        marshaller.writeObject((Object)this.testObject);
        marshaller.finish();
        marshaller.close();
        byte[] testBytes = bout.toByteArray();
        this.onTooBigFrame(ch, this.input(testBytes));
    }

    protected void onTooBigFrame(EmbeddedChannel ch, ByteBuf input) {
        ch.writeInbound(new Object[]{input});
        Assertions.assertFalse((boolean)ch.isActive());
    }

    protected ChannelHandler createDecoder(int maxObjectSize) {
        return new CompatibleMarshallingDecoder(this.createProvider(this.createMarshallerFactory(), this.createMarshallingConfig()), maxObjectSize);
    }

    protected UnmarshallerProvider createProvider(MarshallerFactory factory, MarshallingConfiguration config) {
        return new DefaultUnmarshallerProvider(factory, config);
    }

    protected abstract MarshallerFactory createMarshallerFactory();

    protected abstract MarshallingConfiguration createMarshallingConfig();
}

