/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling;

import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.CodecException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.TooLongFrameException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling.MarshallingDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling.SerialCompatibleMarshallingDecoderTest;

public class SerialMarshallingDecoderTest
extends SerialCompatibleMarshallingDecoderTest {
    @Override
    protected ByteBuf input(byte[] input) {
        ByteBuf length = Unpooled.buffer((int)4);
        length.writeInt(input.length);
        return Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{length, Unpooled.wrappedBuffer((byte[])input)});
    }

    @Override
    protected ChannelHandler createDecoder(int maxObjectSize) {
        return new MarshallingDecoder(this.createProvider(this.createMarshallerFactory(), this.createMarshallingConfig()), maxObjectSize);
    }

    @Override
    protected void onTooBigFrame(EmbeddedChannel ch, ByteBuf input) {
        try {
            ch.writeInbound(new Object[]{input});
            Assertions.fail();
        }
        catch (CodecException e) {
            Assertions.assertEquals(TooLongFrameException.class, ((Object)((Object)e)).getClass());
        }
    }
}

