/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

final class DelayingExecutor
implements Executor {
    private static final int CORE_POOL_SIZE = 10;
    private final ScheduledExecutorService service;

    DelayingExecutor() {
        this.service = Executors.newScheduledThreadPool(10);
    }

    DelayingExecutor(ThreadFactory threadFactory) {
        this.service = Executors.newScheduledThreadPool(10, threadFactory);
    }

    @Override
    public void execute(Runnable command) {
        this.service.schedule(command, (long)PlatformDependent.threadLocalRandom().nextInt(100), TimeUnit.MILLISECONDS);
    }

    void shutdown() {
        this.service.shutdown();
    }
}

