/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.security.Provider;
import javax.net.ssl.SSLSessionContext;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIf;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.Conscrypt;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.Java8SslTestUtils;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SSLEngineTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;

@DisabledIf(value="checkConscryptDisabled")
public class JdkConscryptSslEngineInteropTest
extends SSLEngineTest {
    static boolean checkConscryptDisabled() {
        return !Conscrypt.isAvailable();
    }

    public JdkConscryptSslEngineInteropTest() {
        super(false);
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected Provider serverSslContextProvider() {
        return Java8SslTestUtils.conscryptProvider();
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="TODO: Make this work with Conscrypt")
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(param);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="TODO: Make this work with Conscrypt")
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(param);
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidClientException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidClientException(cause) || JdkConscryptSslEngineInteropTest.causedBySSLException(cause);
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Ignore due bug in Conscrypt")
    public void testHandshakeSession(SSLEngineTest.SSLEngineTestParam param) throws Exception {
    }

    @Override
    protected void invalidateSessionsAndAssert(SSLSessionContext context) {
    }

    @Override
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Disabled(value="Possible Conscrypt bug")
    public void testSessionCacheTimeout(SSLEngineTest.SSLEngineTestParam param) {
    }

    @Override
    @Disabled(value="Not supported")
    public void testRSASSAPSS(SSLEngineTest.SSLEngineTestParam param) {
    }

    @Override
    @Test
    @Disabled(value="Disabled due a conscrypt bug")
    public void testTLSv13DisabledIfNoValidCipherSuiteConfigured() throws Exception {
        super.testTLSv13DisabledIfNoValidCipherSuiteConfigured();
    }

    @Override
    @Disabled(value="Disabled due a conscrypt bug")
    public void mustCallResumeTrustedOnSessionResumption(SSLEngineTest.SSLEngineTestParam param) throws Exception {
        super.mustCallResumeTrustedOnSessionResumption(param);
    }
}

