/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.SecretKey;
import javax.net.ssl.ExtendedSSLSession;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.KeyManagerFactorySpi;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionBindingEvent;
import javax.net.ssl.SSLSessionBindingListener;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import org.conscrypt.OpenSSLProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.SocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ApplicationProtocolConfig;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.CipherSuiteFilter;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ClientAuth;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.Conscrypt;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ConstantTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.DelayingExecutor;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.EmptyExtendedX509TrustManager;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.IdentityCipherSuiteFilter;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.JdkAlpnSslEngine;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.ResumableX509ExtendedTrustManager;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandshakeCompletionEvent;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslMasterKeyHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslUtils;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SupportedCipherSuiteFilter;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.CachedSelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.NetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.ImmediateEventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.PromiseNotifier;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ResourcesUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.SystemPropertyUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLogger;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import org.opentest4j.AssertionFailedError;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class SSLEngineTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SSLEngineTest.class);
    private static final String PRINCIPAL_NAME = "CN=e8ac02fa0d65a84219016045db8b05c485b4ecdf.netty.test";
    private static final Runnable NOOP = new Runnable(){

        @Override
        public void run() {
        }
    };
    private final boolean tlsv13Supported;
    protected MessageReceiver serverReceiver;
    protected MessageReceiver clientReceiver;
    protected volatile Throwable serverException;
    protected volatile Throwable clientException;
    protected SslContext serverSslCtx;
    protected SslContext clientSslCtx;
    protected ServerBootstrap sb;
    protected Bootstrap cb;
    protected Channel serverChannel;
    protected Channel serverConnectedChannel;
    protected Channel clientChannel;
    protected CountDownLatch serverLatch;
    protected CountDownLatch clientLatch;
    protected volatile Future<Channel> serverSslHandshakeFuture;
    protected volatile Future<Channel> clientSslHandshakeFuture;
    private DelayingExecutor delegatingExecutor;

    protected SSLEngineTest(boolean tlsv13Supported) {
        this.tlsv13Supported = tlsv13Supported;
    }

    protected List<SSLEngineTestParam> newTestParams() {
        ArrayList<SSLEngineTestParam> params = new ArrayList<SSLEngineTestParam>();
        for (BufferType type : BufferType.values()) {
            params.add(new SSLEngineTestParam(type, ProtocolCipherCombo.tlsv12(), false));
            params.add(new SSLEngineTestParam(type, ProtocolCipherCombo.tlsv12(), true));
            if (!this.tlsv13Supported) continue;
            params.add(new SSLEngineTestParam(type, ProtocolCipherCombo.tlsv13(), false));
            params.add(new SSLEngineTestParam(type, ProtocolCipherCombo.tlsv13(), true));
        }
        return params;
    }

    protected ByteBuffer allocateBuffer(BufferType type, int len) {
        switch (type) {
            case Direct: {
                return ByteBuffer.allocateDirect(len);
            }
            case Heap: {
                return ByteBuffer.allocate(len);
            }
            case Mixed: {
                return PlatformDependent.threadLocalRandom().nextBoolean() ? ByteBuffer.allocateDirect(len) : ByteBuffer.allocate(len);
            }
        }
        throw new Error();
    }

    @BeforeEach
    public void setup() {
        this.serverLatch = new CountDownLatch(1);
        this.clientLatch = new CountDownLatch(1);
        this.delegatingExecutor = new DelayingExecutor();
        this.serverReceiver = new MessageReceiver();
        this.clientReceiver = new MessageReceiver();
    }

    @AfterEach
    public void tearDown() throws InterruptedException {
        ChannelFuture clientCloseFuture = null;
        ChannelFuture serverConnectedCloseFuture = null;
        ChannelFuture serverCloseFuture = null;
        if (this.clientChannel != null) {
            clientCloseFuture = this.clientChannel.close();
            this.clientChannel = null;
        }
        if (this.serverConnectedChannel != null) {
            serverConnectedCloseFuture = this.serverConnectedChannel.close();
            this.serverConnectedChannel = null;
        }
        if (this.serverChannel != null) {
            serverCloseFuture = this.serverChannel.close();
            this.serverChannel = null;
        }
        if (clientCloseFuture != null) {
            clientCloseFuture.sync();
        }
        if (serverConnectedCloseFuture != null) {
            serverConnectedCloseFuture.sync();
        }
        if (serverCloseFuture != null) {
            serverCloseFuture.sync();
        }
        if (this.serverSslCtx != null) {
            this.cleanupServerSslContext(this.serverSslCtx);
            this.serverSslCtx = null;
        }
        if (this.clientSslCtx != null) {
            this.cleanupClientSslContext(this.clientSslCtx);
            this.clientSslCtx = null;
        }
        Future serverGroupShutdownFuture = null;
        Future serverChildGroupShutdownFuture = null;
        Future clientGroupShutdownFuture = null;
        if (this.sb != null) {
            serverGroupShutdownFuture = this.sb.config().group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            serverChildGroupShutdownFuture = this.sb.config().childGroup().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        if (this.cb != null) {
            clientGroupShutdownFuture = this.cb.config().group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
        if (serverGroupShutdownFuture != null) {
            serverGroupShutdownFuture.sync();
            serverChildGroupShutdownFuture.sync();
        }
        if (clientGroupShutdownFuture != null) {
            clientGroupShutdownFuture.sync();
        }
        this.delegatingExecutor.shutdown();
        this.serverException = null;
        this.clientException = null;
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthSameCerts(SSLEngineTestParam param) throws Throwable {
        this.mySetupMutualAuth(param, ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem"), ResourcesUtil.getFile(this.getClass(), (String)"test.crt"), null);
        this.runTest(null);
        Assertions.assertTrue((boolean)this.serverLatch.await(2L, TimeUnit.SECONDS));
        Throwable cause = this.serverException;
        if (cause != null) {
            throw cause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSetSupportedCiphers(SSLEngineTestParam param) throws Exception {
        if (param.protocolCipherCombo != ProtocolCipherCombo.tlsv12()) {
            return;
        }
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).protocols(param.protocols()).ciphers(param.ciphers()).sslProvider(this.sslServerProvider()).build());
        SSLEngine serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(cert.certificate()).protocols(param.protocols()).ciphers(param.ciphers()).sslProvider(this.sslClientProvider()).build());
        SSLEngine clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        Object[] enabledCiphers = new String[]{param.ciphers().get(0)};
        try {
            clientEngine.setEnabledCipherSuites((String[])enabledCiphers);
            serverEngine.setEnabledCipherSuites((String[])enabledCiphers);
            Assertions.assertArrayEquals((Object[])enabledCiphers, (Object[])clientEngine.getEnabledCipherSuites());
            Assertions.assertArrayEquals((Object[])enabledCiphers, (Object[])serverEngine.getEnabledCipherSuites());
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testIncompatibleCiphers(final SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)this.sslClientProvider()));
        Assumptions.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)this.sslServerProvider()));
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(new String[]{"TLSv1.3", "TLSv1.2", "TLSv1"}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).protocols(new String[]{"TLSv1.3", "TLSv1.2", "TLSv1"}).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            String serverCipher = "TLS_RSA_WITH_AES_128_CBC_SHA";
            serverEngine.setEnabledCipherSuites(new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA"});
            String clientCipher = "TLS_AES_256_GCM_SHA384";
            clientEngine.setEnabledCipherSuites(new String[]{"TLS_AES_256_GCM_SHA384"});
            final SSLEngine client = clientEngine;
            final SSLEngine server = serverEngine;
            Assertions.assertThrows(SSLHandshakeException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    SSLEngineTest.this.handshake(param.type(), param.delegate(), client, server);
                }
            });
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthDiffCerts(SSLEngineTestParam param) throws Exception {
        File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted.pem");
        File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        String serverKeyPassword = "12345";
        File clientKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_encrypted.pem");
        File clientCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        String clientKeyPassword = "12345";
        this.mySetupMutualAuth(param, clientCrtFile, serverKeyFile, serverCrtFile, serverKeyPassword, serverCrtFile, clientKeyFile, clientCrtFile, clientKeyPassword);
        this.runTest(null);
        Assertions.assertTrue((boolean)this.serverLatch.await(2L, TimeUnit.SECONDS));
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthDiffCertsServerFailure(SSLEngineTestParam param) throws Exception {
        File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted.pem");
        File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        String serverKeyPassword = "12345";
        File clientKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_encrypted.pem");
        File clientCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        String clientKeyPassword = "12345";
        this.mySetupMutualAuth(param, serverCrtFile, serverKeyFile, serverCrtFile, serverKeyPassword, serverCrtFile, clientKeyFile, clientCrtFile, clientKeyPassword);
        Assertions.assertTrue((boolean)this.serverLatch.await(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)(this.serverException instanceof SSLHandshakeException));
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthDiffCertsClientFailure(SSLEngineTestParam param) throws Exception {
        File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        String serverKeyPassword = null;
        File clientKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_unencrypted.pem");
        File clientCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        String clientKeyPassword = null;
        this.mySetupMutualAuth(param, clientCrtFile, serverKeyFile, serverCrtFile, serverKeyPassword, clientCrtFile, clientKeyFile, clientCrtFile, clientKeyPassword);
        Assertions.assertTrue((boolean)this.clientLatch.await(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)(this.clientException instanceof SSLHandshakeException));
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth(SSLEngineTestParam param) throws Exception {
        this.testMutualAuthInvalidClientCertSucceed(param, ClientAuth.NONE);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth(SSLEngineTestParam param) throws Exception {
        this.testMutualAuthClientCertFail(param, ClientAuth.OPTIONAL);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth(SSLEngineTestParam param) throws Exception {
        this.testMutualAuthClientCertFail(param, ClientAuth.REQUIRE);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth(SSLEngineTestParam param) throws Exception {
        this.testMutualAuthClientCertFail(param, ClientAuth.OPTIONAL, "mutual_auth_client.p12", true);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth(SSLEngineTestParam param) throws Exception {
        this.testMutualAuthClientCertFail(param, ClientAuth.REQUIRE, "mutual_auth_client.p12", true);
    }

    private void testMutualAuthInvalidClientCertSucceed(SSLEngineTestParam param, ClientAuth auth) throws Exception {
        char[] password = "example".toCharArray();
        KeyStore serverKeyStore = KeyStore.getInstance("PKCS12");
        serverKeyStore.load(this.getClass().getResourceAsStream("mutual_auth_server.p12"), password);
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
        clientKeyStore.load(this.getClass().getResourceAsStream("mutual_auth_invalid_client.p12"), password);
        KeyManagerFactory serverKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        serverKeyManagerFactory.init(serverKeyStore, password);
        KeyManagerFactory clientKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        clientKeyManagerFactory.init(clientKeyStore, password);
        File commonCertChain = ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem");
        this.mySetupMutualAuth(param, serverKeyManagerFactory, commonCertChain, clientKeyManagerFactory, commonCertChain, auth, false, false);
        Assertions.assertTrue((boolean)this.clientLatch.await(10L, TimeUnit.SECONDS));
        SSLEngineTest.rethrowIfNotNull(this.clientException);
        Assertions.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        SSLEngineTest.rethrowIfNotNull(this.serverException);
    }

    private void testMutualAuthClientCertFail(SSLEngineTestParam param, ClientAuth auth) throws Exception {
        this.testMutualAuthClientCertFail(param, auth, "mutual_auth_invalid_client.p12", false);
    }

    private void testMutualAuthClientCertFail(SSLEngineTestParam param, ClientAuth auth, String clientCert, boolean serverInitEngine) throws Exception {
        char[] password = "example".toCharArray();
        KeyStore serverKeyStore = KeyStore.getInstance("PKCS12");
        serverKeyStore.load(this.getClass().getResourceAsStream("mutual_auth_server.p12"), password);
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
        clientKeyStore.load(this.getClass().getResourceAsStream(clientCert), password);
        KeyManagerFactory serverKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        serverKeyManagerFactory.init(serverKeyStore, password);
        KeyManagerFactory clientKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        clientKeyManagerFactory.init(clientKeyStore, password);
        File commonCertChain = ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem");
        this.mySetupMutualAuth(param, serverKeyManagerFactory, commonCertChain, clientKeyManagerFactory, commonCertChain, auth, true, serverInitEngine);
        Assertions.assertTrue((boolean)this.clientLatch.await(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.mySetupMutualAuthServerIsValidClientException(this.clientException), (String)("unexpected exception: " + this.clientException));
        Assertions.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.mySetupMutualAuthServerIsValidServerException(this.serverException), (String)("unexpected exception: " + this.serverException));
    }

    protected static boolean causedBySSLException(Throwable cause) {
        Throwable next = cause;
        do {
            if (!(next instanceof SSLException)) continue;
            return true;
        } while ((next = next.getCause()) != null);
        return false;
    }

    protected boolean mySetupMutualAuthServerIsValidServerException(Throwable cause) {
        return this.mySetupMutualAuthServerIsValidException(cause);
    }

    protected boolean mySetupMutualAuthServerIsValidClientException(Throwable cause) {
        return this.mySetupMutualAuthServerIsValidException(cause);
    }

    protected boolean mySetupMutualAuthServerIsValidException(Throwable cause) {
        return cause instanceof SSLException || cause instanceof ClosedChannelException;
    }

    protected void mySetupMutualAuthServerInitSslHandler(SslHandler handler) {
    }

    protected void mySetupMutualAuth(final SSLEngineTestParam param, KeyManagerFactory serverKMF, File serverTrustManager, KeyManagerFactory clientKMF, File clientTrustManager, ClientAuth clientAuth, final boolean failureExpected, final boolean serverInitEngine) throws SSLException, InterruptedException {
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((KeyManagerFactory)serverKMF).protocols(param.protocols()).ciphers(param.ciphers()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).trustManager(serverTrustManager).clientAuth(clientAuth).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().protocols(param.protocols()).ciphers(param.ciphers()).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).trustManager(clientTrustManager).keyManager(clientKMF).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                SslHandler handler;
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type()));
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = handler = !param.delegate ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                if (serverInitEngine) {
                    SSLEngineTest.this.mySetupMutualAuthServerInitSslHandler(handler);
                }
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (failureExpected) {
                                SSLEngineTest.this.serverException = new IllegalStateException("handshake complete. expected failure");
                            }
                            SSLEngineTest.this.serverLatch.countDown();
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.serverException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.serverLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            SSLEngineTest.this.serverException = cause;
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler handler = !param.delegate ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (!failureExpected) {
                                SSLEngineTest.this.clientLatch.countDown();
                            }
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.clientException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.clientLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
        int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        ChannelFuture ccf = this.cb.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, port));
        Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
    }

    protected static void rethrowIfNotNull(Throwable error) {
        if (error != null) {
            throw new AssertionFailedError("Expected no error", error);
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testClientHostnameValidationSuccess(SSLEngineTestParam param) throws Exception {
        this.mySetupClientHostnameValidation(param, ResourcesUtil.getFile(this.getClass(), (String)"localhost_server.pem"), ResourcesUtil.getFile(this.getClass(), (String)"localhost_server.key"), ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem"), false);
        Assertions.assertTrue((boolean)this.clientLatch.await(10L, TimeUnit.SECONDS));
        SSLEngineTest.rethrowIfNotNull(this.clientException);
        Assertions.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        SSLEngineTest.rethrowIfNotNull(this.serverException);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testClientHostnameValidationFail(SSLEngineTestParam param) throws Exception {
        Future<Void> clientWriteFuture = this.mySetupClientHostnameValidation(param, ResourcesUtil.getFile(this.getClass(), (String)"notlocalhost_server.pem"), ResourcesUtil.getFile(this.getClass(), (String)"notlocalhost_server.key"), ResourcesUtil.getFile(this.getClass(), (String)"mutual_auth_ca.pem"), true);
        Assertions.assertTrue((boolean)this.clientLatch.await(10L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.mySetupMutualAuthServerIsValidClientException(this.clientException), (String)("unexpected exception: " + this.clientException));
        Assertions.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)this.mySetupMutualAuthServerIsValidServerException(this.serverException), (String)("unexpected exception: " + this.serverException));
        clientWriteFuture.awaitUninterruptibly();
        Throwable actualCause = clientWriteFuture.cause();
        Assertions.assertSame((Object)this.clientException, (Object)actualCause);
    }

    private Future<Void> mySetupClientHostnameValidation(final SSLEngineTestParam param, File serverCrtFile, File serverKeyFile, File clientTrustCrtFile, final boolean failureExpected) throws SSLException, InterruptedException {
        String expectedHost = "localhost";
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)serverCrtFile, (File)serverKeyFile, null).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).sslContextProvider(this.serverSslContextProvider()).trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).sslContextProvider(this.clientSslContextProvider()).trustManager(clientTrustCrtFile).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler handler = !param.delegate ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (failureExpected) {
                                SSLEngineTest.this.serverException = new IllegalStateException("handshake complete. expected failure");
                            }
                            SSLEngineTest.this.serverLatch.countDown();
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.serverException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.serverLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            SSLEngineTest.this.serverException = cause;
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        final Promise clientWritePromise = ImmediateEventExecutor.INSTANCE.newPromise();
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type));
                ChannelPipeline p = ch.pipeline();
                InetSocketAddress remoteAddress = (InetSocketAddress)SSLEngineTest.this.serverChannel.localAddress();
                SslHandler sslHandler = !param.delegate ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), "localhost", 0) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), "localhost", 0, (Executor)SSLEngineTest.this.delegatingExecutor);
                SSLParameters parameters = sslHandler.engine().getSSLParameters();
                if (SslUtils.isValidHostNameForSNI((String)"localhost")) {
                    Assertions.assertEquals((int)1, (int)parameters.getServerNames().size());
                    Assertions.assertEquals((Object)new SNIHostName("localhost"), (Object)parameters.getServerNames().get(0));
                }
                parameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslHandler.engine().setSSLParameters(parameters);
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void handlerAdded(ChannelHandlerContext ctx) {
                        if (failureExpected) {
                            ChannelFuture f = ctx.write((Object)ctx.alloc().buffer(1).writeByte(1));
                            PromiseNotifier.cascade((Future)f, (Promise)clientWritePromise);
                        }
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            if (failureExpected) {
                                SSLEngineTest.this.clientException = new IllegalStateException("handshake complete. expected failure");
                            }
                            SSLEngineTest.this.clientLatch.countDown();
                        } else if (evt instanceof SslHandshakeCompletionEvent) {
                            SSLEngineTest.this.clientException = ((SslHandshakeCompletionEvent)evt).cause();
                            SSLEngineTest.this.clientLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress("localhost", 0)).sync().channel();
        int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        ChannelFuture ccf = this.cb.connect((SocketAddress)new InetSocketAddress("localhost", port));
        Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        return clientWritePromise;
    }

    private void mySetupMutualAuth(SSLEngineTestParam param, File keyFile, File crtFile, String keyPassword) throws SSLException, InterruptedException {
        this.mySetupMutualAuth(param, crtFile, keyFile, crtFile, keyPassword, crtFile, keyFile, crtFile, keyPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySSLSessionForMutualAuth(SSLEngineTestParam param, SSLSession session, File certFile, String principalName) throws Exception {
        InputStream in = null;
        try {
            Assertions.assertEquals((Object)principalName, (Object)session.getLocalPrincipal().getName());
            Assertions.assertEquals((Object)principalName, (Object)session.getPeerPrincipal().getName());
            Assertions.assertNotNull((Object)session.getId());
            Assertions.assertEquals((Object)param.combo().cipher, (Object)session.getCipherSuite());
            Assertions.assertEquals((Object)param.combo().protocol, (Object)session.getProtocol());
            Assertions.assertTrue((session.getApplicationBufferSize() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((session.getCreationTime() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)session.isValid());
            Assertions.assertTrue((session.getLastAccessedTime() > 0L ? 1 : 0) != 0);
            in = new FileInputStream(certFile);
            byte[] certBytes = SslContext.X509_CERT_FACTORY.generateCertificate(in).getEncoded();
            Assertions.assertEquals((int)1, (int)session.getPeerCertificates().length);
            Assertions.assertArrayEquals((byte[])certBytes, (byte[])session.getPeerCertificates()[0].getEncoded());
            try {
                Assertions.assertEquals((int)1, (int)session.getPeerCertificateChain().length);
                Assertions.assertArrayEquals((byte[])certBytes, (byte[])session.getPeerCertificateChain()[0].getEncoded());
            }
            catch (UnsupportedOperationException e) {
                Assertions.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
            }
            Assertions.assertEquals((int)1, (int)session.getLocalCertificates().length);
            Assertions.assertArrayEquals((byte[])certBytes, (byte[])session.getLocalCertificates()[0].getEncoded());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private void mySetupMutualAuth(final SSLEngineTestParam param, File servertTrustCrtFile, File serverKeyFile, final File serverCrtFile, String serverKeyPassword, File clientTrustCrtFile, File clientKeyFile, final File clientCrtFile, String clientKeyPassword) throws InterruptedException, SSLException {
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)serverCrtFile, (File)serverKeyFile, (String)serverKeyPassword).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).trustManager(servertTrustCrtFile).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).trustManager(clientTrustCrtFile).keyManager(clientCrtFile, clientKeyFile, clientKeyPassword).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L).build());
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.cb = new Bootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type));
                ChannelPipeline p = ch.pipeline();
                final SSLEngine engine = SSLEngineTest.this.wrapEngine(SSLEngineTest.this.serverSslCtx.newEngine(ch.alloc()));
                engine.setUseClientMode(false);
                engine.setNeedClientAuth(true);
                p.addLast(new ChannelHandler[]{new SslHandler(engine)});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            SSLEngineTest.this.serverException = cause;
                            ctx.fireExceptionCaught(cause);
                        }
                    }

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            try {
                                SSLEngineTest.this.verifySSLSessionForMutualAuth(param, engine.getSession(), serverCrtFile, SSLEngineTest.PRINCIPAL_NAME);
                            }
                            catch (Throwable cause) {
                                SSLEngineTest.this.serverException = cause;
                            }
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type));
                final SslHandler handler = !param.delegate ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                handler.engine().setNeedClientAuth(true);
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        if (evt == SslHandshakeCompletionEvent.SUCCESS) {
                            try {
                                SSLEngineTest.this.verifySSLSessionForMutualAuth(param, handler.engine().getSession(), clientCrtFile, SSLEngineTest.PRINCIPAL_NAME);
                            }
                            catch (Throwable cause) {
                                SSLEngineTest.this.clientException = cause;
                            }
                        }
                    }

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
        int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
        ChannelFuture ccf = this.cb.connect((SocketAddress)new InetSocketAddress(NetUtil.LOCALHOST, port));
        Assertions.assertTrue((boolean)ccf.awaitUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest(String expectedApplicationProtocol) throws Exception {
        ByteBuf clientMessage = Unpooled.copiedBuffer((byte[])"I am a client".getBytes());
        ByteBuf serverMessage = Unpooled.copiedBuffer((byte[])"I am a server".getBytes());
        try {
            SSLEngineTest.writeAndVerifyReceived(clientMessage.retain(), this.clientChannel, this.serverLatch, this.serverReceiver);
            SSLEngineTest.writeAndVerifyReceived(serverMessage.retain(), this.serverConnectedChannel, this.clientLatch, this.clientReceiver);
            SSLEngineTest.verifyApplicationLevelProtocol(this.clientChannel, expectedApplicationProtocol);
            SSLEngineTest.verifyApplicationLevelProtocol(this.serverConnectedChannel, expectedApplicationProtocol);
        }
        finally {
            clientMessage.release();
            serverMessage.release();
        }
    }

    private static void verifyApplicationLevelProtocol(Channel channel, String expectedApplicationProtocol) {
        SslHandler handler = (SslHandler)channel.pipeline().get(SslHandler.class);
        Assertions.assertNotNull((Object)handler);
        String appProto = handler.applicationProtocol();
        Assertions.assertEquals((Object)expectedApplicationProtocol, (Object)appProto);
        SSLEngine engine = handler.engine();
        if (engine instanceof JdkAlpnSslEngine) {
            JdkAlpnSslEngine java9SslEngine = (JdkAlpnSslEngine)engine;
            Assertions.assertEquals((Object)(expectedApplicationProtocol == null ? "" : expectedApplicationProtocol), (Object)java9SslEngine.getApplicationProtocol());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeAndVerifyReceived(ByteBuf message, Channel sendChannel, CountDownLatch receiverLatch, MessageReceiver receiver) throws Exception {
        ArrayList dataCapture = null;
        try {
            Assertions.assertTrue((boolean)sendChannel.writeAndFlush((Object)message).await(10L, TimeUnit.SECONDS));
            receiverLatch.await(5L, TimeUnit.SECONDS);
            message.resetReaderIndex();
            Assertions.assertFalse((boolean)receiver.messages.isEmpty());
            dataCapture = new ArrayList();
            receiver.messages.drainTo(dataCapture);
            Assertions.assertEquals((Object)message, dataCapture.get(0));
        }
        finally {
            if (dataCapture != null) {
                for (ByteBuf data : dataCapture) {
                    data.release();
                }
            }
        }
    }

    @Test
    public void testGetCreationTime() throws Exception {
        this.clientSslCtx = this.wrapContext(null, SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).build());
        SSLEngine engine = null;
        try {
            engine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            Assertions.assertTrue((engine.getSession().getCreationTime() <= System.currentTimeMillis() ? 1 : 0) != 0);
            this.cleanupClientSslEngine(engine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(engine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionInvalidate(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            SSLSession session = serverEngine.getSession();
            Assertions.assertTrue((boolean)session.isValid());
            session.invalidate();
            Assertions.assertFalse((boolean)session.isValid());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSSLSessionId(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(param.protocols()).sslContextProvider(this.clientSslContextProvider()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).sslContextProvider(this.serverSslContextProvider()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            Assertions.assertEquals((int)0, (int)clientEngine.getSession().getId().length);
            Assertions.assertEquals((int)0, (int)serverEngine.getSession().getId().length);
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            if (param.protocolCipherCombo == ProtocolCipherCombo.TLSV13) {
                ByteBuffer packetBuffer = this.allocateBuffer(param.type(), 32768);
                ByteBuffer appBuffer = this.allocateBuffer(param.type(), 32768);
                appBuffer.clear().position(4).flip();
                packetBuffer.clear();
                while (true) {
                    SSLEngineResult result = serverEngine.wrap(appBuffer, packetBuffer);
                    if (appBuffer.hasRemaining() || result.bytesProduced() > 0) continue;
                    appBuffer.clear();
                    packetBuffer.flip();
                    do {
                        result = clientEngine.unwrap(packetBuffer, appBuffer);
                    } while (packetBuffer.hasRemaining() || result.bytesProduced() > 0);
                    packetBuffer.clear();
                    appBuffer.clear().position(4).flip();
                    do {
                        result = clientEngine.wrap(appBuffer, packetBuffer);
                    } while (appBuffer.hasRemaining() || result.bytesProduced() > 0);
                    appBuffer.clear();
                    packetBuffer.flip();
                    do {
                        result = serverEngine.unwrap(packetBuffer, appBuffer);
                    } while (packetBuffer.hasRemaining() || result.bytesProduced() > 0);
                    packetBuffer.clear();
                    appBuffer.clear().position(4).flip();
                    if (clientEngine.getSession().getId().length != 0) break;
                }
                Assertions.assertFalse((boolean)Arrays.equals(clientEngine.getSession().getId(), serverEngine.getSession().getId()));
            } else {
                Assertions.assertNotEquals((int)0, (int)clientEngine.getSession().getId().length);
                Assertions.assertNotEquals((int)0, (int)serverEngine.getSession().getId().length);
                Assertions.assertArrayEquals((byte[])clientEngine.getSession().getId(), (byte[])serverEngine.getSession().getId());
            }
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Timeout(value=30L)
    public void clientInitiatedRenegotiationWithFatalAlertDoesNotInfiniteLoopServer(final SSLEngineTestParam param) throws Exception {
        Assumptions.assumeTrue((PlatformDependent.javaVersion() >= 11 ? 1 : 0) != 0);
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1)).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type));
                ChannelPipeline p = ch.pipeline();
                SslHandler handler = !param.delegate ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                p.addLast(new ChannelHandler[]{handler});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt instanceof SslHandshakeCompletionEvent && ((SslHandshakeCompletionEvent)evt).isSuccess()) {
                            ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(100));
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void channelRead(final ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                        ctx.channel().eventLoop().schedule(new Runnable(){

                            @Override
                            public void run() {
                                ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(101));
                            }
                        }, 500L, TimeUnit.MILLISECONDS);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        SSLEngineTest.this.serverLatch.countDown();
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.cb = new Bootstrap();
        ((Bootstrap)((Bootstrap)this.cb.group((EventLoopGroup)new NioEventLoopGroup(1))).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type()));
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = !param.delegate ? SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.clientSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                sslHandler.setHandshakeTimeout(1L, TimeUnit.SECONDS);
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                    private int handshakeCount;

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt instanceof SslHandshakeCompletionEvent && ++this.handshakeCount == 2) {
                            ctx.close();
                            return;
                        }
                        ctx.fireUserEventTriggered(evt);
                    }

                    public void channelRead(ChannelHandlerContext ctx, Object msg) {
                        ReferenceCountUtil.release((Object)msg);
                        ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(102));
                        ((SslHandler)ctx.pipeline().get(SslHandler.class)).renegotiate();
                    }
                }});
            }
        });
        ChannelFuture ccf = this.cb.connect(this.serverChannel.localAddress());
        Assertions.assertTrue((boolean)ccf.syncUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
        this.serverLatch.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testEnablingAnAlreadyDisabledSslProtocol(SSLEngineTestParam param, String[] protocols1, String[] protocols2) throws Exception {
        SSLEngine sslEngine = null;
        try {
            File serverKeyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
            File serverCrtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
            this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)serverCrtFile, (File)serverKeyFile).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
            sslEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            sslEngine.setEnabledProtocols(EmptyArrays.EMPTY_STRINGS);
            Object[] enabledProtocols = sslEngine.getEnabledProtocols();
            Assertions.assertArrayEquals((Object[])protocols1, (Object[])enabledProtocols);
            sslEngine.setEnabledProtocols(new String[]{"TLSv1.2"});
            enabledProtocols = sslEngine.getEnabledProtocols();
            Assertions.assertEquals((int)protocols2.length, (int)enabledProtocols.length);
            Assertions.assertArrayEquals((Object[])protocols2, (Object[])enabledProtocols);
        }
        finally {
            if (sslEngine != null) {
                sslEngine.closeInbound();
                sslEngine.closeOutbound();
                this.cleanupServerSslEngine(sslEngine);
            }
        }
    }

    protected void handshake(BufferType type, boolean delegate, SSLEngine clientEngine, SSLEngine serverEngine) throws Exception {
        boolean sTOcHasRemaining;
        boolean cTOsHasRemaining;
        ByteBuffer cTOs = this.allocateBuffer(type, clientEngine.getSession().getPacketBufferSize());
        ByteBuffer sTOc = this.allocateBuffer(type, serverEngine.getSession().getPacketBufferSize());
        ByteBuffer serverAppReadBuffer = this.allocateBuffer(type, serverEngine.getSession().getApplicationBufferSize());
        ByteBuffer clientAppReadBuffer = this.allocateBuffer(type, clientEngine.getSession().getApplicationBufferSize());
        Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)clientEngine.getHandshakeStatus()));
        Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)serverEngine.getHandshakeStatus()));
        clientEngine.beginHandshake();
        serverEngine.beginHandshake();
        ByteBuffer empty = this.allocateBuffer(type, 0);
        boolean clientHandshakeFinished = false;
        boolean serverHandshakeFinished = false;
        do {
            SSLEngineResult serverResult;
            SSLEngineResult clientResult;
            int cTOsPos = cTOs.position();
            int sTOcPos = sTOc.position();
            if (!clientHandshakeFinished) {
                clientResult = clientEngine.wrap(empty, cTOs);
                this.runDelegatedTasks(delegate, clientResult, clientEngine);
                Assertions.assertEquals((int)empty.remaining(), (int)clientResult.bytesConsumed());
                Assertions.assertEquals((int)(cTOs.position() - cTOsPos), (int)clientResult.bytesProduced());
                clientHandshakeFinished = SSLEngineTest.assertHandshakeStatus(clientEngine, clientResult);
                if (clientResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    cTOs = this.increaseDstBuffer(clientEngine.getSession().getPacketBufferSize(), type, cTOs);
                }
            }
            if (!serverHandshakeFinished) {
                serverResult = serverEngine.wrap(empty, sTOc);
                this.runDelegatedTasks(delegate, serverResult, serverEngine);
                Assertions.assertEquals((int)empty.remaining(), (int)serverResult.bytesConsumed());
                Assertions.assertEquals((int)(sTOc.position() - sTOcPos), (int)serverResult.bytesProduced());
                serverHandshakeFinished = SSLEngineTest.assertHandshakeStatus(serverEngine, serverResult);
                if (serverResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    sTOc = this.increaseDstBuffer(serverEngine.getSession().getPacketBufferSize(), type, sTOc);
                }
            }
            cTOs.flip();
            sTOc.flip();
            cTOsPos = cTOs.position();
            sTOcPos = sTOc.position();
            if (!clientHandshakeFinished || "TLSv1.3".equals(clientEngine.getSession().getProtocol())) {
                if (sTOc.hasRemaining() || Conscrypt.isEngineSupported((SSLEngine)clientEngine)) {
                    int clientAppReadBufferPos = clientAppReadBuffer.position();
                    clientResult = clientEngine.unwrap(sTOc, clientAppReadBuffer);
                    this.runDelegatedTasks(delegate, clientResult, clientEngine);
                    Assertions.assertEquals((int)(sTOc.position() - sTOcPos), (int)clientResult.bytesConsumed());
                    Assertions.assertEquals((int)(clientAppReadBuffer.position() - clientAppReadBufferPos), (int)clientResult.bytesProduced());
                    Assertions.assertEquals((int)0, (int)clientAppReadBuffer.position());
                    if (SSLEngineTest.assertHandshakeStatus(clientEngine, clientResult)) {
                        clientHandshakeFinished = true;
                    }
                    if (clientResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        clientAppReadBuffer = this.increaseDstBuffer(clientEngine.getSession().getApplicationBufferSize(), type, clientAppReadBuffer);
                    }
                }
            } else {
                Assertions.assertEquals((int)0, (int)sTOc.remaining());
            }
            if (!serverHandshakeFinished) {
                if (cTOs.hasRemaining() || Conscrypt.isEngineSupported((SSLEngine)serverEngine)) {
                    int serverAppReadBufferPos = serverAppReadBuffer.position();
                    serverResult = serverEngine.unwrap(cTOs, serverAppReadBuffer);
                    this.runDelegatedTasks(delegate, serverResult, serverEngine);
                    Assertions.assertEquals((int)(cTOs.position() - cTOsPos), (int)serverResult.bytesConsumed());
                    Assertions.assertEquals((int)(serverAppReadBuffer.position() - serverAppReadBufferPos), (int)serverResult.bytesProduced());
                    Assertions.assertEquals((int)0, (int)serverAppReadBuffer.position());
                    serverHandshakeFinished = SSLEngineTest.assertHandshakeStatus(serverEngine, serverResult);
                    if (serverResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        serverAppReadBuffer = this.increaseDstBuffer(serverEngine.getSession().getApplicationBufferSize(), type, serverAppReadBuffer);
                    }
                }
            } else {
                Assertions.assertFalse((boolean)cTOs.hasRemaining());
            }
            cTOsHasRemaining = SSLEngineTest.compactOrClear(cTOs);
            sTOcHasRemaining = SSLEngineTest.compactOrClear(sTOc);
            serverAppReadBuffer.clear();
            clientAppReadBuffer.clear();
        } while (!clientHandshakeFinished || !serverHandshakeFinished || cTOsHasRemaining || sTOcHasRemaining);
    }

    private static boolean compactOrClear(ByteBuffer buffer) {
        if (buffer.hasRemaining()) {
            buffer.compact();
            return true;
        }
        buffer.clear();
        return false;
    }

    private ByteBuffer increaseDstBuffer(int maxBufferSize, BufferType type, ByteBuffer dstBuffer) {
        Assumptions.assumeFalse((maxBufferSize == dstBuffer.remaining() ? 1 : 0) != 0);
        dstBuffer.flip();
        ByteBuffer tmpBuffer = this.allocateBuffer(type, maxBufferSize + dstBuffer.remaining());
        tmpBuffer.put(dstBuffer);
        return tmpBuffer;
    }

    private static boolean assertHandshakeStatus(SSLEngine engine, SSLEngineResult result) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)engine.getHandshakeStatus()));
            return true;
        }
        return false;
    }

    private void runDelegatedTasks(boolean delegate, SSLEngineResult result, SSLEngine engine) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable task;
            while ((task = engine.getDelegatedTask()) != null) {
                if (!delegate) {
                    task.run();
                    continue;
                }
                this.delegatingExecutor.execute(task);
            }
        }
    }

    protected abstract SslProvider sslClientProvider();

    protected abstract SslProvider sslServerProvider();

    protected Provider clientSslContextProvider() {
        return null;
    }

    protected Provider serverSslContextProvider() {
        return null;
    }

    protected void cleanupClientSslContext(SslContext ctx) {
    }

    protected void cleanupServerSslContext(SslContext ctx) {
    }

    protected void cleanupClientSslEngine(SSLEngine engine) {
    }

    protected void cleanupServerSslEngine(SSLEngine engine) {
    }

    protected void setupHandlers(SSLEngineTestParam param, ApplicationProtocolConfig apn) throws InterruptedException, SSLException, CertificateException {
        this.setupHandlers(param, apn, apn);
    }

    protected void setupHandlers(SSLEngineTestParam param, ApplicationProtocolConfig serverApn, ApplicationProtocolConfig clientApn) throws InterruptedException, SSLException, CertificateException {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        SslContextBuilder serverCtxBuilder = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey(), null).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).applicationProtocolConfig(serverApn).sessionCacheSize(0L).sessionTimeout(0L);
        if (serverApn.protocol() == ApplicationProtocolConfig.Protocol.NPN || serverApn.protocol() == ApplicationProtocolConfig.Protocol.NPN_AND_ALPN) {
            serverCtxBuilder.protocols(new String[]{"TLSv1.2"});
        }
        SslContextBuilder clientCtxBuilder = SslContextBuilder.forClient().sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).applicationProtocolConfig(clientApn).trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE).sessionCacheSize(0L).sessionTimeout(0L);
        if (clientApn.protocol() == ApplicationProtocolConfig.Protocol.NPN || clientApn.protocol() == ApplicationProtocolConfig.Protocol.NPN_AND_ALPN) {
            clientCtxBuilder.protocols(new String[]{"TLSv1.2"});
        }
        this.setupHandlers(param.type(), param.delegate(), this.wrapContext(param, serverCtxBuilder.build()), this.wrapContext(param, clientCtxBuilder.build()));
    }

    protected void setupHandlers(BufferType type, boolean delegate, SslContext serverCtx, SslContext clientCtx) throws InterruptedException, SSLException, CertificateException {
        this.serverSslCtx = serverCtx;
        this.clientSslCtx = clientCtx;
        this.setupServer(type, delegate);
        this.setupClient(type, delegate, null, 0);
        ChannelFuture ccf = this.cb.connect(this.serverChannel.localAddress());
        Assertions.assertTrue((boolean)ccf.syncUninterruptibly().isSuccess());
        this.clientChannel = ccf.channel();
    }

    private void setupServer(final BufferType type, final boolean delegate) {
        this.serverConnectedChannel = null;
        this.sb = new ServerBootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), type));
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = !delegate ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                SSLEngineTest.this.serverSslHandshakeFuture = sslHandler.handshakeFuture();
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.serverReceiver, SSLEngineTest.this.serverLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.serverException = cause.getCause();
                            SSLEngineTest.this.serverLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        });
        this.serverChannel = this.sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
    }

    private void setupClient(final BufferType type, final boolean delegate, final String host, final int port) {
        this.cb = new Bootstrap();
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                TestByteBufAllocator alloc = new TestByteBufAllocator(ch.config().getAllocator(), type);
                ch.config().setAllocator((ByteBufAllocator)alloc);
                ChannelPipeline p = ch.pipeline();
                SslHandler sslHandler = !delegate ? (host != null ? SSLEngineTest.this.clientSslCtx.newHandler((ByteBufAllocator)alloc, host, port) : SSLEngineTest.this.clientSslCtx.newHandler((ByteBufAllocator)alloc)) : (host != null ? SSLEngineTest.this.clientSslCtx.newHandler((ByteBufAllocator)alloc, host, port, (Executor)SSLEngineTest.this.delegatingExecutor) : SSLEngineTest.this.clientSslCtx.newHandler((ByteBufAllocator)alloc, (Executor)SSLEngineTest.this.delegatingExecutor));
                SSLEngineTest.this.clientSslHandshakeFuture = sslHandler.handshakeFuture();
                p.addLast(new ChannelHandler[]{sslHandler});
                p.addLast(new ChannelHandler[]{new MessageDelegatorChannelHandler(SSLEngineTest.this.clientReceiver, SSLEngineTest.this.clientLatch)});
                p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                        if (cause.getCause() instanceof SSLHandshakeException) {
                            SSLEngineTest.this.clientException = cause.getCause();
                            SSLEngineTest.this.clientLatch.countDown();
                        } else {
                            ctx.fireExceptionCaught(cause);
                        }
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        SSLEngineTest.this.clientLatch.countDown();
                    }
                }});
            }
        });
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    @Timeout(value=30L)
    public void testMutualAuthSameCertChain(final SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate serverCert = new SelfSignedCertificate();
        SelfSignedCertificate clientCert = new SelfSignedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)serverCert.certificate(), (File)serverCert.privateKey()).trustManager(new X509Certificate[]{clientCert.cert()}).clientAuth(ClientAuth.REQUIRE).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.sb = new ServerBootstrap();
        this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
        this.sb.channel(NioServerSocketChannel.class);
        final Promise promise = this.sb.config().group().next().newPromise();
        this.serverChannel = this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type()));
                SslHandler sslHandler = !param.delegate ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                ch.pipeline().addFirst(new ChannelHandler[]{sslHandler});
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                        block10: {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                Throwable cause = ((SslHandshakeCompletionEvent)evt).cause();
                                if (cause == null) {
                                    SSLSession session = ((SslHandler)ctx.pipeline().first()).engine().getSession();
                                    Certificate[] peerCertificates = session.getPeerCertificates();
                                    if (peerCertificates == null) {
                                        promise.setFailure((Throwable)new NullPointerException("peerCertificates"));
                                        return;
                                    }
                                    try {
                                        javax.security.cert.X509Certificate[] peerCertificateChain = session.getPeerCertificateChain();
                                        if (peerCertificateChain == null) {
                                            promise.setFailure((Throwable)new NullPointerException("peerCertificateChain"));
                                            break block10;
                                        }
                                        if (peerCertificateChain.length + peerCertificates.length != 4) {
                                            String excTxtFmt = "peerCertificateChain.length:%s, peerCertificates.length:%s";
                                            promise.setFailure((Throwable)new IllegalStateException(String.format(excTxtFmt, peerCertificateChain.length, peerCertificates.length)));
                                            break block10;
                                        }
                                        for (int i = 0; i < peerCertificateChain.length; ++i) {
                                            if (peerCertificateChain[i] != null && peerCertificates[i] != null) continue;
                                            promise.setFailure((Throwable)new IllegalStateException("Certificate in chain is null"));
                                            return;
                                        }
                                        promise.setSuccess(null);
                                    }
                                    catch (UnsupportedOperationException e) {
                                        Assertions.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
                                        Assertions.assertEquals((int)2, (int)peerCertificates.length);
                                        for (int i = 0; i < peerCertificates.length; ++i) {
                                            if (peerCertificates[i] != null) continue;
                                            promise.setFailure((Throwable)new IllegalStateException("Certificate in chain is null"));
                                            return;
                                        }
                                        promise.setSuccess(null);
                                    }
                                } else {
                                    promise.setFailure(cause);
                                }
                            }
                        }
                    }
                }});
                SSLEngineTest.this.serverConnectedChannel = ch;
            }
        }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
        ByteArrayOutputStream chainStream = new ByteArrayOutputStream();
        chainStream.write(Files.readAllBytes(clientCert.certificate().toPath()));
        chainStream.write(Files.readAllBytes(serverCert.certificate().toPath()));
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().keyManager((InputStream)new ByteArrayInputStream(chainStream.toByteArray()), (InputStream)new FileInputStream(clientCert.privateKey())).trustManager((InputStream)new FileInputStream(serverCert.certificate())).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.cb = new Bootstrap();
        this.cb.group((EventLoopGroup)new NioEventLoopGroup());
        this.cb.channel(NioSocketChannel.class);
        this.clientChannel = ((Bootstrap)this.cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type()));
                ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(SSLEngineTest.this.wrapEngine(SSLEngineTest.this.clientSslCtx.newEngine(ch.alloc())))});
            }
        })).connect(this.serverChannel.localAddress()).syncUninterruptibly().channel();
        promise.syncUninterruptibly();
        serverCert.delete();
        clientCert.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testUnwrapBehavior(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        byte[] bytes = "Hello World".getBytes(CharsetUtil.US_ASCII);
        try {
            ByteBuffer plainClientOut = this.allocateBuffer(param.type, client.getSession().getApplicationBufferSize());
            ByteBuffer encryptedClientToServer = this.allocateBuffer(param.type, server.getSession().getPacketBufferSize() * 2);
            ByteBuffer plainServerIn = this.allocateBuffer(param.type, server.getSession().getApplicationBufferSize());
            this.handshake(param.type(), param.delegate(), client, server);
            plainClientOut.put(bytes, 0, 5);
            plainClientOut.flip();
            SSLEngineResult result = client.wrap(plainClientOut, encryptedClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)5, (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)plainClientOut.hasRemaining());
            plainClientOut.clear();
            plainClientOut.put(bytes, 5, 6);
            plainClientOut.flip();
            result = client.wrap(plainClientOut, encryptedClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)6, (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encryptedClientToServer.flip();
            int remaining = encryptedClientToServer.remaining();
            ByteBuffer small = this.allocateBuffer(param.type, 3);
            result = server.unwrap(encryptedClientToServer, small);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_OVERFLOW), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)remaining, (int)encryptedClientToServer.remaining());
            result = server.unwrap(encryptedClientToServer, plainServerIn);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)5, (int)result.bytesProduced());
            Assertions.assertTrue((boolean)encryptedClientToServer.hasRemaining());
            result = server.unwrap(encryptedClientToServer, plainServerIn);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)6, (int)result.bytesProduced());
            Assertions.assertFalse((boolean)encryptedClientToServer.hasRemaining());
            plainServerIn.flip();
            Assertions.assertEquals((Object)ByteBuffer.wrap(bytes), (Object)plainServerIn);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testProtocolMatch(SSLEngineTestParam param) throws Exception {
        this.testProtocol(param, false, new String[]{"TLSv1.2"}, new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testProtocolNoMatch(SSLEngineTestParam param) throws Exception {
        this.testProtocol(param, true, new String[]{"TLSv1.2"}, new String[]{"TLSv1", "TLSv1.1"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testProtocol(final SSLEngineTestParam param, boolean handshakeFails, String[] clientProtocols, String[] serverProtocols) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).protocols(clientProtocols).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).protocols(serverProtocols).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            if (handshakeFails) {
                final SSLEngine clientEngine = client;
                final SSLEngine serverEngine = server;
                Assertions.assertThrows(SSLHandshakeException.class, (Executable)new Executable(){

                    public void execute() throws Throwable {
                        SSLEngineTest.this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
                    }
                });
            } else {
                this.handshake(param.type(), param.delegate(), client, server);
            }
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    private String[] nonContiguousProtocols(SslProvider provider) {
        if (provider != null) {
            return new String[]{"TLSv1.2"};
        }
        return new String[]{"TLSv1.2", "TLSv1"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testHandshakeCompletesWithNonContiguousProtocolsTLSv1_2CipherOnly(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        String sharedCipher = "TLS_RSA_WITH_AES_128_CBC_SHA";
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA")).protocols(this.nonContiguousProtocols(this.sslClientProvider())).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA")).protocols(this.nonContiguousProtocols(this.sslServerProvider())).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testHandshakeCompletesWithoutFilteringSupportedCipher(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        String sharedCipher = "TLS_RSA_WITH_AES_128_CBC_SHA";
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA"), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols(this.nonContiguousProtocols(this.sslClientProvider())).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).ciphers(Collections.singletonList("TLS_RSA_WITH_AES_128_CBC_SHA"), (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).protocols(this.nonContiguousProtocols(this.sslServerProvider())).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testPacketBufferSizeLimit(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainServerOut = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize() * 2);
            this.handshake(param.type(), param.delegate(), client, server);
            plainServerOut.position(plainServerOut.capacity());
            plainServerOut.flip();
            ByteBuffer encryptedServerToClient = this.allocateBuffer(param.type(), server.getSession().getPacketBufferSize());
            int encryptedServerToClientPos = encryptedServerToClient.position();
            int plainServerOutPos = plainServerOut.position();
            SSLEngineResult result = server.wrap(plainServerOut, encryptedServerToClient);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)(plainServerOut.position() - plainServerOutPos), (int)result.bytesConsumed());
            Assertions.assertEquals((int)(encryptedServerToClient.position() - encryptedServerToClientPos), (int)result.bytesProduced());
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSSLEngineUnwrapNoSslRecord(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        final SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            final ByteBuffer src = this.allocateBuffer(param.type(), client.getSession().getApplicationBufferSize());
            final ByteBuffer dst = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            ByteBuffer empty = this.allocateBuffer(param.type(), 0);
            SSLEngineResult clientResult = client.wrap(empty, dst);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)clientResult.getStatus()));
            Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP), (Object)((Object)clientResult.getHandshakeStatus()));
            Assertions.assertThrows(SSLException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    client.unwrap(src, dst);
                }
            });
        }
        finally {
            this.cleanupClientSslEngine(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testBeginHandshakeAfterEngineClosed(SSLEngineTestParam param) throws SSLException {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            client.closeInbound();
            client.closeOutbound();
            try {
                client.beginHandshake();
                Assertions.fail();
            }
            catch (SSLException sSLException) {
            }
            catch (IllegalStateException e) {
                if (!Conscrypt.isEngineSupported((SSLEngine)client)) {
                    throw e;
                }
            }
        }
        finally {
            this.cleanupClientSslEngine(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testBeginHandshakeCloseOutbound(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            this.testBeginHandshakeCloseOutbound(param, client);
            this.testBeginHandshakeCloseOutbound(param, server);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    private void testBeginHandshakeCloseOutbound(SSLEngineTestParam param, SSLEngine engine) throws SSLException {
        SSLEngineResult result;
        ByteBuffer dst = this.allocateBuffer(param.type(), engine.getSession().getPacketBufferSize());
        ByteBuffer empty = this.allocateBuffer(param.type(), 0);
        engine.beginHandshake();
        engine.closeOutbound();
        while (true) {
            result = engine.wrap(empty, dst);
            dst.flip();
            Assertions.assertEquals((int)0, (int)result.bytesConsumed());
            Assertions.assertEquals((int)dst.remaining(), (int)result.bytesProduced());
            if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            dst.clear();
        }
        Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testCloseInboundAfterBeginHandshake(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLEngineTest.testCloseInboundAfterBeginHandshake(client);
            SSLEngineTest.testCloseInboundAfterBeginHandshake(server);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    private static void testCloseInboundAfterBeginHandshake(SSLEngine engine) throws SSLException {
        engine.beginHandshake();
        try {
            engine.closeInbound();
            if (!Conscrypt.isEngineSupported((SSLEngine)engine)) {
                Assertions.fail();
            }
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testCloseNotifySequence(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(new String[]{"TLSv1.2"}).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(new String[]{"TLSv1.2"}).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainClientOut = this.allocateBuffer(param.type(), client.getSession().getApplicationBufferSize());
            ByteBuffer plainServerOut = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize());
            ByteBuffer encryptedClientToServer = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            ByteBuffer encryptedServerToClient = this.allocateBuffer(param.type(), server.getSession().getPacketBufferSize());
            ByteBuffer empty = this.allocateBuffer(param.type(), 0);
            this.handshake(param.type(), param.delegate(), client, server);
            client.closeOutbound();
            Assertions.assertFalse((boolean)client.isOutboundDone());
            Assertions.assertFalse((boolean)client.isInboundDone());
            SSLEngineResult result = client.wrap(empty, encryptedClientToServer);
            encryptedClientToServer.flip();
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            SSLEngineResult.HandshakeStatus hs = result.getHandshakeStatus();
            if (this.sslClientProvider() == SslProvider.JDK || Conscrypt.isEngineSupported((SSLEngine)client)) {
                Assertions.assertTrue((hs == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING || hs == SSLEngineResult.HandshakeStatus.NEED_UNWRAP ? 1 : 0) != 0);
            } else {
                Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_UNWRAP), (Object)((Object)hs));
            }
            int produced = result.bytesProduced();
            int consumed = result.bytesConsumed();
            int closeNotifyLen = produced;
            Assertions.assertTrue((produced > 0 ? 1 : 0) != 0);
            Assertions.assertEquals((int)0, (int)consumed);
            Assertions.assertEquals((int)produced, (int)encryptedClientToServer.remaining());
            Assertions.assertTrue((boolean)client.isOutboundDone());
            Assertions.assertFalse((boolean)client.isInboundDone());
            Assertions.assertFalse((boolean)server.isOutboundDone());
            Assertions.assertFalse((boolean)server.isInboundDone());
            result = server.unwrap(encryptedClientToServer, plainServerOut);
            plainServerOut.flip();
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP), (Object)((Object)result.getHandshakeStatus()));
            produced = result.bytesProduced();
            consumed = result.bytesConsumed();
            Assertions.assertEquals((int)closeNotifyLen, (int)consumed);
            Assertions.assertEquals((int)0, (int)produced);
            Assertions.assertEquals((int)0, (int)encryptedClientToServer.remaining());
            Assertions.assertEquals((int)0, (int)plainServerOut.remaining());
            Assertions.assertFalse((boolean)server.isOutboundDone());
            Assertions.assertTrue((boolean)server.isInboundDone());
            result = server.wrap(empty, encryptedServerToClient);
            encryptedServerToClient.flip();
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)result.getHandshakeStatus()));
            produced = result.bytesProduced();
            consumed = result.bytesConsumed();
            Assertions.assertEquals((int)closeNotifyLen, (int)produced);
            Assertions.assertEquals((int)0, (int)consumed);
            Assertions.assertEquals((int)produced, (int)encryptedServerToClient.remaining());
            Assertions.assertTrue((boolean)server.isOutboundDone());
            Assertions.assertTrue((boolean)server.isInboundDone());
            result = client.unwrap(encryptedServerToClient, plainClientOut);
            plainClientOut.flip();
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)result.getHandshakeStatus()));
            produced = result.bytesProduced();
            consumed = result.bytesConsumed();
            Assertions.assertEquals((int)closeNotifyLen, (int)consumed);
            Assertions.assertEquals((int)0, (int)produced);
            Assertions.assertEquals((int)0, (int)encryptedServerToClient.remaining());
            Assertions.assertTrue((boolean)client.isOutboundDone());
            Assertions.assertTrue((boolean)client.isInboundDone());
            encryptedServerToClient.clear();
            plainServerOut.clear();
            result = server.wrap(plainServerOut, encryptedServerToClient);
            SSLEngineTest.assertEngineRemainsClosed(result);
            encryptedClientToServer.clear();
            plainServerOut.clear();
            result = server.unwrap(encryptedClientToServer, plainServerOut);
            SSLEngineTest.assertEngineRemainsClosed(result);
            encryptedClientToServer.clear();
            plainClientOut.clear();
            result = client.wrap(plainClientOut, encryptedClientToServer);
            SSLEngineTest.assertEngineRemainsClosed(result);
            encryptedServerToClient.clear();
            plainClientOut.clear();
            result = client.unwrap(encryptedServerToClient, plainClientOut);
            SSLEngineTest.assertEngineRemainsClosed(result);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    private static void assertEngineRemainsClosed(SSLEngineResult result) {
        Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
        Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)result.getHandshakeStatus()));
        Assertions.assertEquals((int)0, (int)result.bytesConsumed());
        Assertions.assertEquals((int)0, (int)result.bytesProduced());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testWrapAfterCloseOutbound(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer dst = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            ByteBuffer src = this.allocateBuffer(param.type(), 1024);
            this.handshake(param.type(), param.delegate(), client, server);
            client.closeOutbound();
            SSLEngineResult result = client.wrap(src, dst);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.CLOSED), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)0, (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)client.isOutboundDone());
            Assertions.assertFalse((boolean)client.isInboundDone());
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMultipleRecordsInOneBufferWithNonZeroPosition(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainClientOut = this.allocateBuffer(param.type(), 1024);
            ByteBuffer plainServerOut = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServer = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            int positionOffset = 1;
            ByteBuffer combinedEncClientToServer = this.allocateBuffer(param.type(), encClientToServer.capacity() * 2 + positionOffset);
            combinedEncClientToServer.position(positionOffset);
            this.handshake(param.type(), param.delegate(), client, server);
            plainClientOut.limit(plainClientOut.capacity());
            SSLEngineResult result = client.wrap(plainClientOut, encClientToServer);
            Assertions.assertEquals((int)plainClientOut.capacity(), (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            combinedEncClientToServer.put(encClientToServer);
            plainClientOut.clear();
            encClientToServer.clear();
            result = client.wrap(plainClientOut, encClientToServer);
            Assertions.assertEquals((int)plainClientOut.capacity(), (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            encClientToServer.flip();
            int encClientToServerLen = encClientToServer.remaining();
            combinedEncClientToServer.put(encClientToServer);
            encClientToServer.clear();
            combinedEncClientToServer.flip();
            combinedEncClientToServer.position(positionOffset);
            combinedEncClientToServer.limit(combinedEncClientToServer.limit() - (encClientToServerLen - positionOffset));
            result = server.unwrap(combinedEncClientToServer, plainServerOut);
            Assertions.assertEquals((int)encClientToServerLen, (int)result.bytesConsumed());
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMultipleRecordsInOneBufferBiggerThenPacketBufferSize(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            SSLEngineResult result;
            ByteBuffer plainClientOut = this.allocateBuffer(param.type(), 4096);
            ByteBuffer plainServerOut = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize());
            ByteBuffer encClientToServer = this.allocateBuffer(param.type(), server.getSession().getPacketBufferSize() * 2);
            this.handshake(param.type(), param.delegate(), client, server);
            int srcLen = plainClientOut.remaining();
            int count = 0;
            do {
                int plainClientOutPosition = plainClientOut.position();
                int encClientToServerPosition = encClientToServer.position();
                result = client.wrap(plainClientOut, encClientToServer);
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    Assertions.assertEquals((int)plainClientOutPosition, (int)plainClientOut.position());
                    Assertions.assertEquals((int)encClientToServerPosition, (int)encClientToServer.position());
                    break;
                }
                Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
                Assertions.assertEquals((int)srcLen, (int)result.bytesConsumed());
                Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
                plainClientOut.clear();
                ++count;
            } while (encClientToServer.position() < server.getSession().getPacketBufferSize());
            Assertions.assertTrue((count >= 2 ? 1 : 0) != 0);
            encClientToServer.flip();
            result = server.unwrap(encClientToServer, plainServerOut);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertTrue((result.bytesConsumed() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)encClientToServer.hasRemaining());
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testBufferUnderFlow(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainClient = this.allocateBuffer(param.type(), 1024);
            plainClient.limit(plainClient.capacity());
            ByteBuffer encClientToServer = this.allocateBuffer(param.type(), client.getSession().getPacketBufferSize());
            ByteBuffer plainServer = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize());
            this.handshake(param.type(), param.delegate(), client, server);
            SSLEngineResult result = client.wrap(plainClient, encClientToServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)plainClient.capacity());
            encClientToServer.flip();
            int remaining = encClientToServer.remaining();
            encClientToServer.limit(4);
            result = server.unwrap(encClientToServer, plainServer);
            SSLEngineTest.assertResultIsBufferUnderflow(result);
            encClientToServer.limit(5);
            result = server.unwrap(encClientToServer, plainServer);
            SSLEngineTest.assertResultIsBufferUnderflow(result);
            encClientToServer.limit(5 + remaining - 1 - 5);
            result = server.unwrap(encClientToServer, plainServer);
            SSLEngineTest.assertResultIsBufferUnderflow(result);
            encClientToServer.limit(remaining);
            result = server.unwrap(encClientToServer, plainServer);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertEquals((int)result.bytesConsumed(), (int)remaining);
            Assertions.assertTrue((result.bytesProduced() > 0 ? 1 : 0) != 0);
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    private static void assertResultIsBufferUnderflow(SSLEngineResult result) {
        Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW), (Object)((Object)result.getStatus()));
        Assertions.assertEquals((int)0, (int)result.bytesConsumed());
        Assertions.assertEquals((int)0, (int)result.bytesProduced());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testWrapDoesNotZeroOutSrc(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new X509Certificate[]{cert.cert()}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            ByteBuffer plainServerOut = this.allocateBuffer(param.type(), server.getSession().getApplicationBufferSize() / 2);
            this.handshake(param.type(), param.delegate(), client, server);
            for (int i = 0; i < plainServerOut.capacity(); ++i) {
                plainServerOut.put(i, (byte)i);
            }
            plainServerOut.position(plainServerOut.capacity());
            plainServerOut.flip();
            ByteBuffer encryptedServerToClient = this.allocateBuffer(param.type(), server.getSession().getPacketBufferSize());
            SSLEngineResult result = server.wrap(plainServerOut, encryptedServerToClient);
            Assertions.assertEquals((Object)((Object)SSLEngineResult.Status.OK), (Object)((Object)result.getStatus()));
            Assertions.assertTrue((result.bytesConsumed() > 0 ? 1 : 0) != 0);
            for (int i = 0; i < plainServerOut.capacity(); ++i) {
                Assertions.assertEquals((byte)((byte)i), (byte)plainServerOut.get(i));
            }
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testDisableProtocols(SSLEngineTestParam param) throws Exception {
        this.testDisableProtocols(param, "SSLv2", "SSLv2");
        this.testDisableProtocols(param, "SSLv3", "SSLv2", "SSLv3");
        this.testDisableProtocols(param, "TLSv1", "SSLv2", "SSLv3", "TLSv1");
        this.testDisableProtocols(param, "TLSv1.1", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1");
        this.testDisableProtocols(param, "TLSv1.2", "SSLv2", "SSLv3", "TLSv1", "TLSv1.1", "TLSv1.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDisableProtocols(SSLEngineTestParam param, String protocol, String ... disabledProtocols) throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        SslContext ctx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine server = this.wrapEngine(ctx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            HashSet<String> supported = new HashSet<String>(Arrays.asList(server.getSupportedProtocols()));
            if (supported.contains(protocol)) {
                server.setEnabledProtocols(server.getSupportedProtocols());
                Assertions.assertEquals(supported, new HashSet<String>(Arrays.asList(server.getSupportedProtocols())));
                for (String disabled : disabledProtocols) {
                    supported.remove(disabled);
                }
                if (supported.contains("SSLv2Hello") && supported.size() == 1) {
                    return;
                }
                server.setEnabledProtocols(supported.toArray(new String[0]));
                Assertions.assertEquals(supported, new HashSet<String>(Arrays.asList(server.getEnabledProtocols())));
                server.setEnabledProtocols(server.getSupportedProtocols());
            }
        }
        finally {
            this.cleanupServerSslEngine(server);
            this.cleanupClientSslContext(ctx);
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testUsingX509TrustManagerVerifiesHostname(SSLEngineTestParam param) throws Exception {
        this.testUsingX509TrustManagerVerifiesHostname(param, false);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testUsingX509TrustManagerVerifiesSNIHostname(SSLEngineTestParam param) throws Exception {
        this.testUsingX509TrustManagerVerifiesHostname(param, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testUsingX509TrustManagerVerifiesHostname(SSLEngineTestParam param, boolean useSNI) throws Exception {
        if (this.clientSslContextProvider() != null) {
            return;
        }
        String fqdn = "something.netty.io";
        SelfSignedCertificate cert = new SelfSignedCertificate(fqdn);
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(new TrustManagerFactory(new TrustManagerFactorySpi(){

            @Override
            protected void engineInit(KeyStore keyStore) {
            }

            @Override
            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return EmptyArrays.EMPTY_X509_CERTIFICATES;
                    }
                }};
            }

            @Override
            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }
        }, null, TrustManagerFactory.getDefaultAlgorithm()){}).sslContextProvider(this.clientSslContextProvider()).sslProvider(this.sslClientProvider()).build());
        SSLEngine client = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "127.0.0.1", 1234));
        SSLParameters sslParameters = client.getSSLParameters();
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
        if (useSNI) {
            sslParameters.setServerNames(Collections.singletonList(new SNIHostName(fqdn)));
        }
        client.setSSLParameters(sslParameters);
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).build());
        SSLEngine server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        try {
            this.handshake(param.type(), param.delegate(), client, server);
            if (!useSNI) {
                Assertions.fail();
            }
        }
        catch (SSLException exception) {
            if (useSNI) {
                throw exception;
            }
        }
        finally {
            this.cleanupClientSslEngine(client);
            this.cleanupServerSslEngine(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Test
    public void testInvalidCipher() throws Exception {
        SelfSignedCertificate cert = CachedSelfSignedCertificate.getCachedCertificate();
        ArrayList<String> cipherList = new ArrayList<String>();
        Collections.addAll(cipherList, ((SSLSocketFactory)SSLSocketFactory.getDefault()).getDefaultCipherSuites());
        cipherList.add("InvalidCipher");
        SSLEngine server = null;
        try {
            this.serverSslCtx = this.wrapContext(null, SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).ciphers(cipherList).build());
            server = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.cleanupServerSslEngine(server);
        }
        catch (SSLException sSLException) {
            this.cleanupServerSslEngine(server);
            {
                catch (Throwable throwable) {
                    this.cleanupServerSslEngine(server);
                    throw throwable;
                }
            }
        }
        this.cleanupServerSslEngine(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testGetCiphersuite(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            String clientCipher = clientEngine.getSession().getCipherSuite();
            String serverCipher = serverEngine.getSession().getCipherSuite();
            Assertions.assertEquals((Object)clientCipher, (Object)serverCipher);
            Assertions.assertEquals((Object)((SSLEngineTestParam)param).protocolCipherCombo.cipher, (Object)clientCipher);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCache(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.doHandshakeVerifyReusedAndClose(param, "a.netty.io", 9999, false);
        this.doHandshakeVerifyReusedAndClose(param, "a.netty.io", 9999, true);
        this.doHandshakeVerifyReusedAndClose(param, "b.netty.io", 9999, false);
        this.invalidateSessionsAndAssert(this.serverSslCtx.sessionContext());
        this.invalidateSessionsAndAssert(this.clientSslCtx.sessionContext());
    }

    protected void invalidateSessionsAndAssert(SSLSessionContext context) {
        Enumeration<byte[]> ids = context.getIds();
        while (ids.hasMoreElements()) {
            byte[] id = ids.nextElement();
            SSLSession session = context.getSession(id);
            if (session == null) continue;
            session.invalidate();
            Assertions.assertFalse((boolean)session.isValid());
            Assertions.assertNull((Object)context.getSession(id));
        }
    }

    private static void assertSessionCache(SSLSessionContext sessionContext, int numSessions) {
        Enumeration<byte[]> ids = sessionContext.getIds();
        int numIds = 0;
        while (ids.hasMoreElements()) {
            ++numIds;
            byte[] id = ids.nextElement();
            Assertions.assertNotEquals((int)0, (int)id.length);
            SSLSession session = sessionContext.getSession(id);
            Assertions.assertArrayEquals((byte[])id, (byte[])session.getId());
        }
        Assertions.assertEquals((int)numSessions, (int)numIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doHandshakeVerifyReusedAndClose(SSLEngineTestParam param, String host, int port, boolean reuse) throws Exception {
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, host, port));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            int clientSessions = SSLEngineTest.currentSessionCacheSize(this.clientSslCtx.sessionContext());
            int serverSessions = SSLEngineTest.currentSessionCacheSize(this.serverSslCtx.sessionContext());
            int nCSessions = clientSessions;
            int nSSessions = serverSessions;
            SessionReusedState clientSessionReused = SessionReusedState.NOT_REUSED;
            SessionReusedState serverSessionReused = SessionReusedState.NOT_REUSED;
            if (param.protocolCipherCombo == ProtocolCipherCombo.TLSV13) {
                ByteBuffer packetBuffer = this.allocateBuffer(param.type(), 32768);
                ByteBuffer appBuffer = this.allocateBuffer(param.type(), 32768);
                appBuffer.clear().position(4).flip();
                packetBuffer.clear();
                while (true) {
                    SSLEngineResult result = serverEngine.wrap(appBuffer, packetBuffer);
                    if (appBuffer.hasRemaining() || result.bytesProduced() > 0) continue;
                    appBuffer.clear();
                    packetBuffer.flip();
                    do {
                        result = clientEngine.unwrap(packetBuffer, appBuffer);
                    } while (packetBuffer.hasRemaining() || result.bytesProduced() > 0);
                    packetBuffer.clear();
                    appBuffer.clear().position(4).flip();
                    do {
                        result = clientEngine.wrap(appBuffer, packetBuffer);
                    } while (appBuffer.hasRemaining() || result.bytesProduced() > 0);
                    appBuffer.clear();
                    packetBuffer.flip();
                    do {
                        result = serverEngine.unwrap(packetBuffer, appBuffer);
                    } while (packetBuffer.hasRemaining() || result.bytesProduced() > 0);
                    packetBuffer.clear();
                    appBuffer.clear().position(4).flip();
                    nCSessions = SSLEngineTest.currentSessionCacheSize(this.clientSslCtx.sessionContext());
                    nSSessions = SSLEngineTest.currentSessionCacheSize(this.serverSslCtx.sessionContext());
                    clientSessionReused = this.isSessionReused(clientEngine);
                    serverSessionReused = this.isSessionReused(serverEngine);
                    if ((!reuse || clientSessionReused != SessionReusedState.NOT_REUSED && serverSessionReused != SessionReusedState.NOT_REUSED) && (reuse || nCSessions >= clientSessions && nSSessions >= serverSessions)) break;
                }
            }
            this.assertSessionReusedForEngine(clientEngine, serverEngine, reuse);
            String key = "key";
            if (reuse) {
                if (clientSessionReused != SessionReusedState.NOT_REUSED) {
                    if (!Conscrypt.isEngineSupported((SSLEngine)clientEngine)) {
                        Assertions.assertEquals((Object)Boolean.TRUE, (Object)clientEngine.getSession().getValue(key));
                    }
                    Matcher creationTimeMatcher = clientSessionReused == SessionReusedState.REUSED ? Matchers.greaterThan((Comparable)Long.valueOf(clientEngine.getSession().getCreationTime())) : Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(clientEngine.getSession().getCreationTime()));
                    MatcherAssert.assertThat((Object)clientEngine.getSession().getLastAccessedTime(), (Matcher)CoreMatchers.is((Matcher)creationTimeMatcher));
                }
            } else {
                Thread.sleep(1L);
                clientEngine.getSession().putValue(key, Boolean.TRUE);
            }
            this.closeOutboundAndInbound(param.type(), clientEngine, serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    protected SessionReusedState isSessionReused(SSLEngine engine) {
        return SessionReusedState.MAYBE_REUSED;
    }

    private static int currentSessionCacheSize(SSLSessionContext ctx) {
        Enumeration<byte[]> ids = ctx.getIds();
        int i = 0;
        while (ids.hasMoreElements()) {
            ++i;
            ids.nextElement();
        }
        return i;
    }

    private void closeOutboundAndInbound(BufferType type, SSLEngine clientEngine, SSLEngine serverEngine) throws SSLException {
        SSLEngineResult result;
        Assertions.assertFalse((boolean)clientEngine.isInboundDone());
        Assertions.assertFalse((boolean)clientEngine.isOutboundDone());
        Assertions.assertFalse((boolean)serverEngine.isInboundDone());
        Assertions.assertFalse((boolean)serverEngine.isOutboundDone());
        ByteBuffer empty = this.allocateBuffer(type, 0);
        ByteBuffer cTOs = this.allocateBuffer(type, clientEngine.getSession().getPacketBufferSize() * 4);
        ByteBuffer sTOs = this.allocateBuffer(type, serverEngine.getSession().getPacketBufferSize() * 4);
        ByteBuffer cApps = this.allocateBuffer(type, clientEngine.getSession().getApplicationBufferSize() * 4);
        ByteBuffer sApps = this.allocateBuffer(type, serverEngine.getSession().getApplicationBufferSize() * 4);
        clientEngine.closeOutbound();
        while ((result = clientEngine.wrap(empty, cTOs)).getStatus() != SSLEngineResult.Status.CLOSED || result.bytesProduced() != 0) {
            Assertions.assertTrue((boolean)cTOs.hasRemaining());
        }
        cTOs.flip();
        while ((result = serverEngine.unwrap(cTOs, sApps)).getStatus() != SSLEngineResult.Status.CLOSED || result.bytesProduced() != 0) {
            Assertions.assertTrue((boolean)sApps.hasRemaining());
        }
        serverEngine.closeOutbound();
        while ((result = serverEngine.wrap(empty, sTOs)).getStatus() != SSLEngineResult.Status.CLOSED || result.bytesProduced() != 0) {
            Assertions.assertTrue((boolean)sTOs.hasRemaining());
        }
        sTOs.flip();
        while ((result = clientEngine.unwrap(sTOs, cApps)).getStatus() != SSLEngineResult.Status.CLOSED || result.bytesProduced() != 0) {
            Assertions.assertTrue((boolean)cApps.hasRemaining());
        }
        clientEngine.closeInbound();
        serverEngine.closeInbound();
    }

    protected void assertSessionReusedForEngine(SSLEngine clientEngine, SSLEngine serverEngine, boolean reuse) {
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheTimeout(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).sessionTimeout(1L).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).sessionTimeout(1L).build());
        this.doHandshakeVerifyReusedAndClose(param, "a.netty.io", 9999, false);
        Thread.sleep(1500L);
        SSLEngineTest.assertSessionCache(this.serverSslCtx.sessionContext(), 0);
        SSLEngineTest.assertSessionCache(this.clientSslCtx.sessionContext(), 0);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionCacheSize(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).sessionCacheSize(1L).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.doHandshakeVerifyReusedAndClose(param, "a.netty.io", 9999, false);
        this.doHandshakeVerifyReusedAndClose(param, "b.netty.io", 9999, false);
        this.doHandshakeVerifyReusedAndClose(param, "b.netty.io", 9999, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionBindingEvent(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            SSLSession session = clientEngine.getSession();
            Assertions.assertEquals((int)0, (int)session.getValueNames().length);
            String name = "name";
            String name2 = "name2";
            class SSLSessionBindingEventValue
            implements SSLSessionBindingListener {
                SSLSessionBindingEvent boundEvent;
                SSLSessionBindingEvent unboundEvent;

                SSLSessionBindingEventValue() {
                }

                @Override
                public void valueBound(SSLSessionBindingEvent sslSessionBindingEvent) {
                    Assertions.assertNull((Object)this.boundEvent);
                    this.boundEvent = sslSessionBindingEvent;
                }

                @Override
                public void valueUnbound(SSLSessionBindingEvent sslSessionBindingEvent) {
                    Assertions.assertNull((Object)this.unboundEvent);
                    this.unboundEvent = sslSessionBindingEvent;
                }
            }
            SSLSessionBindingEventValue value1 = new SSLSessionBindingEventValue();
            session.putValue(name, value1);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value1.boundEvent);
            Assertions.assertNull((Object)value1.unboundEvent);
            Assertions.assertEquals((int)1, (int)session.getValueNames().length);
            session.putValue(name2, "value");
            SSLSessionBindingEventValue value2 = new SSLSessionBindingEventValue();
            session.putValue(name, value2);
            Assertions.assertEquals((int)2, (int)session.getValueNames().length);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value1.unboundEvent);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value2.boundEvent);
            Assertions.assertNull((Object)value2.unboundEvent);
            Assertions.assertEquals((int)2, (int)session.getValueNames().length);
            session.removeValue(name);
            SSLEngineTest.assertSSLSessionBindingEventValue(name, session, value2.unboundEvent);
            Assertions.assertEquals((int)1, (int)session.getValueNames().length);
            session.removeValue(name2);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    private static void assertSSLSessionBindingEventValue(String name, SSLSession session, SSLSessionBindingEvent event) {
        Assertions.assertEquals((Object)name, (Object)event.getName());
        Assertions.assertEquals((Object)session, (Object)event.getSession());
        Assertions.assertEquals((Object)session, (Object)event.getSource());
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshake(SSLEngineTestParam param) throws Exception {
        this.testSessionAfterHandshake0(param, false, false);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshakeMutualAuth(SSLEngineTestParam param) throws Exception {
        this.testSessionAfterHandshake0(param, false, true);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshakeKeyManagerFactory(SSLEngineTestParam param) throws Exception {
        this.testSessionAfterHandshake0(param, true, false);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth(SSLEngineTestParam param) throws Exception {
        this.testSessionAfterHandshake0(param, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSessionAfterHandshake0(SSLEngineTestParam param, boolean useKeyManagerFactory, boolean mutualAuth) throws Exception {
        SslContextBuilder serverContextBuilder;
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        KeyManagerFactory kmf = useKeyManagerFactory ? SslContext.buildKeyManagerFactory((X509Certificate[])new X509Certificate[]{ssc.cert()}, null, (PrivateKey)ssc.key(), null, null, null) : null;
        SslContextBuilder clientContextBuilder = SslContextBuilder.forClient();
        if (mutualAuth) {
            if (kmf != null) {
                clientContextBuilder.keyManager(kmf);
            } else {
                clientContextBuilder.keyManager(ssc.key(), new X509Certificate[]{ssc.cert()});
            }
        }
        String handshakeKey = "handshake";
        ConstantTrustManagerFactory tmf = new ConstantTrustManagerFactory(new EmptyExtendedX509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                if (!Conscrypt.isEngineSupported((SSLEngine)engine)) {
                    Assertions.assertEquals((int)0, (int)engine.getHandshakeSession().getValueNames().length);
                }
                engine.getHandshakeSession().putValue("handshake", Boolean.TRUE);
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) {
                if (!Conscrypt.isEngineSupported((SSLEngine)engine)) {
                    Assertions.assertEquals((int)0, (int)engine.getHandshakeSession().getValueNames().length);
                }
                engine.getHandshakeSession().putValue("handshake", Boolean.TRUE);
            }
        });
        this.clientSslCtx = this.wrapContext(param, clientContextBuilder.trustManager((TrustManagerFactory)((Object)tmf)).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SslContextBuilder sslContextBuilder = serverContextBuilder = kmf != null ? SslContextBuilder.forServer((KeyManagerFactory)kmf) : SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey());
        if (mutualAuth) {
            serverContextBuilder.clientAuth(ClientAuth.REQUIRE);
        }
        this.serverSslCtx = this.wrapContext(param, serverContextBuilder.trustManager((TrustManagerFactory)((Object)tmf)).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        String key = "key";
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            clientEngine.getSession().putValue(key, Boolean.TRUE);
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)clientEngine.getSession().getValue(key));
            serverEngine.getSession().putValue(key, Boolean.TRUE);
            Assertions.assertEquals((Object)Boolean.TRUE, (Object)serverEngine.getSession().getValue(key));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            SSLSession clientSession = clientEngine.getSession();
            SSLSession serverSession = serverEngine.getSession();
            if (!Conscrypt.isEngineSupported((SSLEngine)clientEngine)) {
                Assertions.assertNull((Object)clientSession.getValue(key));
            }
            if (!Conscrypt.isEngineSupported((SSLEngine)serverEngine)) {
                Assertions.assertNull((Object)serverSession.getValue(key));
            }
            clientSession.removeValue(key);
            serverSession.removeValue(key);
            Assertions.assertNull((Object)clientSession.getPeerHost());
            Assertions.assertNull((Object)serverSession.getPeerHost());
            Assertions.assertEquals((int)-1, (int)clientSession.getPeerPort());
            Assertions.assertEquals((int)-1, (int)serverSession.getPeerPort());
            Assertions.assertTrue((clientSession.getCreationTime() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((serverSession.getCreationTime() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((clientSession.getLastAccessedTime() > 0L ? 1 : 0) != 0);
            Assertions.assertTrue((serverSession.getLastAccessedTime() > 0L ? 1 : 0) != 0);
            Assertions.assertEquals((long)clientSession.getCreationTime(), (long)clientSession.getLastAccessedTime());
            Assertions.assertEquals((long)serverSession.getCreationTime(), (long)serverSession.getLastAccessedTime());
            Assertions.assertEquals((Object)param.combo().protocol, (Object)clientSession.getProtocol());
            Assertions.assertEquals((Object)param.combo().protocol, (Object)serverSession.getProtocol());
            Assertions.assertEquals((Object)param.combo().cipher, (Object)clientSession.getCipherSuite());
            Assertions.assertEquals((Object)param.combo().cipher, (Object)serverSession.getCipherSuite());
            Assertions.assertNotNull((Object)clientSession.getId());
            Assertions.assertNotNull((Object)serverSession.getId());
            Assertions.assertTrue((clientSession.getApplicationBufferSize() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((serverSession.getApplicationBufferSize() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((clientSession.getPacketBufferSize() > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((serverSession.getPacketBufferSize() > 0 ? 1 : 0) != 0);
            Assertions.assertNotNull((Object)clientSession.getSessionContext());
            if (PlatformDependent.javaVersion() != 14) {
                Assertions.assertNotNull((Object)serverSession.getSessionContext());
            }
            Object value = new Object();
            if (!Conscrypt.isEngineSupported((SSLEngine)clientEngine)) {
                Assertions.assertEquals((int)1, (int)clientSession.getValueNames().length);
                Assertions.assertEquals((Object)clientSession.getValue("handshake"), (Object)Boolean.TRUE);
                clientSession.removeValue("handshake");
            }
            if (mutualAuth && !Conscrypt.isEngineSupported((SSLEngine)serverEngine)) {
                Assertions.assertEquals((int)1, (int)serverSession.getValueNames().length);
                Assertions.assertEquals((Object)serverSession.getValue("handshake"), (Object)Boolean.TRUE);
                serverSession.removeValue("handshake");
            }
            Assertions.assertEquals((int)0, (int)clientSession.getValueNames().length);
            clientSession.putValue("test", value);
            Assertions.assertEquals((Object)"test", (Object)clientSession.getValueNames()[0]);
            Assertions.assertSame((Object)value, (Object)clientSession.getValue("test"));
            clientSession.removeValue("test");
            Assertions.assertEquals((int)0, (int)clientSession.getValueNames().length);
            Assertions.assertEquals((int)0, (int)serverSession.getValueNames().length);
            serverSession.putValue("test", value);
            Assertions.assertEquals((Object)"test", (Object)serverSession.getValueNames()[0]);
            Assertions.assertSame((Object)value, (Object)serverSession.getValue("test"));
            serverSession.removeValue("test");
            Assertions.assertEquals((int)0, (int)serverSession.getValueNames().length);
            Certificate[] serverLocalCertificates = serverSession.getLocalCertificates();
            Assertions.assertEquals((int)1, (int)serverLocalCertificates.length);
            Assertions.assertArrayEquals((byte[])ssc.cert().getEncoded(), (byte[])serverLocalCertificates[0].getEncoded());
            Principal serverLocalPrincipal = serverSession.getLocalPrincipal();
            Assertions.assertNotNull((Object)serverLocalPrincipal);
            if (mutualAuth) {
                Certificate[] clientLocalCertificates = clientSession.getLocalCertificates();
                Assertions.assertEquals((int)1, (int)clientLocalCertificates.length);
                Certificate[] serverPeerCertificates = serverSession.getPeerCertificates();
                Assertions.assertEquals((int)1, (int)serverPeerCertificates.length);
                Assertions.assertArrayEquals((byte[])clientLocalCertificates[0].getEncoded(), (byte[])serverPeerCertificates[0].getEncoded());
                try {
                    javax.security.cert.X509Certificate[] serverPeerX509Certificates = serverSession.getPeerCertificateChain();
                    Assertions.assertEquals((int)1, (int)serverPeerX509Certificates.length);
                    Assertions.assertArrayEquals((byte[])clientLocalCertificates[0].getEncoded(), (byte[])serverPeerX509Certificates[0].getEncoded());
                }
                catch (UnsupportedOperationException e) {
                    Assertions.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
                }
                Principal clientLocalPrincipial = clientSession.getLocalPrincipal();
                Assertions.assertNotNull((Object)clientLocalPrincipial);
                Principal serverPeerPrincipal = serverSession.getPeerPrincipal();
                Assertions.assertEquals((Object)clientLocalPrincipial, (Object)serverPeerPrincipal);
            } else {
                Assertions.assertNull((Object)clientSession.getLocalCertificates());
                Assertions.assertNull((Object)clientSession.getLocalPrincipal());
                try {
                    serverSession.getPeerCertificates();
                    Assertions.fail();
                }
                catch (SSLPeerUnverifiedException clientLocalCertificates) {
                    // empty catch block
                }
                try {
                    serverSession.getPeerCertificateChain();
                    Assertions.fail();
                }
                catch (SSLPeerUnverifiedException clientLocalCertificates) {
                }
                catch (UnsupportedOperationException e) {
                    Assertions.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
                }
                try {
                    serverSession.getPeerPrincipal();
                    Assertions.fail();
                }
                catch (SSLPeerUnverifiedException e) {
                    // empty catch block
                }
            }
            Certificate[] clientPeerCertificates = clientSession.getPeerCertificates();
            Assertions.assertEquals((int)1, (int)clientPeerCertificates.length);
            Assertions.assertArrayEquals((byte[])serverLocalCertificates[0].getEncoded(), (byte[])clientPeerCertificates[0].getEncoded());
            try {
                javax.security.cert.X509Certificate[] clientPeerX509Certificates = clientSession.getPeerCertificateChain();
                Assertions.assertEquals((int)1, (int)clientPeerX509Certificates.length);
                Assertions.assertArrayEquals((byte[])serverLocalCertificates[0].getEncoded(), (byte[])clientPeerX509Certificates[0].getEncoded());
            }
            catch (UnsupportedOperationException e) {
                Assertions.assertTrue((PlatformDependent.javaVersion() >= 15 ? 1 : 0) != 0);
            }
            Principal clientPeerPrincipal = clientSession.getPeerPrincipal();
            Assertions.assertEquals((Object)serverLocalPrincipal, (Object)clientPeerPrincipal);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    @Timeout(value=60L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void mustCallResumeTrustedOnSessionResumption(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        SessionValueSettingTrustManager clientTm = new SessionValueSettingTrustManager("key", "client");
        SessionValueSettingTrustManager serverTm = new SessionValueSettingTrustManager("key", "server");
        this.buildClientSslContextForMTLS(param, ssc, clientTm);
        this.buildServerSslContextForMTLS(param, ssc, serverTm);
        final LinkedBlockingQueue clientSessionValues = new LinkedBlockingQueue();
        final LinkedBlockingQueue serverSessionValues = new LinkedBlockingQueue();
        OnNextMessage checkClient = new OnNextMessage(){

            @Override
            public void messageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                msg.release();
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                SSLEngine engine = sslHandler.engine();
                logger.debug("Client message received: {} ({}) {} {}", new Object[]{engine.getSession(), engine.getHandshakeStatus(), SSLEngineTest.this.isSessionReused(engine), Arrays.toString(engine.getSession().getValueNames())});
                Object value = engine.getSession().getValue("key");
                clientSessionValues.put((String)value);
            }
        };
        OnNextMessage checkServer = new OnNextMessage(){

            @Override
            public void messageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                SSLEngine engine = sslHandler.engine();
                logger.debug("Server message received: {} ({}) {} {}", new Object[]{engine.getSession(), engine.getHandshakeStatus(), SSLEngineTest.this.isSessionReused(engine), Arrays.toString(engine.getSession().getValueNames())});
                Object value = engine.getSession().getValue("key");
                serverSessionValues.put((String)value);
                ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        };
        this.setupServer(param.type(), param.delegate());
        InetSocketAddress addr = (InetSocketAddress)this.serverChannel.localAddress();
        this.setupClient(param.type(), param.delegate(), "a.netty.io", addr.getPort());
        for (int i = 0; i < 10; ++i) {
            this.clientReceiver.onNextMessages.offer(checkClient);
            this.serverReceiver.onNextMessages.offer(checkServer);
            ChannelFuture ccf = this.cb.connect((SocketAddress)addr);
            Assertions.assertTrue((boolean)ccf.syncUninterruptibly().isSuccess());
            this.clientChannel = ccf.channel();
            this.clientChannel.writeAndFlush((Object)this.clientChannel.alloc().buffer().writeInt(42)).sync();
            Assertions.assertEquals((Object)"client", clientSessionValues.take());
            Assertions.assertEquals((Object)"server", serverSessionValues.take());
            this.clientChannel.closeFuture().sync();
        }
        Assertions.assertTrue((boolean)this.clientReceiver.onNextMessages.isEmpty());
        Assertions.assertTrue((boolean)this.serverReceiver.onNextMessages.isEmpty());
        Assertions.assertTrue((boolean)clientSessionValues.isEmpty());
        Assertions.assertTrue((boolean)serverSessionValues.isEmpty());
    }

    @Timeout(value=60L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    void mustFailHandshakePromiseIfResumeServerTrustedThrows(SSLEngineTestParam param) throws Exception {
        ByteBuf byteBuf;
        final AtomicInteger checkServerTrustedCount = new AtomicInteger();
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        SessionValueSettingTrustManager clientTm = new SessionValueSettingTrustManager("key", "client"){

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                checkServerTrustedCount.incrementAndGet();
                super.checkServerTrusted(chain, authType, engine);
            }

            @Override
            public void resumeServerTrusted(X509Certificate[] chain, SSLEngine engine) throws CertificateException {
                throw new CertificateException("Test exception");
            }
        };
        SessionValueSettingTrustManager serverTm = new SessionValueSettingTrustManager("key", "server");
        this.buildClientSslContextForMTLS(param, ssc, clientTm);
        this.buildServerSslContextForMTLS(param, ssc, serverTm);
        OnNextMessage checkServer = new OnNextMessage(){

            @Override
            public void messageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        };
        this.setupServer(param.type(), param.delegate());
        InetSocketAddress addr = (InetSocketAddress)this.serverChannel.localAddress();
        this.setupClient(param.type(), param.delegate(), "a.netty.io", addr.getPort());
        Future<Channel> handshakeFuture = null;
        for (int i = 0; i < 2; ++i) {
            this.serverReceiver.onNextMessages.offer(checkServer);
            ChannelFuture ccf = this.cb.connect((SocketAddress)addr);
            Assertions.assertTrue((boolean)ccf.sync().isSuccess());
            this.clientChannel = ccf.channel();
            this.clientChannel.writeAndFlush((Object)this.clientChannel.alloc().buffer().writeInt(42)).await();
            this.clientChannel.closeFuture().sync();
            handshakeFuture = this.clientSslHandshakeFuture;
        }
        int checkServerTrustedCalls = checkServerTrustedCount.get();
        if (checkServerTrustedCalls == 1) {
            do {
                this.clientChannel.eventLoop().submit(NOOP).await();
            } while (this.clientException == null);
            Assertions.assertEquals((Object)"Test exception", (Object)this.clientException.getMessage());
            Assertions.assertNotNull(handshakeFuture);
            Assertions.assertTrue((boolean)handshakeFuture.isDone());
            Assertions.assertFalse((boolean)handshakeFuture.isSuccess());
            Assertions.assertEquals((Object)"Test exception", (Object)handshakeFuture.cause().getMessage());
        } else {
            Assertions.assertEquals((int)2, (int)checkServerTrustedCalls);
        }
        while ((byteBuf = (ByteBuf)this.clientReceiver.messages.poll()) != null) {
            byteBuf.release();
        }
    }

    @Timeout(value=60L, threadMode=Timeout.ThreadMode.SEPARATE_THREAD)
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    void mustFailHandshakePromiseIfResumeClientTrustedThrows(SSLEngineTestParam param) throws Exception {
        ByteBuf byteBuf;
        final AtomicInteger checkClientTrustedCount = new AtomicInteger();
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        SessionValueSettingTrustManager clientTm = new SessionValueSettingTrustManager("key", "client");
        SessionValueSettingTrustManager serverTm = new SessionValueSettingTrustManager("key", "server"){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                checkClientTrustedCount.incrementAndGet();
                super.checkClientTrusted(chain, authType, engine);
            }

            @Override
            public void resumeClientTrusted(X509Certificate[] chain, SSLEngine engine) throws CertificateException {
                throw new CertificateException("Test exception");
            }
        };
        this.buildClientSslContextForMTLS(param, ssc, clientTm);
        this.buildServerSslContextForMTLS(param, ssc, serverTm);
        OnNextMessage checkServer = new OnNextMessage(){

            @Override
            public void messageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                ctx.writeAndFlush((Object)msg).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        };
        this.setupServer(param.type(), param.delegate());
        InetSocketAddress addr = (InetSocketAddress)this.serverChannel.localAddress();
        this.setupClient(param.type(), param.delegate(), "a.netty.io", addr.getPort());
        Future<Channel> handshakeFuture = null;
        for (int i = 0; i < 2; ++i) {
            this.serverReceiver.onNextMessages.offer(checkServer);
            ChannelFuture ccf = this.cb.connect((SocketAddress)addr);
            Assertions.assertTrue((boolean)ccf.syncUninterruptibly().isSuccess());
            this.clientChannel = ccf.channel();
            this.clientChannel.writeAndFlush((Object)this.clientChannel.alloc().buffer().writeInt(42)).await();
            this.clientChannel.closeFuture().sync();
            handshakeFuture = this.serverSslHandshakeFuture;
        }
        int checkClientTrustedCalls = checkClientTrustedCount.get();
        if (checkClientTrustedCalls == 1) {
            do {
                this.serverChannel.eventLoop().submit(NOOP).await();
            } while (this.serverException == null);
            Assertions.assertEquals((Object)"Test exception", (Object)this.serverException.getMessage());
            Assertions.assertNotNull(handshakeFuture);
            Assertions.assertTrue((boolean)handshakeFuture.isDone());
            Assertions.assertFalse((boolean)handshakeFuture.isSuccess());
            Assertions.assertEquals((Object)"Test exception", (Object)handshakeFuture.cause().getMessage());
        } else {
            Assertions.assertEquals((int)2, (int)checkClientTrustedCalls);
        }
        while ((byteBuf = (ByteBuf)this.clientReceiver.messages.poll()) != null) {
            byteBuf.release();
        }
    }

    private void buildClientSslContextForMTLS(SSLEngineTestParam param, SelfSignedCertificate ssc, TrustManager clientTm) throws SSLException {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().keyManager(ssc.key(), new X509Certificate[]{ssc.cert()}).trustManager(clientTm).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
    }

    private void buildServerSslContextForMTLS(SSLEngineTestParam param, SelfSignedCertificate ssc, TrustManager serverTm) throws SSLException {
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).trustManager(serverTm).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).clientAuth(ClientAuth.REQUIRE).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSupportedSignatureAlgorithms(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        final class TestKeyManagerFactory
        extends KeyManagerFactory {
            TestKeyManagerFactory(final KeyManagerFactory factory) {
                super(new KeyManagerFactorySpi(){
                    private final KeyManager[] managers;
                    {
                        this.managers = factory.getKeyManagers();
                    }

                    @Override
                    protected void engineInit(KeyStore keyStore, char[] chars) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    protected KeyManager[] engineGetKeyManagers() {
                        KeyManager[] array = new KeyManager[this.managers.length];
                        for (int i = 0; i < array.length; ++i) {
                            final X509ExtendedKeyManager x509ExtendedKeyManager = (X509ExtendedKeyManager)this.managers[i];
                            array[i] = new X509ExtendedKeyManager(){

                                @Override
                                public String[] getClientAliases(String s, Principal[] principals) {
                                    Assertions.fail();
                                    return null;
                                }

                                @Override
                                public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
                                    Assertions.fail();
                                    return null;
                                }

                                @Override
                                public String[] getServerAliases(String s, Principal[] principals) {
                                    Assertions.fail();
                                    return null;
                                }

                                @Override
                                public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
                                    Assertions.fail();
                                    return null;
                                }

                                @Override
                                public String chooseEngineClientAlias(String[] strings, Principal[] principals, SSLEngine sslEngine) {
                                    Assertions.assertNotEquals((int)0, (int)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getPeerSupportedSignatureAlgorithms().length);
                                    Assertions.assertNotEquals((int)0, (int)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getLocalSupportedSignatureAlgorithms().length);
                                    return x509ExtendedKeyManager.chooseEngineClientAlias(strings, principals, sslEngine);
                                }

                                @Override
                                public String chooseEngineServerAlias(String s, Principal[] principals, SSLEngine sslEngine) {
                                    Assertions.assertNotEquals((int)0, (int)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getPeerSupportedSignatureAlgorithms().length);
                                    Assertions.assertNotEquals((int)0, (int)((ExtendedSSLSession)sslEngine.getHandshakeSession()).getLocalSupportedSignatureAlgorithms().length);
                                    return x509ExtendedKeyManager.chooseEngineServerAlias(s, principals, sslEngine);
                                }

                                @Override
                                public X509Certificate[] getCertificateChain(String s) {
                                    return x509ExtendedKeyManager.getCertificateChain(s);
                                }

                                @Override
                                public PrivateKey getPrivateKey(String s) {
                                    return x509ExtendedKeyManager.getPrivateKey(s);
                                }
                            };
                        }
                        return array;
                    }
                }, factory.getProvider(), factory.getAlgorithm());
            }
        }
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().keyManager((KeyManagerFactory)new TestKeyManagerFactory(SSLEngineTest.newKeyManagerFactory(ssc))).trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((KeyManagerFactory)new TestKeyManagerFactory(SSLEngineTest.newKeyManagerFactory(ssc))).trustManager(InsecureTrustManagerFactory.INSTANCE).sslContextProvider(this.serverSslContextProvider()).sslProvider(this.sslServerProvider()).protocols(param.protocols()).ciphers(param.ciphers()).clientAuth(ClientAuth.REQUIRE).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testHandshakeSession(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        final TestTrustManagerFactory clientTmf = new TestTrustManagerFactory(ssc.cert());
        final TestTrustManagerFactory serverTmf = new TestTrustManagerFactory(ssc.cert());
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager((TrustManagerFactory)new SimpleTrustManagerFactory(){

            protected void engineInit(KeyStore keyStore) {
            }

            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }

            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{clientTmf};
            }
        }).keyManager(SSLEngineTest.newKeyManagerFactory(ssc)).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((KeyManagerFactory)SSLEngineTest.newKeyManagerFactory(ssc)).trustManager((TrustManagerFactory)new SimpleTrustManagerFactory(){

            protected void engineInit(KeyStore keyStore) {
            }

            protected void engineInit(ManagerFactoryParameters managerFactoryParameters) {
            }

            protected TrustManager[] engineGetTrustManagers() {
                return new TrustManager[]{serverTmf};
            }
        }).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).clientAuth(ClientAuth.REQUIRE).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            Assertions.assertTrue((boolean)clientTmf.isVerified());
            Assertions.assertTrue((boolean)serverTmf.isVerified());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithKeyManager(SSLEngineTestParam param) throws Exception {
        this.testSessionLocalWhenNonMutual(param, true);
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testSessionLocalWhenNonMutualWithoutKeyManager(SSLEngineTestParam param) throws Exception {
        this.testSessionLocalWhenNonMutual(param, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSessionLocalWhenNonMutual(SSLEngineTestParam param, boolean useKeyManager) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        SslContextBuilder clientSslCtxBuilder = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers());
        if (useKeyManager) {
            clientSslCtxBuilder.keyManager(SSLEngineTest.newKeyManagerFactory(ssc));
        } else {
            clientSslCtxBuilder.keyManager(ssc.certificate(), ssc.privateKey());
        }
        this.clientSslCtx = this.wrapContext(param, clientSslCtxBuilder.build());
        SslContextBuilder serverSslCtxBuilder = useKeyManager ? SslContextBuilder.forServer((KeyManagerFactory)SSLEngineTest.newKeyManagerFactory(ssc)) : SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey());
        serverSslCtxBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).clientAuth(ClientAuth.NONE);
        this.serverSslCtx = this.wrapContext(param, serverSslCtxBuilder.build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            SSLSession clientSession = clientEngine.getSession();
            Assertions.assertNull((Object)clientSession.getLocalCertificates());
            Assertions.assertNull((Object)clientSession.getLocalPrincipal());
            SSLSession serverSession = serverEngine.getSession();
            Assertions.assertNotNull((Object)serverSession.getLocalCertificates());
            Assertions.assertNotNull((Object)serverSession.getLocalPrincipal());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testEnabledProtocolsAndCiphers(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            SSLEngineTest.assertEnabledProtocolsAndCipherSuites(clientEngine);
            SSLEngineTest.assertEnabledProtocolsAndCipherSuites(serverEngine);
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    private static void assertEnabledProtocolsAndCipherSuites(SSLEngine engine) {
        String protocol = engine.getSession().getProtocol();
        String cipherSuite = engine.getSession().getCipherSuite();
        SSLEngineTest.assertArrayContains(protocol, engine.getEnabledProtocols());
        SSLEngineTest.assertArrayContains(cipherSuite, engine.getEnabledCipherSuites());
    }

    private static void assertArrayContains(String expected, String[] array) {
        for (String value : array) {
            if (!expected.equals(value)) continue;
            return;
        }
        Assertions.fail((String)("Array did not contain '" + expected + "':" + Arrays.toString(array)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testMasterKeyLogging(final SSLEngineTestParam param) throws Exception {
        if (param.combo() != ProtocolCipherCombo.tlsv12()) {
            return;
        }
        Assumptions.assumeFalse((boolean)(this.serverSslContextProvider() instanceof OpenSSLProvider));
        Assumptions.assumeFalse((this.sslServerProvider() == SslProvider.JDK && PlatformDependent.javaVersion() > 8 ? 1 : 0) != 0);
        String originalSystemPropertyValue = SystemPropertyUtil.get((String)"org.neo4j.driver.internal.shaded.io.netty.ssl.masterKeyHandler");
        System.setProperty("org.neo4j.driver.internal.shaded.io.netty.ssl.masterKeyHandler", Boolean.TRUE.toString());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        Socket socket = null;
        try {
            this.sb = new ServerBootstrap();
            this.sb.group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup());
            this.sb.channel(NioServerSocketChannel.class);
            final Promise promise = this.sb.config().group().next().newPromise();
            this.serverChannel = this.sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.config().setAllocator((ByteBufAllocator)new TestByteBufAllocator(ch.config().getAllocator(), param.type()));
                    SslHandler sslHandler = !param.delegate() ? SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc()) : SSLEngineTest.this.serverSslCtx.newHandler(ch.alloc(), (Executor)SSLEngineTest.this.delegatingExecutor);
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new SslMasterKeyHandler(){

                        protected void accept(SecretKey masterKey, SSLSession session) {
                            promise.setSuccess((Object)masterKey);
                        }
                    }});
                    SSLEngineTest.this.serverConnectedChannel = ch;
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).sync().channel();
            int port = ((InetSocketAddress)this.serverChannel.localAddress()).getPort();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, InsecureTrustManagerFactory.INSTANCE.getTrustManagers(), null);
            socket = sslContext.getSocketFactory().createSocket(NetUtil.LOCALHOST, port);
            OutputStream out = socket.getOutputStream();
            out.write(1);
            out.flush();
            Assertions.assertTrue((boolean)promise.await(10L, TimeUnit.SECONDS));
            SecretKey key = (SecretKey)promise.get();
            Assertions.assertEquals((int)48, (int)key.getEncoded().length, (String)"AES secret key must be 48 bytes");
        }
        catch (Throwable throwable) {
            SSLEngineTest.closeQuietly(socket);
            if (originalSystemPropertyValue != null) {
                System.setProperty("org.neo4j.driver.internal.shaded.io.netty.ssl.masterKeyHandler", originalSystemPropertyValue);
            } else {
                System.clearProperty("org.neo4j.driver.internal.shaded.io.netty.ssl.masterKeyHandler");
            }
            throw throwable;
        }
        SSLEngineTest.closeQuietly(socket);
        if (originalSystemPropertyValue != null) {
            System.setProperty("org.neo4j.driver.internal.shaded.io.netty.ssl.masterKeyHandler", originalSystemPropertyValue);
        } else {
            System.clearProperty("org.neo4j.driver.internal.shaded.io.netty.ssl.masterKeyHandler");
        }
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static KeyManagerFactory newKeyManagerFactory(SelfSignedCertificate ssc) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        return SslContext.buildKeyManagerFactory((X509Certificate[])new X509Certificate[]{ssc.cert()}, null, (PrivateKey)ssc.key(), null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testDefaultProtocolsIncludeTLSv13(SSLEngineTestParam param) throws Exception {
        String[] serverProtocols;
        String[] clientProtocols;
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            clientProtocols = clientEngine.getEnabledProtocols();
            serverProtocols = serverEngine.getEnabledProtocols();
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
        Assertions.assertEquals((Object)SslProvider.isTlsv13EnabledByDefault((SslProvider)this.sslClientProvider(), (Provider)this.clientSslContextProvider()), (Object)SslUtils.arrayContains((String[])clientProtocols, (String)"TLSv1.3"));
        Assertions.assertEquals((Object)SslProvider.isTlsv13EnabledByDefault((SslProvider)this.sslServerProvider(), (Provider)this.serverSslContextProvider()), (Object)SslUtils.arrayContains((String[])serverProtocols, (String)"TLSv1.3"));
    }

    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testRSASSAPSS(SSLEngineTestParam param) throws Exception {
        char[] password = "password".toCharArray();
        KeyStore serverKeyStore = KeyStore.getInstance("PKCS12");
        serverKeyStore.load(this.getClass().getResourceAsStream("rsaValidations-server-keystore.p12"), password);
        KeyStore clientKeyStore = KeyStore.getInstance("PKCS12");
        clientKeyStore.load(this.getClass().getResourceAsStream("rsaValidation-user-certs.p12"), password);
        KeyManagerFactory serverKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        serverKeyManagerFactory.init(serverKeyStore, password);
        KeyManagerFactory clientKeyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        clientKeyManagerFactory.init(clientKeyStore, password);
        File commonChain = ResourcesUtil.getFile(this.getClass(), (String)"rsapss-ca-cert.cert");
        ClientAuth auth = ClientAuth.REQUIRE;
        this.mySetupMutualAuth(param, serverKeyManagerFactory, commonChain, clientKeyManagerFactory, commonChain, auth, false, true);
        Assertions.assertTrue((boolean)this.clientLatch.await(10L, TimeUnit.SECONDS));
        SSLEngineTest.rethrowIfNotNull(this.clientException);
        Assertions.assertTrue((boolean)this.serverLatch.await(5L, TimeUnit.SECONDS));
        SSLEngineTest.rethrowIfNotNull(this.serverException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testInvalidSNIIsIgnoredAndNotThrow(SSLEngineTestParam param) throws Exception {
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "/invalid.path", 80));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            Assertions.assertNotNull((Object)clientEngine.getSSLParameters());
            Assertions.assertNotNull((Object)serverEngine.getSSLParameters());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MethodSource(value={"newTestParams"})
    @ParameterizedTest
    public void testBufferUnderflowPacketSizeDependency(SSLEngineTestParam param) throws Exception {
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().keyManager(ssc.certificate(), ssc.privateKey()).trustManager((TrustManagerFactory)null).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).clientAuth(ClientAuth.REQUIRE).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(param.type(), param.delegate(), clientEngine, serverEngine);
            Assertions.fail();
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            return;
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            return;
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTLSv13DisabledIfNoValidCipherSuiteConfigured() throws Exception {
        List<String> ciphers = Collections.singletonList("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(null, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).ciphers(ciphers).build());
        this.serverSslCtx = this.wrapContext(null, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).ciphers(ciphers).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(BufferType.Direct, false, clientEngine, serverEngine);
            Assertions.assertEquals((Object)"TLSv1.2", (Object)clientEngine.getSession().getProtocol());
            Assertions.assertEquals((Object)"TLSv1.2", (Object)serverEngine.getSession().getProtocol());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTLSv13EnabledIfNoCipherSuiteConfigured() throws Exception {
        SslProvider clientProvider = this.sslClientProvider();
        SslProvider serverProvider = this.sslServerProvider();
        if (!SslProvider.isTlsv13Supported((SslProvider)clientProvider) || !SslProvider.isTlsv13Supported((SslProvider)serverProvider)) {
            return;
        }
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(null, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(new String[]{"TLSv1.3"}).build());
        this.serverSslCtx = this.wrapContext(null, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(new String[]{"TLSv1.3"}).build());
        SSLEngine clientEngine = null;
        SSLEngine serverEngine = null;
        try {
            clientEngine = this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            serverEngine = this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
            this.handshake(BufferType.Direct, false, clientEngine, serverEngine);
            Assertions.assertEquals((Object)"TLSv1.3", (Object)clientEngine.getSession().getProtocol());
            Assertions.assertEquals((Object)"TLSv1.3", (Object)serverEngine.getSession().getProtocol());
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
        catch (Throwable throwable) {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
            throw throwable;
        }
    }

    @Test
    public void testExtraDataInLastSrcBufferForClientUnwrap() throws Exception {
        SSLEngineTestParam param = new SSLEngineTestParam(BufferType.Direct, ProtocolCipherCombo.tlsv12(), false);
        SelfSignedCertificate ssc = CachedSelfSignedCertificate.getCachedCertificate();
        this.clientSslCtx = this.wrapContext(param, SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).sslContextProvider(this.clientSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).build());
        this.serverSslCtx = this.wrapContext(param, SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).sslProvider(this.sslServerProvider()).sslContextProvider(this.serverSslContextProvider()).protocols(param.protocols()).ciphers(param.ciphers()).clientAuth(ClientAuth.NONE).build());
        this.testExtraDataInLastSrcBufferForClientUnwrap(param, this.wrapEngine(this.clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT)), this.wrapEngine(this.serverSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void testExtraDataInLastSrcBufferForClientUnwrap(SSLEngineTestParam param, SSLEngine clientEngine, SSLEngine serverEngine) throws Exception {
        try {
            ByteBuffer cTOs = this.allocateBuffer(param.type(), clientEngine.getSession().getPacketBufferSize());
            ByteBuffer sTOc = this.allocateBuffer(param.type(), serverEngine.getSession().getPacketBufferSize() * 2);
            ByteBuffer serverAppReadBuffer = this.allocateBuffer(param.type(), serverEngine.getSession().getApplicationBufferSize());
            ByteBuffer clientAppReadBuffer = this.allocateBuffer(param.type(), clientEngine.getSession().getApplicationBufferSize());
            ByteBuffer empty = this.allocateBuffer(param.type(), 0);
            boolean clientHandshakeFinished = false;
            boolean serverHandshakeFinished = false;
            Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)clientEngine.getHandshakeStatus()));
            Assertions.assertEquals((Object)((Object)SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING), (Object)((Object)serverEngine.getHandshakeStatus()));
            do {
                SSLEngineResult serverResult;
                SSLEngineResult clientResult;
                int cTOsPos = cTOs.position();
                int sTOcPos = sTOc.position();
                if (!clientHandshakeFinished) {
                    clientResult = clientEngine.wrap(empty, cTOs);
                    this.runDelegatedTasks(param.delegate(), clientResult, clientEngine);
                    Assertions.assertEquals((int)empty.remaining(), (int)clientResult.bytesConsumed());
                    Assertions.assertEquals((int)(cTOs.position() - cTOsPos), (int)clientResult.bytesProduced());
                    clientHandshakeFinished = SSLEngineTest.assertHandshakeStatus(clientEngine, clientResult);
                    if (clientResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        cTOs = this.increaseDstBuffer(clientEngine.getSession().getPacketBufferSize(), param.type(), cTOs);
                    }
                }
                if (!serverHandshakeFinished) {
                    serverResult = serverEngine.wrap(empty, sTOc);
                    this.runDelegatedTasks(param.delegate(), serverResult, serverEngine);
                    Assertions.assertEquals((int)empty.remaining(), (int)serverResult.bytesConsumed());
                    Assertions.assertEquals((int)(sTOc.position() - sTOcPos), (int)serverResult.bytesProduced());
                    if (SSLEngineTest.assertHandshakeStatus(serverEngine, serverResult)) {
                        serverHandshakeFinished = true;
                        serverResult = serverEngine.wrap(ByteBuffer.wrap(new byte[8]), sTOc);
                        Assertions.assertEquals((int)8, (int)serverResult.bytesConsumed());
                    }
                    if (serverResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        sTOc = this.increaseDstBuffer(serverEngine.getSession().getPacketBufferSize(), param.type(), sTOc);
                    }
                }
                cTOs.flip();
                sTOc.flip();
                cTOsPos = cTOs.position();
                sTOcPos = sTOc.position();
                if (!clientHandshakeFinished && (sTOc.hasRemaining() || Conscrypt.isEngineSupported((SSLEngine)clientEngine))) {
                    int clientAppReadBufferPos = clientAppReadBuffer.position();
                    clientResult = clientEngine.unwrap(sTOc, clientAppReadBuffer);
                    this.runDelegatedTasks(param.delegate(), clientResult, clientEngine);
                    Assertions.assertEquals((int)(sTOc.position() - sTOcPos), (int)clientResult.bytesConsumed());
                    Assertions.assertEquals((int)(clientAppReadBuffer.position() - clientAppReadBufferPos), (int)clientResult.bytesProduced());
                    Assertions.assertEquals((int)0, (int)clientAppReadBuffer.position());
                    if (SSLEngineTest.assertHandshakeStatus(clientEngine, clientResult)) {
                        clientHandshakeFinished = true;
                    } else {
                        Assertions.assertEquals((int)0, (int)(clientAppReadBuffer.position() - clientAppReadBufferPos));
                    }
                    if (clientResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        clientAppReadBuffer = this.increaseDstBuffer(clientEngine.getSession().getApplicationBufferSize(), param.type(), clientAppReadBuffer);
                    }
                }
                if (!serverHandshakeFinished && (cTOs.hasRemaining() || Conscrypt.isEngineSupported((SSLEngine)serverEngine))) {
                    int serverAppReadBufferPos = serverAppReadBuffer.position();
                    serverResult = serverEngine.unwrap(cTOs, serverAppReadBuffer);
                    this.runDelegatedTasks(param.delegate(), serverResult, serverEngine);
                    Assertions.assertEquals((int)(cTOs.position() - cTOsPos), (int)serverResult.bytesConsumed());
                    Assertions.assertEquals((int)(serverAppReadBuffer.position() - serverAppReadBufferPos), (int)serverResult.bytesProduced());
                    Assertions.assertEquals((int)0, (int)serverAppReadBuffer.position());
                    serverHandshakeFinished = SSLEngineTest.assertHandshakeStatus(serverEngine, serverResult);
                    if (serverResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                        serverAppReadBuffer = this.increaseDstBuffer(serverEngine.getSession().getApplicationBufferSize(), param.type(), serverAppReadBuffer);
                    }
                }
                SSLEngineTest.compactOrClear(cTOs);
                SSLEngineTest.compactOrClear(sTOc);
                serverAppReadBuffer.clear();
                clientAppReadBuffer.clear();
            } while (!clientHandshakeFinished || !serverHandshakeFinished);
        }
        finally {
            this.cleanupClientSslEngine(clientEngine);
            this.cleanupServerSslEngine(serverEngine);
        }
    }

    protected SSLEngine wrapEngine(SSLEngine engine) {
        return engine;
    }

    protected SslContext wrapContext(SSLEngineTestParam param, SslContext context) {
        return context;
    }

    private static final class TestTrustManagerFactory
    extends X509ExtendedTrustManager {
        private final Certificate localCert;
        private volatile boolean verified;

        TestTrustManagerFactory(Certificate localCert) {
            this.localCert = localCert;
        }

        boolean isVerified() {
            return this.verified;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, Socket socket) {
            Assertions.fail();
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            this.verified = true;
            Assertions.assertFalse((boolean)sslEngine.getUseClientMode());
            SSLSession session = sslEngine.getHandshakeSession();
            Assertions.assertNotNull((Object)session);
            Certificate[] localCertificates = session.getLocalCertificates();
            Assertions.assertNotNull((Object)localCertificates);
            Assertions.assertEquals((int)1, (int)localCertificates.length);
            Assertions.assertEquals((Object)this.localCert, (Object)localCertificates[0]);
            Assertions.assertNotNull((Object)session.getLocalPrincipal());
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s, SSLEngine sslEngine) {
            this.verified = true;
            Assertions.assertTrue((boolean)sslEngine.getUseClientMode());
            SSLSession session = sslEngine.getHandshakeSession();
            Assertions.assertNotNull((Object)session);
            Assertions.assertNull((Object)session.getLocalCertificates());
            Assertions.assertNull((Object)session.getLocalPrincipal());
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
            Assertions.fail();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
            Assertions.fail();
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EmptyArrays.EMPTY_X509_CERTIFICATES;
        }
    }

    private class SessionValueSettingTrustManager
    extends EmptyExtendedX509TrustManager
    implements ResumableX509ExtendedTrustManager {
        private final String key;
        private final String value;

        SessionValueSettingTrustManager(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            logger.debug("Authenticating client session: {} ({}, {})", new Object[]{engine.getHandshakeSession(), engine.getHandshakeStatus(), SSLEngineTest.this.clientChannel});
            engine.getHandshakeSession().putValue(this.key, this.value);
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            logger.debug("Authenticating server session: {} ({}, {})", new Object[]{engine.getHandshakeSession(), engine.getHandshakeStatus(), SSLEngineTest.this.serverChannel});
            engine.getHandshakeSession().putValue(this.key, this.value);
        }

        public void resumeClientTrusted(X509Certificate[] chain, SSLEngine engine) throws CertificateException {
            logger.debug("Resuming client session: {} ({}, {})", new Object[]{engine.getSession(), engine.getHandshakeStatus(), SSLEngineTest.this.clientChannel});
            engine.getSession().putValue(this.key, this.value);
        }

        public void resumeServerTrusted(X509Certificate[] chain, SSLEngine engine) throws CertificateException {
            logger.debug("Resuming server session: {} ({}, {})", new Object[]{engine.getSession(), engine.getHandshakeStatus(), SSLEngineTest.this.serverChannel});
            engine.getSession().putValue(this.key, this.value);
        }
    }

    protected static enum SessionReusedState {
        NOT_REUSED,
        MAYBE_REUSED,
        REUSED;

    }

    private static final class TestByteBufAllocator
    implements ByteBufAllocator {
        private final ByteBufAllocator allocator;
        private final BufferType type;

        TestByteBufAllocator(ByteBufAllocator allocator, BufferType type) {
            this.allocator = allocator;
            this.type = type;
        }

        public ByteBuf buffer() {
            switch (this.type) {
                case Direct: {
                    return this.allocator.directBuffer();
                }
                case Heap: {
                    return this.allocator.heapBuffer();
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.directBuffer() : this.allocator.heapBuffer();
                }
            }
            throw new Error();
        }

        public ByteBuf buffer(int initialCapacity) {
            switch (this.type) {
                case Direct: {
                    return this.allocator.directBuffer(initialCapacity);
                }
                case Heap: {
                    return this.allocator.heapBuffer(initialCapacity);
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.directBuffer(initialCapacity) : this.allocator.heapBuffer(initialCapacity);
                }
            }
            throw new Error();
        }

        public ByteBuf buffer(int initialCapacity, int maxCapacity) {
            switch (this.type) {
                case Direct: {
                    return this.allocator.directBuffer(initialCapacity, maxCapacity);
                }
                case Heap: {
                    return this.allocator.heapBuffer(initialCapacity, maxCapacity);
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.directBuffer(initialCapacity, maxCapacity) : this.allocator.heapBuffer(initialCapacity, maxCapacity);
                }
            }
            throw new Error();
        }

        public ByteBuf ioBuffer() {
            return this.allocator.ioBuffer();
        }

        public ByteBuf ioBuffer(int initialCapacity) {
            return this.allocator.ioBuffer(initialCapacity);
        }

        public ByteBuf ioBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.ioBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf heapBuffer() {
            return this.allocator.heapBuffer();
        }

        public ByteBuf heapBuffer(int initialCapacity) {
            return this.allocator.heapBuffer(initialCapacity);
        }

        public ByteBuf heapBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.heapBuffer(initialCapacity, maxCapacity);
        }

        public ByteBuf directBuffer() {
            return this.allocator.directBuffer();
        }

        public ByteBuf directBuffer(int initialCapacity) {
            return this.allocator.directBuffer(initialCapacity);
        }

        public ByteBuf directBuffer(int initialCapacity, int maxCapacity) {
            return this.allocator.directBuffer(initialCapacity, maxCapacity);
        }

        public CompositeByteBuf compositeBuffer() {
            switch (this.type) {
                case Direct: {
                    return this.allocator.compositeDirectBuffer();
                }
                case Heap: {
                    return this.allocator.compositeHeapBuffer();
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.compositeDirectBuffer() : this.allocator.compositeHeapBuffer();
                }
            }
            throw new Error();
        }

        public CompositeByteBuf compositeBuffer(int maxNumComponents) {
            switch (this.type) {
                case Direct: {
                    return this.allocator.compositeDirectBuffer(maxNumComponents);
                }
                case Heap: {
                    return this.allocator.compositeHeapBuffer(maxNumComponents);
                }
                case Mixed: {
                    return PlatformDependent.threadLocalRandom().nextBoolean() ? this.allocator.compositeDirectBuffer(maxNumComponents) : this.allocator.compositeHeapBuffer(maxNumComponents);
                }
            }
            throw new Error();
        }

        public CompositeByteBuf compositeHeapBuffer() {
            return this.allocator.compositeHeapBuffer();
        }

        public CompositeByteBuf compositeHeapBuffer(int maxNumComponents) {
            return this.allocator.compositeHeapBuffer(maxNumComponents);
        }

        public CompositeByteBuf compositeDirectBuffer() {
            return this.allocator.compositeDirectBuffer();
        }

        public CompositeByteBuf compositeDirectBuffer(int maxNumComponents) {
            return this.allocator.compositeDirectBuffer(maxNumComponents);
        }

        public boolean isDirectBufferPooled() {
            return this.allocator.isDirectBufferPooled();
        }

        public int calculateNewCapacity(int minNewCapacity, int maxCapacity) {
            return this.allocator.calculateNewCapacity(minNewCapacity, maxCapacity);
        }
    }

    protected static class SSLEngineTestParam {
        private final BufferType type;
        private final ProtocolCipherCombo protocolCipherCombo;
        private final boolean delegate;

        SSLEngineTestParam(BufferType type, ProtocolCipherCombo protocolCipherCombo, boolean delegate) {
            this.type = type;
            this.protocolCipherCombo = protocolCipherCombo;
            this.delegate = delegate;
        }

        final BufferType type() {
            return this.type;
        }

        final ProtocolCipherCombo combo() {
            return this.protocolCipherCombo;
        }

        final boolean delegate() {
            return this.delegate;
        }

        final List<String> protocols() {
            return Collections.singletonList(this.protocolCipherCombo.protocol);
        }

        final List<String> ciphers() {
            return Collections.singletonList(this.protocolCipherCombo.cipher);
        }

        public String toString() {
            return "SslEngineTestParam{type=" + (Object)((Object)this.type()) + ", protocolCipherCombo=" + this.combo() + ", delegate=" + this.delegate() + '}';
        }
    }

    static final class ProtocolCipherCombo {
        private static final ProtocolCipherCombo TLSV12 = new ProtocolCipherCombo("TLSv1.2", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        private static final ProtocolCipherCombo TLSV13 = new ProtocolCipherCombo("TLSv1.3", "TLS_AES_128_GCM_SHA256");
        final String protocol;
        final String cipher;

        private ProtocolCipherCombo(String protocol, String cipher) {
            this.protocol = protocol;
            this.cipher = cipher;
        }

        static ProtocolCipherCombo tlsv12() {
            return TLSV12;
        }

        static ProtocolCipherCombo tlsv13() {
            return TLSV13;
        }

        public String toString() {
            return "ProtocolCipherCombo{protocol='" + this.protocol + '\'' + ", cipher='" + this.cipher + '\'' + '}';
        }
    }

    static enum BufferType {
        Direct,
        Heap,
        Mixed;

    }

    protected static final class MessageDelegatorChannelHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final MessageReceiver receiver;
        private final CountDownLatch latch;

        public MessageDelegatorChannelHandler(MessageReceiver receiver, CountDownLatch latch) {
            super(false);
            this.receiver = receiver;
            this.latch = latch;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.receiver.messageReceived(ctx, msg);
            this.latch.countDown();
        }
    }

    static interface OnNextMessage {
        public void messageReceived(ChannelHandlerContext var1, ByteBuf var2) throws Exception;
    }

    static final class MessageReceiver {
        final BlockingQueue<ByteBuf> messages = new LinkedBlockingQueue<ByteBuf>();
        final BlockingQueue<OnNextMessage> onNextMessages = new LinkedBlockingQueue<OnNextMessage>();

        MessageReceiver() {
        }

        void messageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
            this.messages.add(msg);
            OnNextMessage onNextMessage = (OnNextMessage)this.onNextMessages.poll();
            if (onNextMessage != null) {
                onNextMessage.messageReceived(ctx, msg);
            }
        }
    }
}

