/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.stream;

import java.io.InputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.handler.stream.ChunkedStream;

public class ChunkedStreamTest {
    @Test
    public void writeTest() throws Exception {
        ChunkedStream chunkedStream = new ChunkedStream(new InputStream(){

            @Override
            public int read() {
                return -1;
            }

            @Override
            public int available() {
                return 1;
            }
        });
        Assertions.assertFalse((boolean)chunkedStream.isEndOfInput());
        Assertions.assertNull((Object)chunkedStream.readChunk((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
        Assertions.assertEquals((long)0L, (long)chunkedStream.progress());
        chunkedStream.close();
        Assertions.assertTrue((boolean)chunkedStream.isEndOfInput());
        Assertions.assertNull((Object)chunkedStream.readChunk((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT));
    }
}

