/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.traffic;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultFileRegion;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.SocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.LineBasedFrameDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.traffic.GlobalTrafficShapingHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.traffic.TrafficCounter;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class FileRegionThrottleTest {
    private static final byte[] BYTES = new byte[262144];
    private static final long WRITE_LIMIT = 65536L;
    private static File tmp;
    private EventLoopGroup group;

    @BeforeAll
    public static void beforeClass() throws IOException {
        Random r = new Random();
        for (int i = 0; i < BYTES.length; ++i) {
            FileRegionThrottleTest.BYTES[i] = (byte)r.nextInt(255);
        }
        tmp = PlatformDependent.createTempFile((String)"netty-traffic", (String)".tmp", null);
        tmp.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tmp);
            out.write(BYTES);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @BeforeEach
    public void setUp() {
        this.group = new NioEventLoopGroup();
    }

    @AfterEach
    public void tearDown() {
        this.group.shutdownGracefully();
    }

    @Disabled(value="This test is flaky, need more investigation")
    @Test
    public void testGlobalWriteThrottle() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        final GlobalTrafficShapingHandler gtsh = new GlobalTrafficShapingHandler((ScheduledExecutorService)this.group, 65536L, 0L);
        ServerBootstrap bs = new ServerBootstrap();
        ((ServerBootstrap)bs.group(this.group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{new LineBasedFrameDecoder(Integer.MAX_VALUE)});
                ch.pipeline().addLast(new ChannelHandler[]{new MessageDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{gtsh});
            }
        });
        Channel sc = bs.bind(0).sync().channel();
        Channel cc = this.clientConnect(sc.localAddress(), new ReadHandler(latch)).channel();
        long start = TrafficCounter.milliSecondFromNano();
        cc.writeAndFlush((Object)Unpooled.copiedBuffer((CharSequence)"send-file\n", (Charset)CharsetUtil.US_ASCII)).sync();
        latch.await();
        long timeTaken = TrafficCounter.milliSecondFromNano() - start;
        Assertions.assertTrue((timeTaken > 3000L ? 1 : 0) != 0, (String)"Data streamed faster than expected");
        sc.close().sync();
        cc.close().sync();
    }

    private ChannelFuture clientConnect(SocketAddress server, final ReadHandler readHandler) throws Exception {
        Bootstrap bc = new Bootstrap();
        ((Bootstrap)((Bootstrap)bc.group(this.group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                ch.pipeline().addLast(new ChannelHandler[]{readHandler});
            }
        });
        return bc.connect(server).sync();
    }

    private static final class ReadHandler
    extends ChannelInboundHandlerAdapter {
        private long bytesTransferred;
        private final CountDownLatch latch;

        ReadHandler(CountDownLatch latch) {
            this.latch = latch;
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                this.bytesTransferred += (long)buf.readableBytes();
                buf.release();
                if (this.bytesTransferred == tmp.length()) {
                    this.latch.countDown();
                }
            }
        }
    }

    private static final class MessageDecoder
    extends ChannelInboundHandlerAdapter {
        private MessageDecoder() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                String message = buf.toString(Charset.defaultCharset());
                buf.release();
                if (message.equals("send-file")) {
                    RandomAccessFile raf = new RandomAccessFile(tmp, "r");
                    ctx.channel().writeAndFlush((Object)new DefaultFileRegion(raf.getChannel(), 0L, tmp.length()));
                }
            }
        }
    }
}

