/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.traffic;

import java.net.SocketAddress;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.traffic.AbstractTrafficShapingHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.traffic.ChannelTrafficShapingHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.traffic.GlobalChannelTrafficShapingHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.traffic.GlobalTrafficShapingHandler;
import org.neo4j.driver.internal.shaded.io.netty.util.Attribute;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class TrafficShapingHandlerTest {
    private static final long READ_LIMIT_BYTES_PER_SECOND = 1L;
    private static final ScheduledExecutorService SES = Executors.newSingleThreadScheduledExecutor();
    private static final DefaultEventLoopGroup GROUP = new DefaultEventLoopGroup(1);

    @AfterAll
    public static void destroy() {
        GROUP.shutdownGracefully();
        SES.shutdown();
    }

    @Test
    public void testHandlerRemove() throws Exception {
        this.testHandlerRemove0((AbstractTrafficShapingHandler)new ChannelTrafficShapingHandler(0L, 1L));
        GlobalTrafficShapingHandler trafficHandler1 = new GlobalTrafficShapingHandler(SES, 0L, 1L);
        try {
            this.testHandlerRemove0((AbstractTrafficShapingHandler)trafficHandler1);
        }
        finally {
            trafficHandler1.release();
        }
        GlobalChannelTrafficShapingHandler trafficHandler2 = new GlobalChannelTrafficShapingHandler(SES, 0L, 1L, 0L, 1L);
        try {
            this.testHandlerRemove0((AbstractTrafficShapingHandler)trafficHandler2);
        }
        finally {
            trafficHandler2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHandlerRemove0(final AbstractTrafficShapingHandler trafficHandler) throws Exception {
        Channel svrChannel = null;
        Channel ch = null;
        try {
            ServerBootstrap serverBootstrap = new ServerBootstrap();
            ((ServerBootstrap)serverBootstrap.channel(LocalServerChannel.class)).group((EventLoopGroup)GROUP, (EventLoopGroup)GROUP).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                            ctx.writeAndFlush(msg);
                        }
                    }});
                }
            });
            LocalAddress svrAddr = new LocalAddress("foo");
            svrChannel = serverBootstrap.bind((SocketAddress)svrAddr).sync().channel();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.channel(LocalChannel.class)).group((EventLoopGroup)GROUP)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast("traffic-shaping", (ChannelHandler)trafficHandler);
                }
            });
            ch = bootstrap.connect((SocketAddress)svrAddr).sync().channel();
            Attribute attr = ch.attr(AbstractTrafficShapingHandler.REOPEN_TASK);
            Assertions.assertNull((Object)attr.get());
            ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"foo".getBytes(CharsetUtil.UTF_8)));
            ch.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"bar".getBytes(CharsetUtil.UTF_8))).await();
            Assertions.assertNotNull((Object)attr.get());
            final Channel clientChannel = ch;
            ch.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    clientChannel.pipeline().remove("traffic-shaping");
                }
            }).await();
            Assertions.assertNull((Object)attr.get());
        }
        finally {
            if (ch != null) {
                ch.close().sync();
            }
            if (svrChannel != null) {
                svrChannel.close().sync();
            }
        }
    }
}

