/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.Attribute;
import org.neo4j.driver.internal.shaded.io.netty.util.AttributeKey;
import org.neo4j.driver.internal.shaded.io.netty.util.DefaultAttributeMap;

public class DefaultAttributeMapTest {
    private DefaultAttributeMap map;

    @BeforeEach
    public void setup() {
        this.map = new DefaultAttributeMap();
    }

    @Test
    public void testMapExists() {
        Assertions.assertNotNull((Object)this.map);
    }

    @Test
    public void testGetSetString() {
        AttributeKey key = AttributeKey.valueOf((String)"Nothing");
        Attribute one = this.map.attr(key);
        Assertions.assertSame((Object)one, (Object)this.map.attr(key));
        one.setIfAbsent((Object)"Whoohoo");
        Assertions.assertSame((Object)"Whoohoo", (Object)one.get());
        one.setIfAbsent((Object)"What");
        Assertions.assertNotSame((Object)"What", (Object)one.get());
        one.remove();
        Assertions.assertNull((Object)one.get());
    }

    @Test
    public void testGetSetInt() {
        AttributeKey key = AttributeKey.valueOf((String)"Nada");
        Attribute one = this.map.attr(key);
        Assertions.assertSame((Object)one, (Object)this.map.attr(key));
        one.setIfAbsent((Object)3653);
        Assertions.assertEquals((Integer)3653, (Integer)((Integer)one.get()));
        one.setIfAbsent((Object)1);
        Assertions.assertNotSame((Object)1, (Object)one.get());
        one.remove();
        Assertions.assertNull((Object)one.get());
    }

    @Test
    public void testSetRemove() {
        AttributeKey key = AttributeKey.valueOf((String)"key");
        Attribute attr = this.map.attr(key);
        attr.set((Object)1);
        Assertions.assertSame((Object)1, (Object)attr.getAndRemove());
        Attribute attr2 = this.map.attr(key);
        attr2.set((Object)2);
        Assertions.assertSame((Object)2, (Object)attr2.get());
        Assertions.assertNotSame((Object)attr, (Object)attr2);
    }

    @Test
    public void testHasAttrRemoved() {
        AttributeKey key;
        int i;
        AttributeKey[] keys = new AttributeKey[20];
        for (i = 0; i < 20; ++i) {
            keys[i] = AttributeKey.valueOf((String)Integer.toString(i));
        }
        for (i = 10; i < 20; ++i) {
            this.map.attr(keys[i]);
        }
        for (i = 0; i < 10; ++i) {
            this.map.attr(keys[i]);
        }
        for (i = 10; i < 20; ++i) {
            key = AttributeKey.valueOf((String)Integer.toString(i));
            Assertions.assertTrue((boolean)this.map.hasAttr(key));
            this.map.attr(key).remove();
            Assertions.assertFalse((boolean)this.map.hasAttr(key));
        }
        for (i = 0; i < 10; ++i) {
            key = AttributeKey.valueOf((String)Integer.toString(i));
            Assertions.assertTrue((boolean)this.map.hasAttr(key));
            this.map.attr(key).remove();
            Assertions.assertFalse((boolean)this.map.hasAttr(key));
        }
    }

    @Test
    public void testGetAndSetWithNull() {
        AttributeKey key = AttributeKey.valueOf((String)"key");
        Attribute attr = this.map.attr(key);
        attr.set((Object)1);
        Assertions.assertSame((Object)1, (Object)attr.getAndSet(null));
        Attribute attr2 = this.map.attr(key);
        attr2.set((Object)2);
        Assertions.assertSame((Object)2, (Object)attr2.get());
        Assertions.assertSame((Object)attr, (Object)attr2);
    }
}

