/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.HashedWheelTimer;
import org.neo4j.driver.internal.shaded.io.netty.util.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.util.TimerTask;

public class HashedWheelTimerTest {
    @Test
    public void testScheduleTimeoutShouldNotRunBeforeDelay() throws InterruptedException {
        HashedWheelTimer timer = new HashedWheelTimer();
        final CountDownLatch barrier = new CountDownLatch(1);
        Timeout timeout = timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                Assertions.fail((String)"This should not have run");
                barrier.countDown();
            }
        }, 10L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)barrier.await(3L, TimeUnit.SECONDS));
        Assertions.assertFalse((boolean)timeout.isExpired(), (String)"timer should not expire");
        timer.stop();
    }

    @Test
    public void testScheduleTimeoutShouldRunAfterDelay() throws InterruptedException {
        HashedWheelTimer timer = new HashedWheelTimer();
        final CountDownLatch barrier = new CountDownLatch(1);
        Timeout timeout = timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                barrier.countDown();
            }
        }, 2L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)barrier.await(3L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)timeout.isExpired(), (String)"timer should expire");
        timer.stop();
    }

    @Test
    @org.junit.jupiter.api.Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testStopTimer() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(3);
        HashedWheelTimer timerProcessed = new HashedWheelTimer();
        for (int i = 0; i < 3; ++i) {
            timerProcessed.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    latch.countDown();
                }
            }, 1L, TimeUnit.MILLISECONDS);
        }
        latch.await();
        Assertions.assertEquals((int)0, (int)timerProcessed.stop().size(), (String)"Number of unprocessed timeouts should be 0");
        HashedWheelTimer timerUnprocessed = new HashedWheelTimer();
        for (int i = 0; i < 5; ++i) {
            timerUnprocessed.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                }
            }, 5L, TimeUnit.SECONDS);
        }
        Thread.sleep(1000L);
        Assertions.assertFalse((boolean)timerUnprocessed.stop().isEmpty(), (String)"Number of unprocessed timeouts should be greater than 0");
    }

    @Test
    @org.junit.jupiter.api.Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testTimerShouldThrowExceptionAfterShutdownForNewTimeouts() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(3);
        HashedWheelTimer timer = new HashedWheelTimer();
        for (int i = 0; i < 3; ++i) {
            timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    latch.countDown();
                }
            }, 1L, TimeUnit.MILLISECONDS);
        }
        latch.await();
        timer.stop();
        try {
            timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 1L, TimeUnit.MILLISECONDS);
            Assertions.fail((String)"Expected exception didn't occur.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    @org.junit.jupiter.api.Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testTimerOverflowWheelLength() throws InterruptedException {
        final HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 32);
        final CountDownLatch latch = new CountDownLatch(3);
        timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                timer.newTimeout((TimerTask)this, 100L, TimeUnit.MILLISECONDS);
                latch.countDown();
            }
        }, 100L, TimeUnit.MILLISECONDS);
        latch.await();
        Assertions.assertFalse((boolean)timer.stop().isEmpty());
    }

    @Test
    public void testExecutionOnTime() throws InterruptedException {
        int i;
        int tickDuration = 200;
        int timeout = 125;
        int maxTimeout = 2 * (tickDuration + timeout);
        HashedWheelTimer timer = new HashedWheelTimer((long)tickDuration, TimeUnit.MILLISECONDS);
        final LinkedBlockingQueue queue = new LinkedBlockingQueue();
        int scheduledTasks = 100000;
        for (i = 0; i < scheduledTasks; ++i) {
            final long start = System.nanoTime();
            timer.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                    queue.add(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
                }
            }, (long)timeout, TimeUnit.MILLISECONDS);
        }
        for (i = 0; i < scheduledTasks; ++i) {
            long delay = (Long)queue.take();
            Assertions.assertTrue((delay >= (long)timeout && delay < (long)maxTimeout ? 1 : 0) != 0, (String)("Timeout + " + scheduledTasks + " delay " + delay + " must be " + timeout + " < " + maxTimeout));
        }
        timer.stop();
    }

    @Test
    public void testExecutionOnTaskExecutor() throws InterruptedException {
        int timeout = 10;
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch timeoutLatch = new CountDownLatch(1);
        Executor executor = new Executor(){

            @Override
            public void execute(Runnable command) {
                try {
                    command.run();
                }
                finally {
                    latch.countDown();
                }
            }
        };
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 32, true, 2L, executor);
        timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                timeoutLatch.countDown();
            }
        }, (long)timeout, TimeUnit.MILLISECONDS);
        latch.await();
        timeoutLatch.await();
        timer.stop();
    }

    @Test
    public void testRejectedExecutionExceptionWhenTooManyTimeoutsAreAddedBackToBack() {
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 32, true, 2L);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        try {
            timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 1L, TimeUnit.MILLISECONDS);
            Assertions.fail((String)"Timer allowed adding 3 timeouts when maxPendingTimeouts was 2");
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        finally {
            timer.stop();
        }
    }

    @Test
    public void testNewTimeoutShouldStopThrowingRejectedExecutionExceptionWhenExistingTimeoutIsCancelled() throws InterruptedException {
        int tickDurationMs = 100;
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 100L, TimeUnit.MILLISECONDS, 32, true, 2L);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        Timeout timeoutToCancel = timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)timeoutToCancel.cancel());
        Thread.sleep(500L);
        CountDownLatch secondLatch = new CountDownLatch(1);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(secondLatch), 90L, TimeUnit.MILLISECONDS);
        secondLatch.await();
        timer.stop();
    }

    @Test
    @org.junit.jupiter.api.Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testNewTimeoutShouldStopThrowingRejectedExecutionExceptionWhenExistingTimeoutIsExecuted() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        HashedWheelTimer timer = new HashedWheelTimer(Executors.defaultThreadFactory(), 25L, TimeUnit.MILLISECONDS, 4, true, 2L);
        timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 5L, TimeUnit.SECONDS);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(latch), 90L, TimeUnit.MILLISECONDS);
        latch.await();
        CountDownLatch secondLatch = new CountDownLatch(1);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(secondLatch), 90L, TimeUnit.MILLISECONDS);
        secondLatch.await();
        timer.stop();
    }

    @Test
    public void reportPendingTimeouts() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        HashedWheelTimer timer = new HashedWheelTimer();
        Timeout t1 = timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 100L, TimeUnit.MINUTES);
        Timeout t2 = timer.newTimeout(HashedWheelTimerTest.createNoOpTimerTask(), 100L, TimeUnit.MINUTES);
        timer.newTimeout(HashedWheelTimerTest.createCountDownLatchTimerTask(latch), 90L, TimeUnit.MILLISECONDS);
        Assertions.assertEquals((long)3L, (long)timer.pendingTimeouts());
        t1.cancel();
        t2.cancel();
        latch.await();
        Assertions.assertEquals((long)0L, (long)timer.pendingTimeouts());
        timer.stop();
    }

    @Test
    public void testOverflow() throws InterruptedException {
        HashedWheelTimer timer = new HashedWheelTimer();
        final CountDownLatch latch = new CountDownLatch(1);
        Timeout timeout = timer.newTimeout(new TimerTask(){

            public void run(Timeout timeout) {
                latch.countDown();
            }
        }, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)latch.await(1L, TimeUnit.SECONDS));
        timeout.cancel();
        timer.stop();
    }

    @Test
    @org.junit.jupiter.api.Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testStopTimerCancelsPendingTasks() throws InterruptedException {
        HashedWheelTimer timerUnprocessed = new HashedWheelTimer();
        for (int i = 0; i < 5; ++i) {
            timerUnprocessed.newTimeout(new TimerTask(){

                public void run(Timeout timeout) throws Exception {
                }
            }, 5L, TimeUnit.SECONDS);
        }
        Thread.sleep(1000L);
        for (Timeout timeout : timerUnprocessed.stop()) {
            Assertions.assertTrue((boolean)timeout.isCancelled(), (String)"All unprocessed tasks should be canceled");
        }
    }

    private static TimerTask createNoOpTimerTask() {
        return new TimerTask(){

            public void run(Timeout timeout) throws Exception {
            }
        };
    }

    private static TimerTask createCountDownLatchTimerTask(final CountDownLatch latch) {
        return new TimerTask(){

            public void run(Timeout timeout) throws Exception {
                latch.countDown();
            }
        };
    }
}

