/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.util.NettyRuntime;
import org.neo4j.driver.internal.shaded.io.netty.util.SuppressForbidden;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.SystemPropertyUtil;

public class NettyRuntimeTests {
    @Test
    public void testIllegalSet() {
        NettyRuntime.AvailableProcessorsHolder holder = new NettyRuntime.AvailableProcessorsHolder();
        for (int i : new int[]{-1, 0}) {
            try {
                holder.setAvailableProcessors(i);
                Assertions.fail();
            }
            catch (IllegalArgumentException e) {
                MatcherAssert.assertThat((Object)e, (Matcher)Matchers.hasToString((Matcher)Matchers.containsString((String)"(expected: > 0)")));
            }
        }
    }

    @Test
    public void testMultipleSets() {
        NettyRuntime.AvailableProcessorsHolder holder = new NettyRuntime.AvailableProcessorsHolder();
        holder.setAvailableProcessors(1);
        try {
            holder.setAvailableProcessors(2);
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.hasToString((Matcher)Matchers.containsString((String)"availableProcessors is already set to [1], rejecting [2]")));
        }
    }

    @Test
    public void testSetAfterGet() {
        NettyRuntime.AvailableProcessorsHolder holder = new NettyRuntime.AvailableProcessorsHolder();
        holder.availableProcessors();
        try {
            holder.setAvailableProcessors(1);
            Assertions.fail();
        }
        catch (IllegalStateException e) {
            MatcherAssert.assertThat((Object)e, (Matcher)Matchers.hasToString((Matcher)Matchers.containsString((String)"availableProcessors is already set")));
        }
    }

    @Test
    public void testRacingGetAndGet() throws InterruptedException {
        NettyRuntime.AvailableProcessorsHolder holder = new NettyRuntime.AvailableProcessorsHolder();
        CyclicBarrier barrier = new CyclicBarrier(3);
        AtomicReference<IllegalStateException> firstReference = new AtomicReference<IllegalStateException>();
        Runnable firstTarget = NettyRuntimeTests.getRunnable(holder, barrier, firstReference);
        Thread firstGet = new Thread(firstTarget);
        firstGet.start();
        AtomicReference<IllegalStateException> secondRefernce = new AtomicReference<IllegalStateException>();
        Runnable secondTarget = NettyRuntimeTests.getRunnable(holder, barrier, secondRefernce);
        Thread secondGet = new Thread(secondTarget);
        secondGet.start();
        NettyRuntimeTests.await(barrier);
        NettyRuntimeTests.await(barrier);
        firstGet.join();
        secondGet.join();
        Assertions.assertNull((Object)firstReference.get());
        Assertions.assertNull((Object)secondRefernce.get());
    }

    private static Runnable getRunnable(final NettyRuntime.AvailableProcessorsHolder holder, final CyclicBarrier barrier, final AtomicReference<IllegalStateException> reference) {
        return new Runnable(){

            @Override
            public void run() {
                NettyRuntimeTests.await(barrier);
                try {
                    holder.availableProcessors();
                }
                catch (IllegalStateException e) {
                    reference.set(e);
                }
                NettyRuntimeTests.await(barrier);
            }
        };
    }

    @Test
    public void testRacingGetAndSet() throws InterruptedException {
        final NettyRuntime.AvailableProcessorsHolder holder = new NettyRuntime.AvailableProcessorsHolder();
        final CyclicBarrier barrier = new CyclicBarrier(3);
        Thread get = new Thread(new Runnable(){

            @Override
            public void run() {
                NettyRuntimeTests.await(barrier);
                holder.availableProcessors();
                NettyRuntimeTests.await(barrier);
            }
        });
        get.start();
        final AtomicReference setException = new AtomicReference();
        Thread set = new Thread(new Runnable(){

            @Override
            public void run() {
                NettyRuntimeTests.await(barrier);
                try {
                    holder.setAvailableProcessors(2048);
                }
                catch (IllegalStateException e) {
                    setException.set(e);
                }
                NettyRuntimeTests.await(barrier);
            }
        });
        set.start();
        NettyRuntimeTests.await(barrier);
        NettyRuntimeTests.await(barrier);
        get.join();
        set.join();
        if (setException.get() == null) {
            MatcherAssert.assertThat((Object)holder.availableProcessors(), (Matcher)Matchers.equalTo((Object)2048));
        } else {
            Assertions.assertNotNull(setException.get());
        }
    }

    @Test
    public void testGetWithSystemProperty() {
        String availableProcessorsSystemProperty = SystemPropertyUtil.get((String)"org.neo4j.driver.internal.shaded.io.netty.availableProcessors");
        try {
            System.setProperty("org.neo4j.driver.internal.shaded.io.netty.availableProcessors", "2048");
            NettyRuntime.AvailableProcessorsHolder holder = new NettyRuntime.AvailableProcessorsHolder();
            MatcherAssert.assertThat((Object)holder.availableProcessors(), (Matcher)Matchers.equalTo((Object)2048));
        }
        finally {
            if (availableProcessorsSystemProperty != null) {
                System.setProperty("org.neo4j.driver.internal.shaded.io.netty.availableProcessors", availableProcessorsSystemProperty);
            } else {
                System.clearProperty("org.neo4j.driver.internal.shaded.io.netty.availableProcessors");
            }
        }
    }

    @Test
    @SuppressForbidden(reason="testing fallback to Runtime#availableProcessors")
    public void testGet() {
        String availableProcessorsSystemProperty = SystemPropertyUtil.get((String)"org.neo4j.driver.internal.shaded.io.netty.availableProcessors");
        try {
            System.clearProperty("org.neo4j.driver.internal.shaded.io.netty.availableProcessors");
            NettyRuntime.AvailableProcessorsHolder holder = new NettyRuntime.AvailableProcessorsHolder();
            MatcherAssert.assertThat((Object)holder.availableProcessors(), (Matcher)Matchers.equalTo((Object)Runtime.getRuntime().availableProcessors()));
        }
        finally {
            if (availableProcessorsSystemProperty != null) {
                System.setProperty("org.neo4j.driver.internal.shaded.io.netty.availableProcessors", availableProcessorsSystemProperty);
            } else {
                System.clearProperty("org.neo4j.driver.internal.shaded.io.netty.availableProcessors");
            }
        }
    }

    private static void await(CyclicBarrier barrier) {
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            Assertions.fail((String)e.toString());
        }
        catch (BrokenBarrierException e) {
            Assertions.fail((String)e.toString());
        }
    }
}

