/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ObjectCleaner;

public class ObjectCleanerTest {
    private Thread temporaryThread;
    private Object temporaryObject;

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testCleanup() throws Exception {
        final AtomicBoolean freeCalled = new AtomicBoolean();
        final CountDownLatch latch = new CountDownLatch(1);
        this.temporaryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.temporaryThread.start();
        ObjectCleaner.register((Object)this.temporaryThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                freeCalled.set(true);
            }
        });
        latch.countDown();
        this.temporaryThread.join();
        Assertions.assertFalse((boolean)freeCalled.get());
        this.temporaryThread = null;
        while (!freeCalled.get()) {
            System.gc();
            System.runFinalization();
            Thread.sleep(100L);
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testCleanupContinuesDespiteThrowing() throws InterruptedException {
        final AtomicInteger freeCalledCount = new AtomicInteger();
        final CountDownLatch latch = new CountDownLatch(1);
        this.temporaryThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        this.temporaryThread.start();
        this.temporaryObject = new Object();
        ObjectCleaner.register((Object)this.temporaryThread, (Runnable)new Runnable(){

            @Override
            public void run() {
                freeCalledCount.incrementAndGet();
                throw new RuntimeException("expected");
            }
        });
        ObjectCleaner.register((Object)this.temporaryObject, (Runnable)new Runnable(){

            @Override
            public void run() {
                freeCalledCount.incrementAndGet();
                throw new RuntimeException("expected");
            }
        });
        latch.countDown();
        this.temporaryThread.join();
        Assertions.assertEquals((int)0, (int)freeCalledCount.get());
        this.temporaryThread = null;
        this.temporaryObject = null;
        while (freeCalledCount.get() != 2) {
            System.gc();
            System.runFinalization();
            Thread.sleep(100L);
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testCleanerThreadIsDaemon() throws Exception {
        this.temporaryObject = new Object();
        ObjectCleaner.register((Object)this.temporaryObject, (Runnable)new Runnable(){

            @Override
            public void run() {
            }
        });
        Thread cleanerThread = null;
        for (Thread thread : Thread.getAllStackTraces().keySet()) {
            if (!thread.getName().equals(ObjectCleaner.CLEANER_THREAD_NAME)) continue;
            cleanerThread = thread;
            break;
        }
        Assertions.assertNotNull(cleanerThread);
        Assertions.assertTrue((boolean)cleanerThread.isDaemon());
    }
}

