/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.util.internal.logging;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.mockito.Mockito;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLogger;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.logging.InternalLoggerFactory;

public class InternalLoggerFactoryTest {
    private static final Exception e = new Exception();
    private InternalLoggerFactory oldLoggerFactory;
    private InternalLogger mockLogger;

    @BeforeEach
    public void init() {
        this.oldLoggerFactory = InternalLoggerFactory.getDefaultFactory();
        InternalLoggerFactory mockFactory = (InternalLoggerFactory)Mockito.mock(InternalLoggerFactory.class);
        this.mockLogger = (InternalLogger)Mockito.mock(InternalLogger.class);
        Mockito.when((Object)mockFactory.newInstance("mock")).thenReturn((Object)this.mockLogger);
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)mockFactory);
    }

    @AfterEach
    public void destroy() {
        Mockito.reset((Object[])new InternalLogger[]{this.mockLogger});
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)this.oldLoggerFactory);
    }

    @Test
    public void shouldNotAllowNullDefaultFactory() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                InternalLoggerFactory.setDefaultFactory(null);
            }
        });
    }

    @Test
    public void shouldGetInstance() {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)this.oldLoggerFactory);
        String helloWorld = "Hello, world!";
        InternalLogger one = InternalLoggerFactory.getInstance((String)"helloWorld");
        InternalLogger two = InternalLoggerFactory.getInstance(helloWorld.getClass());
        Assertions.assertNotNull((Object)one);
        Assertions.assertNotNull((Object)two);
        Assertions.assertNotSame((Object)one, (Object)two);
    }

    @Test
    public void testIsTraceEnabled() {
        Mockito.when((Object)this.mockLogger.isTraceEnabled()).thenReturn((Object)true);
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        Assertions.assertTrue((boolean)logger.isTraceEnabled());
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).isTraceEnabled();
    }

    @Test
    public void testIsDebugEnabled() {
        Mockito.when((Object)this.mockLogger.isDebugEnabled()).thenReturn((Object)true);
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        Assertions.assertTrue((boolean)logger.isDebugEnabled());
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).isDebugEnabled();
    }

    @Test
    public void testIsInfoEnabled() {
        Mockito.when((Object)this.mockLogger.isInfoEnabled()).thenReturn((Object)true);
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        Assertions.assertTrue((boolean)logger.isInfoEnabled());
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).isInfoEnabled();
    }

    @Test
    public void testIsWarnEnabled() {
        Mockito.when((Object)this.mockLogger.isWarnEnabled()).thenReturn((Object)true);
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        Assertions.assertTrue((boolean)logger.isWarnEnabled());
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).isWarnEnabled();
    }

    @Test
    public void testIsErrorEnabled() {
        Mockito.when((Object)this.mockLogger.isErrorEnabled()).thenReturn((Object)true);
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        Assertions.assertTrue((boolean)logger.isErrorEnabled());
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).isErrorEnabled();
    }

    @Test
    public void testTrace() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.trace("a");
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).trace("a");
    }

    @Test
    public void testTraceWithException() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.trace("a", (Throwable)e);
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).trace("a", (Throwable)e);
    }

    @Test
    public void testDebug() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.debug("a");
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).debug("a");
    }

    @Test
    public void testDebugWithException() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.debug("a", (Throwable)e);
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).debug("a", (Throwable)e);
    }

    @Test
    public void testInfo() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.info("a");
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).info("a");
    }

    @Test
    public void testInfoWithException() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.info("a", (Throwable)e);
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).info("a", (Throwable)e);
    }

    @Test
    public void testWarn() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.warn("a");
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).warn("a");
    }

    @Test
    public void testWarnWithException() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.warn("a", (Throwable)e);
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).warn("a", (Throwable)e);
    }

    @Test
    public void testError() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.error("a");
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).error("a");
    }

    @Test
    public void testErrorWithException() {
        InternalLogger logger = InternalLoggerFactory.getInstance((String)"mock");
        logger.error("a", (Throwable)e);
        ((InternalLogger)Mockito.verify((Object)this.mockLogger)).error("a", (Throwable)e);
    }
}

