/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocatorMetric;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocatorMetricProvider;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocatorTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SimpleLeakAwareByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledDirectByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledHeapByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledUnsafeDirectByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public abstract class AbstractByteBufAllocatorTest<T extends AbstractByteBufAllocator>
extends ByteBufAllocatorTest {
    protected abstract T newAllocator(boolean var1);

    protected abstract T newUnpooledAllocator();

    @Override
    protected boolean isDirectExpected(boolean preferDirect) {
        return preferDirect && PlatformDependent.hasUnsafe();
    }

    @Override
    protected final int defaultMaxCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected final int defaultMaxComponents() {
        return 16;
    }

    @Test
    public void testCalculateNewCapacity() {
        this.testCalculateNewCapacity(true);
        this.testCalculateNewCapacity(false);
    }

    private void testCalculateNewCapacity(boolean preferDirect) {
        T allocator = this.newAllocator(preferDirect);
        org.junit.jupiter.api.Assertions.assertEquals((int)8, (int)allocator.calculateNewCapacity(1, 8));
        org.junit.jupiter.api.Assertions.assertEquals((int)7, (int)allocator.calculateNewCapacity(1, 7));
        org.junit.jupiter.api.Assertions.assertEquals((int)64, (int)allocator.calculateNewCapacity(1, 129));
        org.junit.jupiter.api.Assertions.assertEquals((int)0x400000, (int)allocator.calculateNewCapacity(0x400000, 0x400001));
        org.junit.jupiter.api.Assertions.assertEquals((int)0x800000, (int)allocator.calculateNewCapacity(0x400001, 0x1000000));
        try {
            allocator.calculateNewCapacity(8, 7);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            allocator.calculateNewCapacity(-1, 8);
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsafeHeapBufferAndUnsafeDirectBuffer() {
        T allocator = this.newUnpooledAllocator();
        ByteBuf directBuffer = allocator.directBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(directBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeDirectByteBuf.class : UnpooledDirectByteBuf.class);
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        AbstractByteBufAllocatorTest.assertInstanceOf(heapBuffer, PlatformDependent.hasUnsafe() ? UnpooledUnsafeHeapByteBuf.class : UnpooledHeapByteBuf.class);
        heapBuffer.release();
    }

    protected static void assertInstanceOf(ByteBuf buffer, Class<? extends ByteBuf> clazz) {
        if (buffer instanceof SimpleLeakAwareByteBuf) {
            buffer = buffer.unwrap();
        }
        Assertions.assertThat((Comparable)buffer).isInstanceOf(clazz);
    }

    protected static void assertSameBuffer(ByteBuf expected, ByteBuf buffer) {
        org.junit.jupiter.api.Assertions.assertSame((Object)expected, (Object)(buffer instanceof SimpleLeakAwareByteBuf ? buffer.unwrap() : buffer));
    }

    @Test
    public void testUsedDirectMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedDirectMemory());
        ByteBuf buffer = allocator.directBuffer(1024, 4096);
        int capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedDirectMemory(), (String)buffer.toString());
        buffer.release();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedDirectMemory());
    }

    @Test
    public void testUsedHeapMemory() {
        T allocator = this.newAllocator(true);
        ByteBufAllocatorMetric metric = ((ByteBufAllocatorMetricProvider)allocator).metric();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)metric.usedHeapMemory());
        ByteBuf buffer = allocator.heapBuffer(1024, 4096);
        int capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.capacity(capacity << 1);
        capacity = buffer.capacity();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemory(allocator, capacity), (long)metric.usedHeapMemory());
        buffer.release();
        org.junit.jupiter.api.Assertions.assertEquals((long)this.expectedUsedMemoryAfterRelease(allocator, capacity), (long)metric.usedHeapMemory());
    }

    @Test
    public void shouldReuseChunks() throws Exception {
        int bufSize = 0x100000;
        T allocator = this.newAllocator(false);
        allocator.heapBuffer(bufSize, bufSize).release();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        Class<?> cls = null;
        try {
            cls = Class.forName("com.sun.management.ThreadMXBean");
        }
        catch (ClassNotFoundException e) {
            org.junit.jupiter.api.Assumptions.abort((String)"Internal ThreadMXBean not available");
        }
        Assumptions.assumeThat((Object)threadMXBean).isInstanceOf(cls);
        Method getThreadAllocatedBytes = cls.getDeclaredMethod("getThreadAllocatedBytes", Long.TYPE);
        long allocBefore = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, Thread.currentThread().getId());
        org.junit.jupiter.api.Assumptions.assumeTrue((allocBefore != -1L ? 1 : 0) != 0);
        for (int i = 0; i < 100; ++i) {
            allocator.heapBuffer(bufSize, bufSize).release();
        }
        long allocAfter = (Long)getThreadAllocatedBytes.invoke((Object)threadMXBean, Thread.currentThread().getId());
        org.junit.jupiter.api.Assumptions.assumeTrue((allocAfter != -1L ? 1 : 0) != 0);
        ((AbstractLongAssert)Assertions.assertThat((long)(allocAfter - allocBefore)).as("allocated MB: %.3f", new Object[]{(double)(allocAfter - allocBefore) / 1024.0 / 1024.0})).isLessThan(0x800000L);
    }

    protected long expectedUsedMemory(T allocator, int capacity) {
        return capacity;
    }

    protected long expectedUsedMemoryAfterRelease(T allocator, int capacity) {
        return 0L;
    }

    protected void trimCaches(T allocator) {
    }
}

