/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBufAllocatorTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AdaptiveByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AdaptivePoolingAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;

public class AdaptiveByteBufAllocatorTest
extends AbstractByteBufAllocatorTest<AdaptiveByteBufAllocator> {
    @Override
    protected AdaptiveByteBufAllocator newAllocator(boolean preferDirect) {
        return new AdaptiveByteBufAllocator(preferDirect);
    }

    @Override
    protected AdaptiveByteBufAllocator newUnpooledAllocator() {
        return this.newAllocator(false);
    }

    @Override
    protected long expectedUsedMemory(AdaptiveByteBufAllocator allocator, int capacity) {
        return 131072L;
    }

    @Override
    protected long expectedUsedMemoryAfterRelease(AdaptiveByteBufAllocator allocator, int capacity) {
        return 131072L;
    }

    @Override
    @Test
    public void testUnsafeHeapBufferAndUnsafeDirectBuffer() {
        AdaptiveByteBufAllocator allocator = this.newUnpooledAllocator();
        ByteBuf directBuffer = allocator.directBuffer();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(directBuffer, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        Assertions.assertTrue((boolean)directBuffer.isDirect());
        directBuffer.release();
        ByteBuf heapBuffer = allocator.heapBuffer();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(heapBuffer, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        Assertions.assertFalse((boolean)heapBuffer.isDirect());
        heapBuffer.release();
    }

    @Test
    void chunkMustDeallocateOrReuseWthBufferRelease() throws Exception {
        AdaptiveByteBufAllocator allocator = this.newAllocator(false);
        ByteBuf a = allocator.heapBuffer(8192);
        Assertions.assertEquals((long)131072L, (long)allocator.usedHeapMemory());
        ByteBuf b = allocator.heapBuffer(122880);
        Assertions.assertEquals((long)131072L, (long)allocator.usedHeapMemory());
        b.release();
        a.release();
        Assertions.assertEquals((long)131072L, (long)allocator.usedHeapMemory());
        a = allocator.heapBuffer(8192);
        Assertions.assertEquals((long)131072L, (long)allocator.usedHeapMemory());
        b = allocator.heapBuffer(122880);
        Assertions.assertEquals((long)131072L, (long)allocator.usedHeapMemory());
        a.release();
        ByteBuf c = allocator.heapBuffer(8192);
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
        c.release();
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
        b.release();
        Assertions.assertEquals((long)262144L, (long)allocator.usedHeapMemory());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void sliceOrDuplicateUnwrapLetNotEscapeRootParent(boolean slice) {
        AdaptiveByteBufAllocator allocator = this.newAllocator(false);
        ByteBuf buffer = allocator.buffer(8);
        AdaptiveByteBufAllocatorTest.assertInstanceOf(buffer, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        Assertions.assertNull((Object)buffer.unwrap());
        ByteBuf derived = slice ? buffer.slice(0, 4) : buffer.duplicate();
        ByteBuf unwrapped = derived.unwrap();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(unwrapped, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        AdaptiveByteBufAllocatorTest.assertSameBuffer(buffer, unwrapped);
        ByteBuf retainedDerived = slice ? buffer.retainedSlice(0, 4) : buffer.retainedDuplicate();
        ByteBuf unwrappedRetained = retainedDerived.unwrap();
        AdaptiveByteBufAllocatorTest.assertInstanceOf(unwrappedRetained, AdaptivePoolingAllocator.AdaptiveByteBuf.class);
        AdaptiveByteBufAllocatorTest.assertSameBuffer(buffer, unwrappedRetained);
        retainedDerived.release();
        Assertions.assertTrue((boolean)buffer.release());
    }
}

