/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AdaptiveByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AdaptiveByteBufAllocatorTest;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.FastThreadLocalThread;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.ObjectUtil;

public class AdaptiveByteBufAllocatorUseCacheForNonEventLoopThreadsTest
extends AdaptiveByteBufAllocatorTest {
    @Override
    protected AdaptiveByteBufAllocator newAllocator(boolean preferDirect) {
        return new AdaptiveByteBufAllocator(preferDirect, true);
    }

    @Override
    protected AdaptiveByteBufAllocator newUnpooledAllocator() {
        return this.newAllocator(false);
    }

    @Test
    void testFastThreadLocalThreadWithoutCleanupFastThreadLocals() throws InterruptedException {
        final AtomicReference throwable = new AtomicReference();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    AdaptiveByteBufAllocatorUseCacheForNonEventLoopThreadsTest.super.testUsedHeapMemory();
                    AdaptiveByteBufAllocatorUseCacheForNonEventLoopThreadsTest.super.testUsedDirectMemory();
                }
                catch (Throwable e) {
                    throwable.set(e);
                }
            }
        };
        CustomizeFastThreadLocalThreadWithoutCleanupFastThreadLocals customizefastThreadLocalThread = new CustomizeFastThreadLocalThreadWithoutCleanupFastThreadLocals(task);
        ((Thread)((Object)customizefastThreadLocalThread)).start();
        ((Thread)((Object)customizefastThreadLocalThread)).join();
        Assertions.assertNull(throwable.get());
    }

    private static final class CustomizeFastThreadLocalThreadWithoutCleanupFastThreadLocals
    extends FastThreadLocalThread
    implements Runnable {
        private final Runnable runnable;

        private CustomizeFastThreadLocalThreadWithoutCleanupFastThreadLocals(Runnable runnable) {
            this.runnable = (Runnable)ObjectUtil.checkNotNull((Object)runnable, (String)"runnable");
        }

        public boolean willCleanupFastThreadLocals() {
            return false;
        }

        @Override
        public void run() {
            this.runnable.run();
        }
    }
}

