/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AdvancedLeakAwareByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.NoopResourceLeakTracker;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SimpleLeakAwareByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SimpleLeakAwareByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ResourceLeakTracker;

public class AdvancedLeakAwareByteBufTest
extends SimpleLeakAwareByteBufTest {
    @Override
    protected Class<? extends ByteBuf> leakClass() {
        return AdvancedLeakAwareByteBuf.class;
    }

    @Override
    protected SimpleLeakAwareByteBuf wrap(ByteBuf buffer, ResourceLeakTracker<ByteBuf> tracker) {
        return new AdvancedLeakAwareByteBuf(buffer, tracker);
    }

    @Test
    public void testAddComponentWithLeakAwareByteBuf() {
        NoopResourceLeakTracker<ByteBuf> tracker = new NoopResourceLeakTracker<ByteBuf>();
        ByteBuf buffer = Unpooled.wrappedBuffer((byte[])"hello world".getBytes(CharsetUtil.US_ASCII)).slice(6, 5);
        SimpleLeakAwareByteBuf leakAwareBuf = this.wrap(buffer, tracker);
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        composite.addComponent(true, (ByteBuf)leakAwareBuf);
        byte[] result = new byte[5];
        ByteBuf bb = composite.component(0);
        bb.readBytes(result);
        Assertions.assertArrayEquals((byte[])"world".getBytes(CharsetUtil.US_ASCII), (byte[])result);
        composite.release();
    }
}

