/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;

public abstract class ByteBufAllocatorTest {
    protected abstract int defaultMaxCapacity();

    protected abstract int defaultMaxComponents();

    protected abstract ByteBufAllocator newAllocator(boolean var1);

    @Test
    public void testBuffer() {
        this.testBuffer(true);
        this.testBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBuffer(boolean preferDirect) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        ByteBuf buffer = allocator.buffer(1);
        try {
            ByteBufAllocatorTest.assertBuffer(buffer, this.isDirectExpected(preferDirect), 1, this.defaultMaxCapacity());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testBufferWithCapacity() {
        this.testBufferWithCapacity(true, 8);
        this.testBufferWithCapacity(false, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testBufferWithCapacity(boolean preferDirect, int maxCapacity) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        ByteBuf buffer = allocator.buffer(1, maxCapacity);
        try {
            ByteBufAllocatorTest.assertBuffer(buffer, this.isDirectExpected(preferDirect), 1, maxCapacity);
        }
        finally {
            buffer.release();
        }
    }

    protected abstract boolean isDirectExpected(boolean var1);

    @Test
    public void testHeapBuffer() {
        this.testHeapBuffer(true);
        this.testHeapBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHeapBuffer(boolean preferDirect) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        ByteBuf buffer = allocator.heapBuffer(1);
        try {
            ByteBufAllocatorTest.assertBuffer(buffer, false, 1, this.defaultMaxCapacity());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testHeapBufferMaxCapacity() {
        this.testHeapBuffer(true, 8);
        this.testHeapBuffer(false, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHeapBuffer(boolean preferDirect, int maxCapacity) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        ByteBuf buffer = allocator.heapBuffer(1, maxCapacity);
        try {
            ByteBufAllocatorTest.assertBuffer(buffer, false, 1, maxCapacity);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testDirectBuffer() {
        this.testDirectBuffer(true);
        this.testDirectBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDirectBuffer(boolean preferDirect) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        ByteBuf buffer = allocator.directBuffer(1);
        try {
            ByteBufAllocatorTest.assertBuffer(buffer, true, 1, this.defaultMaxCapacity());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testDirectBufferMaxCapacity() {
        this.testDirectBuffer(true, 8);
        this.testDirectBuffer(false, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDirectBuffer(boolean preferDirect, int maxCapacity) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        ByteBuf buffer = allocator.directBuffer(1, maxCapacity);
        try {
            ByteBufAllocatorTest.assertBuffer(buffer, true, 1, maxCapacity);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCompositeBuffer() {
        this.testCompositeBuffer(true);
        this.testCompositeBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompositeBuffer(boolean preferDirect) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        CompositeByteBuf buffer = allocator.compositeBuffer();
        try {
            this.assertCompositeByteBuf(buffer, this.defaultMaxComponents());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCompositeBufferWithCapacity() {
        this.testCompositeHeapBufferWithCapacity(true, 8);
        this.testCompositeHeapBufferWithCapacity(false, 8);
    }

    @Test
    public void testCompositeHeapBuffer() {
        this.testCompositeHeapBuffer(true);
        this.testCompositeHeapBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompositeHeapBuffer(boolean preferDirect) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        CompositeByteBuf buffer = allocator.compositeHeapBuffer();
        try {
            this.assertCompositeByteBuf(buffer, this.defaultMaxComponents());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCompositeHeapBufferWithCapacity() {
        this.testCompositeHeapBufferWithCapacity(true, 8);
        this.testCompositeHeapBufferWithCapacity(false, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompositeHeapBufferWithCapacity(boolean preferDirect, int maxNumComponents) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        CompositeByteBuf buffer = allocator.compositeHeapBuffer(maxNumComponents);
        try {
            this.assertCompositeByteBuf(buffer, maxNumComponents);
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCompositeDirectBuffer() {
        this.testCompositeDirectBuffer(true);
        this.testCompositeDirectBuffer(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompositeDirectBuffer(boolean preferDirect) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        CompositeByteBuf buffer = allocator.compositeDirectBuffer();
        try {
            this.assertCompositeByteBuf(buffer, this.defaultMaxComponents());
        }
        finally {
            buffer.release();
        }
    }

    @Test
    public void testCompositeDirectBufferWithCapacity() {
        this.testCompositeDirectBufferWithCapacity(true, 8);
        this.testCompositeDirectBufferWithCapacity(false, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCompositeDirectBufferWithCapacity(boolean preferDirect, int maxNumComponents) {
        ByteBufAllocator allocator = this.newAllocator(preferDirect);
        CompositeByteBuf buffer = allocator.compositeDirectBuffer(maxNumComponents);
        try {
            this.assertCompositeByteBuf(buffer, maxNumComponents);
        }
        finally {
            buffer.release();
        }
    }

    private static void assertBuffer(ByteBuf buffer, boolean expectedDirect, int expectedCapacity, int expectedMaxCapacity) {
        Assertions.assertEquals((Object)expectedDirect, (Object)buffer.isDirect());
        Assertions.assertEquals((int)expectedCapacity, (int)buffer.capacity());
        Assertions.assertEquals((int)expectedMaxCapacity, (int)buffer.maxCapacity());
    }

    private void assertCompositeByteBuf(CompositeByteBuf buffer, int expectedMaxNumComponents) {
        Assertions.assertEquals((int)0, (int)buffer.numComponents());
        Assertions.assertEquals((int)expectedMaxNumComponents, (int)buffer.maxNumComponents());
        ByteBufAllocatorTest.assertBuffer((ByteBuf)buffer, false, 0, this.defaultMaxCapacity());
    }
}

