/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.nio.ByteOrder;
import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractUnpooledSlicedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.DuplicatedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ReadOnlyByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SwappedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;

public class ByteBufDerivationTest {
    @Test
    public void testSlice() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf slice = buf.slice(1, 7);
        MatcherAssert.assertThat((Object)slice, (Matcher)Matchers.instanceOf(AbstractUnpooledSlicedByteBuf.class));
        MatcherAssert.assertThat((Object)slice.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)slice.readerIndex(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)slice.writerIndex(), (Matcher)Matchers.is((Object)7));
        MatcherAssert.assertThat((Object)slice.capacity(), (Matcher)Matchers.is((Object)7));
        MatcherAssert.assertThat((Object)slice.maxCapacity(), (Matcher)Matchers.is((Object)7));
        slice.setIndex(1, 6);
        MatcherAssert.assertThat((Object)buf.readerIndex(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)buf.writerIndex(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void testSliceOfSlice() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8);
        ByteBuf slice = buf.slice(1, 7);
        ByteBuf slice2 = slice.slice(0, 6);
        MatcherAssert.assertThat((Object)slice2, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)slice)));
        MatcherAssert.assertThat((Object)slice2, (Matcher)Matchers.instanceOf(AbstractUnpooledSlicedByteBuf.class));
        MatcherAssert.assertThat((Object)slice2.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)slice2.writerIndex(), (Matcher)Matchers.is((Object)6));
        MatcherAssert.assertThat((Object)slice2.capacity(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void testDuplicate() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf dup = buf.duplicate();
        MatcherAssert.assertThat((Object)dup, (Matcher)Matchers.instanceOf(DuplicatedByteBuf.class));
        MatcherAssert.assertThat((Object)dup.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)dup.readerIndex(), (Matcher)Matchers.is((Object)buf.readerIndex()));
        MatcherAssert.assertThat((Object)dup.writerIndex(), (Matcher)Matchers.is((Object)buf.writerIndex()));
        MatcherAssert.assertThat((Object)dup.capacity(), (Matcher)Matchers.is((Object)buf.capacity()));
        MatcherAssert.assertThat((Object)dup.maxCapacity(), (Matcher)Matchers.is((Object)buf.maxCapacity()));
        dup.setIndex(2, 6);
        MatcherAssert.assertThat((Object)buf.readerIndex(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)buf.writerIndex(), (Matcher)Matchers.is((Object)7));
    }

    @Test
    public void testDuplicateOfDuplicate() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf dup = buf.duplicate().setIndex(2, 6);
        ByteBuf dup2 = dup.duplicate();
        MatcherAssert.assertThat((Object)dup2, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)dup)));
        MatcherAssert.assertThat((Object)dup2, (Matcher)Matchers.instanceOf(DuplicatedByteBuf.class));
        MatcherAssert.assertThat((Object)dup2.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)dup2.readerIndex(), (Matcher)Matchers.is((Object)dup.readerIndex()));
        MatcherAssert.assertThat((Object)dup2.writerIndex(), (Matcher)Matchers.is((Object)dup.writerIndex()));
        MatcherAssert.assertThat((Object)dup2.capacity(), (Matcher)Matchers.is((Object)dup.capacity()));
        MatcherAssert.assertThat((Object)dup2.maxCapacity(), (Matcher)Matchers.is((Object)dup.maxCapacity()));
    }

    @Test
    public void testReadOnly() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)buf);
        MatcherAssert.assertThat((Object)ro, (Matcher)Matchers.instanceOf(ReadOnlyByteBuf.class));
        MatcherAssert.assertThat((Object)ro.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)ro.readerIndex(), (Matcher)Matchers.is((Object)buf.readerIndex()));
        MatcherAssert.assertThat((Object)ro.writerIndex(), (Matcher)Matchers.is((Object)buf.writerIndex()));
        MatcherAssert.assertThat((Object)ro.capacity(), (Matcher)Matchers.is((Object)buf.capacity()));
        MatcherAssert.assertThat((Object)ro.maxCapacity(), (Matcher)Matchers.is((Object)buf.maxCapacity()));
        ro.setIndex(2, 6);
        MatcherAssert.assertThat((Object)buf.readerIndex(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testReadOnlyOfReadOnly() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)buf).setIndex(2, 6);
        ByteBuf ro2 = Unpooled.unmodifiableBuffer((ByteBuf)ro);
        MatcherAssert.assertThat((Object)ro2, (Matcher)Matchers.not((Matcher)Matchers.sameInstance((Object)ro)));
        MatcherAssert.assertThat((Object)ro2, (Matcher)Matchers.instanceOf(ReadOnlyByteBuf.class));
        MatcherAssert.assertThat((Object)ro2.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)ro2.readerIndex(), (Matcher)Matchers.is((Object)ro.readerIndex()));
        MatcherAssert.assertThat((Object)ro2.writerIndex(), (Matcher)Matchers.is((Object)ro.writerIndex()));
        MatcherAssert.assertThat((Object)ro2.capacity(), (Matcher)Matchers.is((Object)ro.capacity()));
        MatcherAssert.assertThat((Object)ro2.maxCapacity(), (Matcher)Matchers.is((Object)ro.maxCapacity()));
    }

    @Test
    public void testReadOnlyOfDuplicate() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf dup = buf.duplicate().setIndex(2, 6);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)dup);
        MatcherAssert.assertThat((Object)ro, (Matcher)Matchers.instanceOf(ReadOnlyByteBuf.class));
        MatcherAssert.assertThat((Object)ro.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)ro.readerIndex(), (Matcher)Matchers.is((Object)dup.readerIndex()));
        MatcherAssert.assertThat((Object)ro.writerIndex(), (Matcher)Matchers.is((Object)dup.writerIndex()));
        MatcherAssert.assertThat((Object)ro.capacity(), (Matcher)Matchers.is((Object)dup.capacity()));
        MatcherAssert.assertThat((Object)ro.maxCapacity(), (Matcher)Matchers.is((Object)dup.maxCapacity()));
    }

    @Test
    public void testDuplicateOfReadOnly() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf ro = Unpooled.unmodifiableBuffer((ByteBuf)buf).setIndex(2, 6);
        ByteBuf dup = ro.duplicate();
        MatcherAssert.assertThat((Object)dup, (Matcher)Matchers.instanceOf(ReadOnlyByteBuf.class));
        MatcherAssert.assertThat((Object)dup.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)dup.readerIndex(), (Matcher)Matchers.is((Object)ro.readerIndex()));
        MatcherAssert.assertThat((Object)dup.writerIndex(), (Matcher)Matchers.is((Object)ro.writerIndex()));
        MatcherAssert.assertThat((Object)dup.capacity(), (Matcher)Matchers.is((Object)ro.capacity()));
        MatcherAssert.assertThat((Object)dup.maxCapacity(), (Matcher)Matchers.is((Object)ro.maxCapacity()));
    }

    @Test
    public void testSwap() throws Exception {
        ByteBuf buf = Unpooled.buffer((int)8).setIndex(1, 7);
        ByteBuf swapped = buf.order(ByteOrder.LITTLE_ENDIAN);
        MatcherAssert.assertThat((Object)swapped, (Matcher)Matchers.instanceOf(SwappedByteBuf.class));
        MatcherAssert.assertThat((Object)swapped.unwrap(), (Matcher)Matchers.sameInstance((Object)buf));
        MatcherAssert.assertThat((Object)swapped.order(ByteOrder.LITTLE_ENDIAN), (Matcher)Matchers.sameInstance((Object)swapped));
        MatcherAssert.assertThat((Object)swapped.order(ByteOrder.BIG_ENDIAN), (Matcher)Matchers.sameInstance((Object)buf));
        buf.setIndex(2, 6);
        MatcherAssert.assertThat((Object)swapped.readerIndex(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)swapped.writerIndex(), (Matcher)Matchers.is((Object)6));
    }

    @Test
    public void testMixture() throws Exception {
        ByteBuf buf;
        ByteBuf derived = buf = Unpooled.buffer((int)10000);
        Random rnd = new Random();
        for (int i = 0; i < buf.capacity(); ++i) {
            ByteBuf newDerived;
            switch (rnd.nextInt(4)) {
                case 0: {
                    newDerived = derived.slice(1, derived.capacity() - 1);
                    break;
                }
                case 1: {
                    newDerived = derived.duplicate();
                    break;
                }
                case 2: {
                    newDerived = derived.order(derived.order() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
                    break;
                }
                case 3: {
                    newDerived = Unpooled.unmodifiableBuffer((ByteBuf)derived);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            MatcherAssert.assertThat((String)("nest level of " + newDerived), (Object)ByteBufDerivationTest.nestLevel(newDerived), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(3))));
            MatcherAssert.assertThat((String)("nest level of " + newDerived.order(ByteOrder.BIG_ENDIAN)), (Object)ByteBufDerivationTest.nestLevel(newDerived.order(ByteOrder.BIG_ENDIAN)), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2))));
            derived = newDerived;
        }
    }

    private static int nestLevel(ByteBuf buf) {
        int depth = 0;
        ByteBuf b = buf.order(ByteOrder.BIG_ENDIAN);
        while (b.unwrap() != null || b instanceof SwappedByteBuf) {
            ++depth;
            if (b instanceof SwappedByteBuf) {
                b = b.order(ByteOrder.BIG_ENDIAN);
                continue;
            }
            b = b.unwrap();
        }
        return depth;
    }
}

