/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class ConsolidationTest {
    @Test
    public void shouldWrapInSequence() {
        ByteBuf currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])"a".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"=".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"1".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"&".getBytes(CharsetUtil.US_ASCII))});
        ByteBuf copy = currentBuffer.copy();
        String s = copy.toString(CharsetUtil.US_ASCII);
        Assertions.assertEquals((Object)"a=1&", (Object)s);
        currentBuffer.release();
        copy.release();
    }

    @Test
    public void shouldConsolidationInSequence() {
        ByteBuf currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{Unpooled.wrappedBuffer((byte[])"a".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"=".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"1".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"&".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"b".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"=".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"2".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"&".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"c".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"=".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"3".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"&".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"d".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"=".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"4".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"&".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"e".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"=".getBytes(CharsetUtil.US_ASCII))});
        currentBuffer = Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{currentBuffer, Unpooled.wrappedBuffer((byte[])"5".getBytes(CharsetUtil.US_ASCII)), Unpooled.wrappedBuffer((byte[])"&".getBytes(CharsetUtil.US_ASCII))});
        ByteBuf copy = currentBuffer.copy();
        String s = copy.toString(CharsetUtil.US_ASCII);
        Assertions.assertEquals((Object)"a=1&b=2&c=3&d=4&e=5&", (Object)s);
        currentBuffer.release();
        copy.release();
    }
}

