/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufHolder;
import org.neo4j.driver.internal.shaded.io.netty.buffer.DefaultByteBufHolder;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;

public class DefaultByteBufHolderTest {
    @Test
    public void testToString() {
        DefaultByteBufHolder holder = new DefaultByteBufHolder(Unpooled.buffer());
        Assertions.assertEquals((int)1, (int)holder.refCnt());
        Assertions.assertNotNull((Object)holder.toString());
        Assertions.assertTrue((boolean)holder.release());
        Assertions.assertNotNull((Object)holder.toString());
    }

    @Test
    public void testEqualsAndHashCode() {
        DefaultByteBufHolder holder = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER);
        ByteBufHolder copy = holder.copy();
        try {
            Assertions.assertEquals((Object)holder, (Object)copy);
            Assertions.assertEquals((int)holder.hashCode(), (int)copy.hashCode());
        }
        finally {
            holder.release();
            copy.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDifferentClassesAreNotEqual() {
        DefaultByteBufHolder dflt = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER);
        OtherByteBufHolder other = new OtherByteBufHolder(Unpooled.EMPTY_BUFFER, 123);
        DefaultByteBufHolder constant1 = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER){};
        DefaultByteBufHolder constant2 = new DefaultByteBufHolder(Unpooled.EMPTY_BUFFER){};
        try {
            Assertions.assertFalse((boolean)dflt.equals((Object)other));
            Assertions.assertFalse((boolean)dflt.equals(constant1));
            Assertions.assertFalse((boolean)constant1.equals(dflt));
            Assertions.assertFalse((boolean)constant1.equals((Object)other));
            Assertions.assertFalse((boolean)constant1.equals(constant2));
        }
        finally {
            dflt.release();
            other.release();
            constant1.release();
            constant2.release();
        }
    }

    private static class OtherByteBufHolder
    extends DefaultByteBufHolder {
        private final int extraField;

        OtherByteBufHolder(ByteBuf data, int extraField) {
            super(data);
            this.extraField = extraField;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            OtherByteBufHolder that = (OtherByteBufHolder)((Object)o);
            return this.extraField == that.extraField;
        }

        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.extraField;
            return result;
        }
    }
}

