/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.AbstractByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.DuplicatedByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;

public class DuplicatedByteBufTest
extends AbstractByteBufTest {
    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        ByteBuf wrapped = Unpooled.buffer((int)length, (int)maxCapacity);
        DuplicatedByteBuf buffer = new DuplicatedByteBuf(wrapped);
        Assertions.assertEquals((int)wrapped.writerIndex(), (int)buffer.writerIndex());
        Assertions.assertEquals((int)wrapped.readerIndex(), (int)buffer.readerIndex());
        return buffer;
    }

    @Test
    public void testIsContiguous() {
        ByteBuf buf = this.newBuffer(4);
        Assertions.assertEquals((Object)buf.unwrap().isContiguous(), (Object)buf.isContiguous());
        buf.release();
    }

    @Test
    public void shouldNotAllowNullInConstructor() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DuplicatedByteBuf(null);
            }
        });
    }

    @Test
    public void testIncreaseCapacityWrapped() {
        ByteBuf buffer = this.newBuffer(8);
        ByteBuf wrapped = buffer.unwrap();
        wrapped.writeByte(0);
        wrapped.readerIndex(wrapped.readerIndex() + 1);
        buffer.writerIndex(buffer.writerIndex() + 1);
        wrapped.capacity(wrapped.capacity() * 2);
        Assertions.assertEquals((byte)0, (byte)buffer.readByte());
    }

    @Test
    public void testMarksInitialized() {
        ByteBuf wrapped = Unpooled.buffer((int)8);
        try {
            wrapped.writerIndex(6);
            wrapped.readerIndex(1);
            DuplicatedByteBuf duplicate = new DuplicatedByteBuf(wrapped);
            duplicate.writerIndex(duplicate.writerIndex() + 1);
            duplicate.resetWriterIndex();
            Assertions.assertEquals((int)wrapped.writerIndex(), (int)duplicate.writerIndex());
            duplicate.readerIndex(duplicate.readerIndex() + 1);
            duplicate.resetReaderIndex();
            Assertions.assertEquals((int)wrapped.readerIndex(), (int)duplicate.readerIndex());
        }
        finally {
            wrapped.release();
        }
    }
}

