/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.nio.ByteBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ReadOnlyDirectByteBufferBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ReadOnlyUnsafeDirectByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class ReadOnlyUnsafeDirectByteBufferBufTest
extends ReadOnlyDirectByteBufferBufTest {
    @BeforeAll
    public static void assumeConditions() {
        Assumptions.assumeTrue((boolean)PlatformDependent.hasUnsafe(), (String)"sun.misc.Unsafe not found, skip tests");
    }

    @Override
    protected ByteBuf buffer(ByteBuffer buffer) {
        return new ReadOnlyUnsafeDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, buffer);
    }

    @Override
    @Test
    public void testMemoryAddress() {
        ByteBuf buf = this.buffer(this.allocate(8).asReadOnlyBuffer());
        try {
            Assertions.assertTrue((boolean)buf.hasMemoryAddress());
            buf.memoryAddress();
        }
        finally {
            buf.release();
        }
    }
}

