/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import java.util.ArrayDeque;
import java.util.Queue;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.BigEndianHeapByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.NoopResourceLeakTracker;
import org.neo4j.driver.internal.shaded.io.netty.buffer.SimpleLeakAwareByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.ResourceLeakTracker;

public class SimpleLeakAwareByteBufTest
extends BigEndianHeapByteBufTest {
    private final Class<? extends ByteBuf> clazz = this.leakClass();
    private final Queue<NoopResourceLeakTracker<ByteBuf>> trackers = new ArrayDeque<NoopResourceLeakTracker<ByteBuf>>();

    @Override
    protected final ByteBuf newBuffer(int capacity, int maxCapacity) {
        return this.wrap(super.newBuffer(capacity, maxCapacity));
    }

    private ByteBuf wrap(ByteBuf buffer) {
        NoopResourceLeakTracker<ByteBuf> tracker = new NoopResourceLeakTracker<ByteBuf>();
        SimpleLeakAwareByteBuf leakAwareBuf = this.wrap(buffer, tracker);
        this.trackers.add(tracker);
        return leakAwareBuf;
    }

    protected SimpleLeakAwareByteBuf wrap(ByteBuf buffer, ResourceLeakTracker<ByteBuf> tracker) {
        return new SimpleLeakAwareByteBuf(buffer, tracker);
    }

    @Override
    @BeforeEach
    public void init() {
        super.init();
        this.trackers.clear();
    }

    @Override
    @AfterEach
    public void dispose() {
        NoopResourceLeakTracker<ByteBuf> tracker;
        super.dispose();
        while ((tracker = this.trackers.poll()) != null) {
            Assertions.assertTrue((boolean)tracker.get());
        }
    }

    protected Class<? extends ByteBuf> leakClass() {
        return SimpleLeakAwareByteBuf.class;
    }

    @Test
    public void testWrapSlice() {
        this.assertWrapped(this.newBuffer(8).slice());
    }

    @Test
    public void testWrapSlice2() {
        this.assertWrapped(this.newBuffer(8).slice(0, 1));
    }

    @Test
    public void testWrapReadSlice() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.readSlice(1));
        } else {
            Assertions.assertTrue((boolean)buffer.release());
        }
    }

    @Test
    public void testWrapRetainedSlice() {
        ByteBuf buffer = this.newBuffer(8);
        this.assertWrapped(buffer.retainedSlice());
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapRetainedSlice2() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.retainedSlice(0, 1));
        }
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapReadRetainedSlice() {
        ByteBuf buffer = this.newBuffer(8);
        if (buffer.isReadable()) {
            this.assertWrapped(buffer.readRetainedSlice(1));
        }
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapDuplicate() {
        this.assertWrapped(this.newBuffer(8).duplicate());
    }

    @Test
    public void testWrapRetainedDuplicate() {
        ByteBuf buffer = this.newBuffer(8);
        this.assertWrapped(buffer.retainedDuplicate());
        Assertions.assertTrue((boolean)buffer.release());
    }

    @Test
    public void testWrapReadOnly() {
        this.assertWrapped(this.newBuffer(8).asReadOnly());
    }

    protected final void assertWrapped(ByteBuf buf) {
        try {
            Assertions.assertSame(this.clazz, buf.getClass());
        }
        finally {
            buf.release();
        }
    }
}

