/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.buffer;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.BigEndianUnsafeDirectByteBufTest;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.WrappedUnpooledUnsafeDirectByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class WrappedUnpooledUnsafeByteBufTest
extends BigEndianUnsafeDirectByteBufTest {
    @Override
    @BeforeEach
    public void init() {
        Assumptions.assumeTrue((boolean)PlatformDependent.useDirectBufferNoCleaner(), (String)"PlatformDependent.useDirectBufferNoCleaner() returned false, skip tests");
        super.init();
    }

    @Override
    protected ByteBuf newBuffer(int length, int maxCapacity) {
        Assumptions.assumeTrue((maxCapacity == Integer.MAX_VALUE ? 1 : 0) != 0);
        return new WrappedUnpooledUnsafeDirectByteBuf((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, PlatformDependent.allocateMemory((long)length), length, true);
    }

    @Override
    @Test
    public void testInternalNioBuffer() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testInternalNioBuffer();
            }
        });
    }

    @Override
    @Test
    public void testDuplicateReadGatheringByteChannelMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                WrappedUnpooledUnsafeByteBufTest.super.testDuplicateReadGatheringByteChannelMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testSliceReadGatheringByteChannelMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                WrappedUnpooledUnsafeByteBufTest.super.testSliceReadGatheringByteChannelMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testDuplicateReadOutputStreamMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                WrappedUnpooledUnsafeByteBufTest.super.testDuplicateReadOutputStreamMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testSliceReadOutputStreamMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                WrappedUnpooledUnsafeByteBufTest.super.testSliceReadOutputStreamMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testDuplicateBytesInArrayMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                WrappedUnpooledUnsafeByteBufTest.super.testDuplicateBytesInArrayMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testSliceBytesInArrayMultipleThreads() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() throws Exception {
                WrappedUnpooledUnsafeByteBufTest.super.testSliceBytesInArrayMultipleThreads();
            }
        });
    }

    @Override
    @Test
    public void testNioBufferExposeOnlyRegion() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testNioBufferExposeOnlyRegion();
            }
        });
    }

    @Override
    @Test
    public void testGetReadOnlyDirectDst() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testGetReadOnlyDirectDst();
            }
        });
    }

    @Override
    @Test
    public void testGetReadOnlyHeapDst() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testGetReadOnlyHeapDst();
            }
        });
    }

    @Override
    @Test
    public void testReadBytes() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testReadBytes();
            }
        });
    }

    @Override
    @Test
    public void testDuplicateCapacityChange() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testDuplicateCapacityChange();
            }
        });
    }

    @Override
    @Test
    public void testRetainedDuplicateCapacityChange() {
        Assertions.assertThrows(IllegalArgumentException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testRetainedDuplicateCapacityChange();
            }
        });
    }

    @Override
    @Test
    public void testLittleEndianWithExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testLittleEndianWithExpand();
            }
        });
    }

    @Override
    @Test
    public void testWriteUsAsciiCharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testWriteUsAsciiCharSequenceExpand();
            }
        });
    }

    @Override
    @Test
    public void testWriteUtf8CharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testWriteUtf8CharSequenceExpand();
            }
        });
    }

    @Override
    @Test
    public void testWriteIso88591CharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testWriteIso88591CharSequenceExpand();
            }
        });
    }

    @Override
    @Test
    public void testWriteUtf16CharSequenceExpand() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testWriteUtf16CharSequenceExpand();
            }
        });
    }

    @Override
    @Test
    public void testGetBytesByteBuffer() {
        Assertions.assertThrows(IndexOutOfBoundsException.class, (Executable)new Executable(){

            public void execute() {
                WrappedUnpooledUnsafeByteBufTest.super.testGetBytesByteBuffer();
            }
        });
    }

    @Override
    @Test
    public void testForEachByteDesc2() {
    }

    @Override
    @Test
    public void testForEachByte2() {
    }
}

