/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import org.junit.jupiter.api.Assertions;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.LoggingHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;

class BaseChannelTest {
    private final LoggingHandler loggingHandler = new LoggingHandler();

    BaseChannelTest() {
    }

    ServerBootstrap getLocalServerBootstrap() {
        DefaultEventLoopGroup serverGroup = new DefaultEventLoopGroup();
        ServerBootstrap sb = new ServerBootstrap();
        sb.group((EventLoopGroup)serverGroup);
        sb.channel(LocalServerChannel.class);
        sb.childHandler((ChannelHandler)new ChannelInitializer<LocalChannel>(){

            public void initChannel(LocalChannel ch) throws Exception {
            }
        });
        return sb;
    }

    Bootstrap getLocalClientBootstrap() {
        DefaultEventLoopGroup clientGroup = new DefaultEventLoopGroup();
        Bootstrap cb = new Bootstrap();
        cb.channel(LocalChannel.class);
        cb.group((EventLoopGroup)clientGroup);
        cb.handler((ChannelHandler)this.loggingHandler);
        return cb;
    }

    static ByteBuf createTestBuf(int len) {
        ByteBuf buf = Unpooled.buffer((int)len, (int)len);
        buf.setIndex(0, len);
        return buf;
    }

    void assertLog(String firstExpected, String ... otherExpected) {
        String actual = this.loggingHandler.getLog();
        if (firstExpected.equals(actual)) {
            return;
        }
        for (String e : otherExpected) {
            if (!e.equals(actual)) continue;
            return;
        }
        Assertions.assertEquals((Object)firstExpected, (Object)actual);
    }

    void clearLog() {
        this.loggingHandler.clear();
    }

    void setInterest(LoggingHandler.Event ... events) {
        this.loggingHandler.setInterest(events);
    }
}

