/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.AbstractCoalescingBufferQueue;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.CoalescingBufferQueue;
import org.neo4j.driver.internal.shaded.io.netty.channel.WriteBufferWaterMark;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class CoalescingBufferQueueTest {
    private ByteBuf cat;
    private ByteBuf mouse;
    private ChannelPromise catPromise;
    private ChannelPromise emptyPromise;
    private ChannelPromise voidPromise;
    private ChannelFutureListener mouseListener;
    private boolean mouseDone;
    private boolean mouseSuccess;
    private EmbeddedChannel channel;
    private CoalescingBufferQueue writeQueue;

    @BeforeEach
    public void setup() {
        this.mouseDone = false;
        this.mouseSuccess = false;
        this.channel = new EmbeddedChannel();
        this.writeQueue = new CoalescingBufferQueue((Channel)this.channel, 16, true);
        this.catPromise = this.newPromise();
        this.mouseListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                CoalescingBufferQueueTest.this.mouseDone = true;
                CoalescingBufferQueueTest.this.mouseSuccess = future.isSuccess();
            }
        };
        this.emptyPromise = this.newPromise();
        this.voidPromise = this.channel.voidPromise();
        this.cat = Unpooled.wrappedBuffer((byte[])"cat".getBytes(CharsetUtil.US_ASCII));
        this.mouse = Unpooled.wrappedBuffer((byte[])"mouse".getBytes(CharsetUtil.US_ASCII));
    }

    @AfterEach
    public void finish() {
        Assertions.assertFalse((boolean)this.channel.finish());
    }

    @Test
    public void testAddFirstPromiseRetained() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catmous", (Object)this.dequeue(7, aggregatePromise));
        ByteBuf remainder = Unpooled.wrappedBuffer((byte[])"mous".getBytes(CharsetUtil.US_ASCII));
        this.writeQueue.addFirst(remainder, aggregatePromise);
        ChannelPromise aggregatePromise2 = this.newPromise();
        Assertions.assertEquals((Object)"mouse", (Object)this.dequeue(5, aggregatePromise2));
        aggregatePromise2.setSuccess();
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)this.mouse.refCnt());
    }

    @Test
    public void testAddFirstVoidPromise() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catmous", (Object)this.dequeue(7, aggregatePromise));
        ByteBuf remainder = Unpooled.wrappedBuffer((byte[])"mous".getBytes(CharsetUtil.US_ASCII));
        this.writeQueue.addFirst(remainder, this.voidPromise);
        ChannelPromise aggregatePromise2 = this.newPromise();
        Assertions.assertEquals((Object)"mouse", (Object)this.dequeue(5, aggregatePromise2));
        aggregatePromise2.setSuccess();
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)this.mouse.refCnt());
    }

    @Test
    public void testAggregateWithFullRead() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.assertQueueSize(3, false);
        this.writeQueue.add(this.mouse, this.mouseListener);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catmouse", (Object)this.dequeue(8, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)this.mouse.refCnt());
    }

    @Test
    public void testWithVoidPromise() {
        this.writeQueue.add(this.cat, this.voidPromise);
        this.writeQueue.add(this.mouse, this.voidPromise);
        this.assertQueueSize(8, false);
        Assertions.assertEquals((Object)"catm", (Object)this.dequeue(4, this.newPromise()));
        this.assertQueueSize(4, false);
        Assertions.assertEquals((Object)"ouse", (Object)this.dequeue(4, this.newPromise()));
        this.assertQueueSize(0, true);
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)this.mouse.refCnt());
    }

    @Test
    public void testAggregateWithPartialRead() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catm", (Object)this.dequeue(4, aggregatePromise));
        this.assertQueueSize(4, false);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"ouse", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)this.mouse.refCnt());
    }

    @Test
    public void testReadExactAddedBufferSizeReturnsOriginal() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertSame((Object)this.cat, (Object)this.writeQueue.remove(3, aggregatePromise));
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertEquals((int)1, (int)this.cat.refCnt());
        this.cat.release();
        aggregatePromise = this.newPromise();
        Assertions.assertSame((Object)this.mouse, (Object)this.writeQueue.remove(5, aggregatePromise));
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertEquals((int)1, (int)this.mouse.refCnt());
        this.mouse.release();
    }

    @Test
    public void testReadEmptyQueueReturnsEmptyBuffer() {
        this.cat.release();
        this.mouse.release();
        this.assertQueueSize(0, true);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
    }

    @Test
    public void testReleaseAndFailAll() {
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(this.mouse, this.mouseListener);
        RuntimeException cause = new RuntimeException("ooops");
        this.writeQueue.releaseAndFailAll((Throwable)cause);
        ChannelPromise aggregatePromise = this.newPromise();
        this.assertQueueSize(0, true);
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)this.mouse.refCnt());
        Assertions.assertSame((Object)cause, (Object)this.catPromise.cause());
        Assertions.assertEquals((Object)"", (Object)this.dequeue(Integer.MAX_VALUE, aggregatePromise));
        this.assertQueueSize(0, true);
    }

    @Test
    public void testEmptyBuffersAreCoalesced() {
        ByteBuf empty = Unpooled.buffer((int)0, (int)1);
        this.assertQueueSize(0, true);
        this.writeQueue.add(this.cat, this.catPromise);
        this.writeQueue.add(empty, this.emptyPromise);
        this.assertQueueSize(3, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"cat", (Object)this.dequeue(3, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.emptyPromise.isSuccess());
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.emptyPromise.isSuccess());
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)empty.refCnt());
    }

    @Test
    public void testMerge() {
        this.writeQueue.add(this.cat, this.catPromise);
        CoalescingBufferQueue otherQueue = new CoalescingBufferQueue((Channel)this.channel);
        otherQueue.add(this.mouse, this.mouseListener);
        otherQueue.copyTo((AbstractCoalescingBufferQueue)this.writeQueue);
        this.assertQueueSize(8, false);
        ChannelPromise aggregatePromise = this.newPromise();
        Assertions.assertEquals((Object)"catmouse", (Object)this.dequeue(8, aggregatePromise));
        this.assertQueueSize(0, true);
        Assertions.assertFalse((boolean)this.catPromise.isSuccess());
        Assertions.assertFalse((boolean)this.mouseDone);
        aggregatePromise.setSuccess();
        Assertions.assertTrue((boolean)this.catPromise.isSuccess());
        Assertions.assertTrue((boolean)this.mouseSuccess);
        Assertions.assertEquals((int)0, (int)this.cat.refCnt());
        Assertions.assertEquals((int)0, (int)this.mouse.refCnt());
    }

    @Test
    public void testWritabilityChanged() {
        this.testWritabilityChanged0(false);
    }

    @Test
    public void testWritabilityChangedFailAll() {
        this.testWritabilityChanged0(true);
    }

    private void testWritabilityChanged0(boolean fail) {
        this.channel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(3, 4));
        Assertions.assertTrue((boolean)this.channel.isWritable());
        this.writeQueue.add(Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3}));
        Assertions.assertTrue((boolean)this.channel.isWritable());
        this.writeQueue.add(Unpooled.wrappedBuffer((byte[])new byte[]{4, 5}));
        Assertions.assertFalse((boolean)this.channel.isWritable());
        Assertions.assertEquals((int)5, (int)this.writeQueue.readableBytes());
        if (fail) {
            this.writeQueue.releaseAndFailAll((Throwable)new IllegalStateException());
        } else {
            ByteBuf buffer = this.writeQueue.removeFirst(this.voidPromise);
            Assertions.assertEquals((int)1, (int)buffer.readByte());
            Assertions.assertEquals((int)2, (int)buffer.readByte());
            Assertions.assertEquals((int)3, (int)buffer.readByte());
            Assertions.assertFalse((boolean)buffer.isReadable());
            buffer.release();
            Assertions.assertTrue((boolean)this.channel.isWritable());
            buffer = this.writeQueue.removeFirst(this.voidPromise);
            Assertions.assertEquals((int)4, (int)buffer.readByte());
            Assertions.assertEquals((int)5, (int)buffer.readByte());
            Assertions.assertFalse((boolean)buffer.isReadable());
            buffer.release();
        }
        Assertions.assertTrue((boolean)this.channel.isWritable());
        Assertions.assertTrue((boolean)this.writeQueue.isEmpty());
    }

    private ChannelPromise newPromise() {
        return this.channel.newPromise();
    }

    private void assertQueueSize(int size, boolean isEmpty) {
        Assertions.assertEquals((int)size, (int)this.writeQueue.readableBytes());
        if (isEmpty) {
            Assertions.assertTrue((boolean)this.writeQueue.isEmpty());
        } else {
            Assertions.assertFalse((boolean)this.writeQueue.isEmpty());
        }
    }

    private String dequeue(int numBytes, ChannelPromise aggregatePromise) {
        ByteBuf removed = this.writeQueue.remove(numBytes, aggregatePromise);
        String result = removed.toString(CharsetUtil.US_ASCII);
        ReferenceCountUtil.safeRelease((Object)removed);
        return result;
    }
}

