/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.ImmediateEventExecutor;

public class DefaultChannelPromiseTest {
    @Test
    public void testNullChannel() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultChannelPromise(null);
            }
        });
    }

    @Test
    public void testChannelWithNullExecutor() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultChannelPromise((Channel)new EmbeddedChannel(), null);
            }
        });
    }

    @Test
    public void testNullChannelWithExecutor() {
        Assertions.assertThrows(NullPointerException.class, (Executable)new Executable(){

            public void execute() {
                new DefaultChannelPromise(null, (EventExecutor)ImmediateEventExecutor.INSTANCE);
            }
        });
    }
}

