/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.embedded;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufInputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufOutputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelId;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannelId;

public class EmbeddedChannelIdTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialization() throws IOException, ClassNotFoundException {
        ChannelId deserializedInstance;
        ChannelId normalInstance = EmbeddedChannelId.INSTANCE;
        ByteBuf buf = Unpooled.buffer();
        ObjectOutputStream outStream = new ObjectOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            outStream.writeObject(normalInstance);
        }
        finally {
            outStream.close();
        }
        ObjectInputStream inStream = new ObjectInputStream((InputStream)new ByteBufInputStream(buf, true));
        try {
            deserializedInstance = (ChannelId)inStream.readObject();
        }
        finally {
            inStream.close();
        }
        Assertions.assertEquals((Object)normalInstance, (Object)deserializedInstance);
        Assertions.assertEquals((int)normalInstance.hashCode(), (int)deserializedInstance.hashCode());
        Assertions.assertEquals((int)0, (int)normalInstance.compareTo((Object)deserializedInstance));
    }
}

