/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.embedded;

import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelId;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.CustomChannelId;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannelId;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedEventLoop;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.FutureListener;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.ScheduledFuture;

public class EmbeddedChannelTest {
    @Test
    public void testParent() {
        EmbeddedChannel parent = new EmbeddedChannel();
        EmbeddedChannel channel = new EmbeddedChannel((Channel)parent, EmbeddedChannelId.INSTANCE, true, false, new ChannelHandler[0]);
        Assertions.assertSame((Object)parent, (Object)channel.parent());
        Assertions.assertNull((Object)parent.parent());
        Assertions.assertFalse((boolean)channel.finish());
        Assertions.assertFalse((boolean)parent.finish());
    }

    @Test
    public void testNotRegistered() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(false, false, new ChannelHandler[0]);
        Assertions.assertFalse((boolean)channel.isRegistered());
        channel.register();
        Assertions.assertTrue((boolean)channel.isRegistered());
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testRegistered() throws Exception {
        EmbeddedChannel channel = new EmbeddedChannel(true, false, new ChannelHandler[0]);
        Assertions.assertTrue((boolean)channel.isRegistered());
        try {
            channel.register();
            Assertions.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)channel.finish());
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void promiseDoesNotInfiniteLoop() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                future.channel().close();
            }
        });
        channel.close().syncUninterruptibly();
    }

    @Test
    public void testConstructWithChannelInitializer() {
        final Integer first = 1;
        final Integer second = 2;
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.fireChannelRead((Object)first);
                ctx.fireChannelRead((Object)second);
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInitializer<Channel>((ChannelHandler)handler){
            final /* synthetic */ ChannelHandler val$handler;
            {
                this.val$handler = channelHandler;
            }

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{this.val$handler});
            }
        }});
        ChannelPipeline pipeline = channel.pipeline();
        Assertions.assertSame((Object)handler, (Object)pipeline.firstContext().handler());
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{3}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)first, (Object)channel.readInbound());
        Assertions.assertSame((Object)second, (Object)channel.readInbound());
        Assertions.assertNull((Object)channel.readInbound());
    }

    @Test
    public void testScheduling() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        final CountDownLatch latch = new CountDownLatch(2);
        ScheduledFuture future = ch.eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        }, 1L, TimeUnit.SECONDS);
        future.addListener((GenericFutureListener)new FutureListener(){

            public void operationComplete(Future future) throws Exception {
                latch.countDown();
            }
        });
        long next = ch.runScheduledPendingTasks();
        Assertions.assertTrue((next > 0L ? 1 : 0) != 0);
        Thread.sleep(TimeUnit.NANOSECONDS.toMillis(next) + 50L);
        Assertions.assertEquals((long)-1L, (long)ch.runScheduledPendingTasks());
        latch.await();
    }

    @Test
    public void testScheduledCancelled() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter()});
        ScheduledFuture future = ch.eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
            }
        }, 1L, TimeUnit.DAYS);
        ch.finish();
        Assertions.assertTrue((boolean)future.isCancelled());
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testHandlerAddedExecutedInEventLoop() throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference error = new AtomicReference();
        ChannelHandlerAdapter handler = new ChannelHandlerAdapter(){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                try {
                    Assertions.assertTrue((boolean)ctx.executor().inEventLoop());
                }
                catch (Throwable cause) {
                    error.set(cause);
                }
                finally {
                    latch.countDown();
                }
            }
        };
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{handler});
        Assertions.assertFalse((boolean)channel.finish());
        latch.await();
        Throwable cause = (Throwable)error.get();
        if (cause != null) {
            throw cause;
        }
    }

    @Test
    public void testConstructWithOutHandler() {
        EmbeddedChannel channel = new EmbeddedChannel();
        Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{1}));
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{2}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)1, (Object)channel.readInbound());
        Assertions.assertNull((Object)channel.readInbound());
        Assertions.assertSame((Object)2, (Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testConstructWithChannelId() {
        CustomChannelId channelId = new CustomChannelId(1);
        EmbeddedChannel channel = new EmbeddedChannel((ChannelId)channelId);
        Assertions.assertSame((Object)channelId, (Object)channel.id());
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testFireChannelInactiveAndUnregisteredOnClose() throws InterruptedException {
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.close();
            }
        });
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.close(channel.newPromise());
            }
        });
    }

    @Test
    @Timeout(value=2000L, unit=TimeUnit.MILLISECONDS)
    public void testFireChannelInactiveAndUnregisteredOnDisconnect() throws InterruptedException {
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.disconnect();
            }
        });
        EmbeddedChannelTest.testFireChannelInactiveAndUnregistered(new Action(){

            @Override
            public ChannelFuture doRun(Channel channel) {
                return channel.disconnect(channel.newPromise());
            }
        });
    }

    private static void testFireChannelInactiveAndUnregistered(Action action) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(3);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
                ctx.executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        latch.countDown();
                    }
                });
            }

            public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        action.doRun((Channel)channel).syncUninterruptibly();
        latch.await();
    }

    @Test
    public void testHasDisconnect() {
        EventOutboundHandler handler = new EventOutboundHandler();
        EmbeddedChannel channel = new EmbeddedChannel(true, new ChannelHandler[]{handler});
        Assertions.assertTrue((boolean)channel.disconnect().isSuccess());
        Assertions.assertTrue((boolean)channel.close().isSuccess());
        Assertions.assertEquals((Integer)EventOutboundHandler.DISCONNECT, (Integer)handler.pollEvent());
        Assertions.assertEquals((Integer)EventOutboundHandler.CLOSE, (Integer)handler.pollEvent());
        Assertions.assertNull((Object)handler.pollEvent());
    }

    @Test
    public void testHasNoDisconnect() {
        EventOutboundHandler handler = new EventOutboundHandler();
        EmbeddedChannel channel = new EmbeddedChannel(false, new ChannelHandler[]{handler});
        Assertions.assertTrue((boolean)channel.disconnect().isSuccess());
        Assertions.assertTrue((boolean)channel.close().isSuccess());
        Assertions.assertEquals((Integer)EventOutboundHandler.CLOSE, (Integer)handler.pollEvent());
        Assertions.assertEquals((Integer)EventOutboundHandler.CLOSE, (Integer)handler.pollEvent());
        Assertions.assertNull((Object)handler.pollEvent());
    }

    @Test
    public void testHasNoDisconnectSkipDisconnect() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel(false, new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
                promise.tryFailure(new Throwable());
            }
        }});
        Assertions.assertFalse((boolean)channel.disconnect().isSuccess());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinishAndReleaseAll() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.finishAndReleaseAll());
            Assertions.assertEquals((int)0, (int)in.refCnt());
            Assertions.assertEquals((int)0, (int)out.refCnt());
            Assertions.assertNull((Object)channel.readInbound());
            Assertions.assertNull((Object)channel.readOutbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseInbound() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.releaseInbound());
            Assertions.assertEquals((int)0, (int)in.refCnt());
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.finish());
            Assertions.assertNull((Object)channel.readInbound());
            ByteBuf buffer = (ByteBuf)channel.readOutbound();
            Assertions.assertSame((Object)out, (Object)buffer);
            buffer.release();
            Assertions.assertNull((Object)channel.readOutbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseOutbound() {
        ByteBuf in = Unpooled.buffer();
        ByteBuf out = Unpooled.buffer();
        try {
            EmbeddedChannel channel = new EmbeddedChannel();
            Assertions.assertTrue((boolean)channel.writeInbound(new Object[]{in}));
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{out}));
            Assertions.assertEquals((int)1, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.releaseOutbound());
            Assertions.assertEquals((int)1, (int)in.refCnt());
            Assertions.assertEquals((int)0, (int)out.refCnt());
            Assertions.assertTrue((boolean)channel.finish());
            Assertions.assertNull((Object)channel.readOutbound());
            ByteBuf buffer = (ByteBuf)channel.readInbound();
            Assertions.assertSame((Object)in, (Object)buffer);
            buffer.release();
            Assertions.assertNull((Object)channel.readInbound());
        }
        catch (Throwable throwable) {
            EmbeddedChannelTest.release(in, out);
            throw throwable;
        }
        EmbeddedChannelTest.release(in, out);
    }

    @Test
    public void testWriteLater() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(final ChannelHandlerContext ctx, final Object msg, final ChannelPromise promise) throws Exception {
                ctx.executor().execute(new Runnable(){

                    @Override
                    public void run() {
                        ctx.write(msg, promise);
                    }
                });
            }
        }});
        Object msg = new Object();
        Assertions.assertTrue((boolean)channel.writeOutbound(new Object[]{msg}));
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)msg, (Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testWriteScheduled() throws InterruptedException {
        int delay = 500;
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(final ChannelHandlerContext ctx, final Object msg, final ChannelPromise promise) throws Exception {
                ctx.executor().schedule(new Runnable(){

                    @Override
                    public void run() {
                        ctx.writeAndFlush(msg, promise);
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            }
        }});
        Object msg = new Object();
        Assertions.assertFalse((boolean)channel.writeOutbound(new Object[]{msg}));
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)channel.finish());
        Assertions.assertSame((Object)msg, (Object)channel.readOutbound());
        Assertions.assertNull((Object)channel.readOutbound());
    }

    @Test
    public void testFlushInbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        channel.flushInbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #channelReadComplete() in time.");
        }
    }

    @Test
    public void testWriteOneInbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger flushCount = new AtomicInteger(0);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ReferenceCountUtil.release((Object)msg);
                latch.countDown();
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                flushCount.incrementAndGet();
            }
        }});
        channel.writeOneInbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #channelRead() in time.");
        }
        channel.close().syncUninterruptibly();
        Assertions.assertEquals((int)0, (int)flushCount.get());
    }

    @Test
    public void testFlushOutbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void flush(ChannelHandlerContext ctx) throws Exception {
                latch.countDown();
            }
        }});
        channel.flushOutbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #flush() in time.");
        }
    }

    @Test
    public void testWriteOneOutbound() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger flushCount = new AtomicInteger(0);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                ctx.write(msg, promise);
                latch.countDown();
            }

            public void flush(ChannelHandlerContext ctx) throws Exception {
                flushCount.incrementAndGet();
            }
        }});
        channel.writeOneOutbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #write() in time.");
        }
        channel.close().syncUninterruptibly();
        Assertions.assertEquals((int)0, (int)flushCount.get());
    }

    @Test
    public void testEnsureOpen() throws InterruptedException {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.close().syncUninterruptibly();
        try {
            channel.writeOutbound(new Object[]{"Hello, Netty!"});
            Assertions.fail((String)"This should have failed with a ClosedChannelException");
        }
        catch (Exception expected) {
            Assertions.assertTrue((boolean)(expected instanceof ClosedChannelException));
        }
        try {
            channel.writeInbound(new Object[]{"Hello, Netty!"});
            Assertions.fail((String)"This should have failed with a ClosedChannelException");
        }
        catch (Exception expected) {
            Assertions.assertTrue((boolean)(expected instanceof ClosedChannelException));
        }
    }

    @Test
    public void testHandleInboundMessage() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(){

            protected void handleInboundMessage(Object msg) {
                latch.countDown();
            }
        };
        channel.writeOneInbound((Object)"Hello, Netty!");
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #handleInboundMessage() in time.");
        }
    }

    @Test
    public void testHandleOutboundMessage() throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        EmbeddedChannel channel = new EmbeddedChannel(){

            protected void handleOutboundMessage(Object msg) {
                latch.countDown();
            }
        };
        channel.writeOneOutbound((Object)"Hello, Netty!");
        if (latch.await(50L, TimeUnit.MILLISECONDS)) {
            Assertions.fail((String)"Somebody called unexpectedly #flush()");
        }
        channel.flushOutbound();
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Nobody called #handleOutboundMessage() in time.");
        }
    }

    @Test
    @Timeout(value=5000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelInactiveFired() throws InterruptedException {
        final AtomicBoolean inactive = new AtomicBoolean();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                inactive.set(true);
            }
        }});
        channel.pipeline().fireExceptionCaught((Throwable)new IllegalStateException());
        Assertions.assertTrue((boolean)inactive.get());
    }

    @Test
    public void testReRegisterEventLoop() throws Exception {
        final CountDownLatch unregisteredLatch = new CountDownLatch(1);
        final CountDownLatch registeredLatch = new CountDownLatch(2);
        final EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelUnregistered(ChannelHandlerContext ctx) {
                unregisteredLatch.countDown();
            }

            public void channelRegistered(ChannelHandlerContext ctx) {
                registeredLatch.countDown();
            }
        }});
        final EmbeddedEventLoop embeddedEventLoop = new EmbeddedEventLoop();
        channel.deregister().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                embeddedEventLoop.register((Channel)channel);
            }
        });
        if (!unregisteredLatch.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Channel was not unregistered in time.");
        }
        if (!registeredLatch.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Channel was not registered in time.");
        }
        final CountDownLatch taskLatch = new CountDownLatch(1);
        channel.eventLoop().execute(new Runnable(){

            @Override
            public void run() {
                taskLatch.countDown();
            }
        });
        channel.runPendingTasks();
        if (!taskLatch.await(5L, TimeUnit.SECONDS)) {
            Assertions.fail((String)"Task was not executed in time.");
        }
    }

    @Test
    void testRunPendingTasksForNotRegisteredChannel() {
        EmbeddedChannel channel = new EmbeddedChannel(false, false, new ChannelHandler[0]);
        long nextScheduledTaskTime = 0L;
        try {
            nextScheduledTaskTime = channel.runScheduledPendingTasks();
            channel.checkException();
        }
        catch (Throwable t) {
            Assertions.fail((String)"Channel should not throw an exception for scheduled pending tasks if it is not registered", (Throwable)t);
        }
        Assertions.assertEquals((long)-1L, (long)nextScheduledTaskTime);
        try {
            channel.runPendingTasks();
            channel.checkException();
        }
        catch (Throwable t) {
            Assertions.fail((String)"Channel should not throw an exception for pending tasks if it is not registered", (Throwable)t);
        }
    }

    @Test
    @Timeout(value=30L)
    void testAdvanceTime() {
        EmbeddedChannel channel = new EmbeddedChannel();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        ScheduledFuture future10 = channel.eventLoop().schedule(runnable, 10L, TimeUnit.MINUTES);
        ScheduledFuture future20 = channel.eventLoop().schedule(runnable, 20L, TimeUnit.MINUTES);
        channel.runPendingTasks();
        Assertions.assertFalse((boolean)future10.isDone());
        Assertions.assertFalse((boolean)future20.isDone());
        channel.advanceTimeBy(10L, TimeUnit.MINUTES);
        channel.runPendingTasks();
        Assertions.assertTrue((boolean)future10.isDone());
        Assertions.assertFalse((boolean)future20.isDone());
    }

    @Test
    @Timeout(value=30L)
    void testFreezeTime() {
        EmbeddedChannel channel = new EmbeddedChannel();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        channel.freezeTime();
        ScheduledFuture future10 = channel.eventLoop().schedule(runnable, 10L, TimeUnit.MINUTES);
        ScheduledFuture future101 = channel.eventLoop().schedule(runnable, TimeUnit.MINUTES.toNanos(10L) + 1L, TimeUnit.NANOSECONDS);
        ScheduledFuture future20 = channel.eventLoop().schedule(runnable, 20L, TimeUnit.MINUTES);
        channel.runPendingTasks();
        Assertions.assertFalse((boolean)future10.isDone());
        Assertions.assertFalse((boolean)future101.isDone());
        Assertions.assertFalse((boolean)future20.isDone());
        channel.advanceTimeBy(10L, TimeUnit.MINUTES);
        channel.runPendingTasks();
        Assertions.assertTrue((boolean)future10.isDone());
        Assertions.assertFalse((boolean)future101.isDone());
        Assertions.assertFalse((boolean)future20.isDone());
        channel.unfreezeTime();
        channel.runPendingTasks();
        Assertions.assertTrue((boolean)future101.isDone());
        Assertions.assertFalse((boolean)future20.isDone());
    }

    @Test
    void testHasPendingTasks() {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.freezeTime();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
            }
        };
        Assertions.assertFalse((boolean)channel.hasPendingTasks());
        channel.eventLoop().execute(runnable);
        Assertions.assertTrue((boolean)channel.hasPendingTasks());
        channel.runPendingTasks();
        Assertions.assertFalse((boolean)channel.hasPendingTasks());
        channel.eventLoop().schedule(runnable, 1L, TimeUnit.SECONDS);
        Assertions.assertFalse((boolean)channel.hasPendingTasks());
        channel.runPendingTasks();
        Assertions.assertFalse((boolean)channel.hasPendingTasks());
        channel.advanceTimeBy(1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)channel.hasPendingTasks());
        channel.runPendingTasks();
        Assertions.assertFalse((boolean)channel.hasPendingTasks());
    }

    @Test
    void testReentrantClose() {
        EmbeddedChannel channel = new EmbeddedChannel();
        channel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
            boolean runningRead;

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                this.runningRead = true;
                try {
                    ctx.channel().close();
                }
                finally {
                    this.runningRead = false;
                }
            }

            public void handlerRemoved(ChannelHandlerContext ctx) {
                if (this.runningRead) {
                    throw new IllegalStateException("Reentrant handlerRemoved");
                }
            }
        }});
        channel.writeInbound(new Object[]{"foo"});
        channel.checkException();
    }

    private static void release(ByteBuf ... buffers) {
        for (ByteBuf buffer : buffers) {
            if (buffer.refCnt() <= 0) continue;
            buffer.release();
        }
    }

    private static final class EventOutboundHandler
    extends ChannelOutboundHandlerAdapter {
        static final Integer DISCONNECT = 0;
        static final Integer CLOSE = 1;
        private final Queue<Integer> queue = new ArrayDeque<Integer>();

        private EventOutboundHandler() {
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.queue.add(DISCONNECT);
            promise.setSuccess();
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            this.queue.add(CLOSE);
            promise.setSuccess();
        }

        Integer pollEvent() {
            return this.queue.poll();
        }
    }

    private static interface Action {
        public ChannelFuture doRun(Channel var1);
    }
}

