/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio;

import java.io.File;
import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.AbstractNioDomainChannelTest;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioDomainSocketUtil;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerDomainSocketChannel;

@EnabledForJreRange(min=JRE.JAVA_16)
public class NioServerDomainSocketChannelTest
extends AbstractNioDomainChannelTest<NioServerDomainSocketChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseOnError() throws Exception {
        ServerSocketChannel jdkChannel = NioServerDomainSocketChannel.newChannel((SelectorProvider)SelectorProvider.provider());
        NioServerDomainSocketChannel serverSocketChannel = new NioServerDomainSocketChannel(jdkChannel);
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        File file = NioServerDomainSocketChannelTest.newRandomTmpFile();
        try {
            group.register((Channel)serverSocketChannel).syncUninterruptibly();
            serverSocketChannel.bind(NioDomainSocketUtil.newUnixDomainSocketAddress((String)file.getAbsolutePath())).syncUninterruptibly();
            Assertions.assertFalse((boolean)serverSocketChannel.closeOnReadError((Throwable)new IOException()));
            serverSocketChannel.close().syncUninterruptibly();
        }
        finally {
            group.shutdownGracefully();
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIsActiveFalseAfterClose() throws Exception {
        NioServerDomainSocketChannel serverSocketChannel = new NioServerDomainSocketChannel();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        File file = NioServerDomainSocketChannelTest.newRandomTmpFile();
        try {
            group.register((Channel)serverSocketChannel).syncUninterruptibly();
            Channel channel = serverSocketChannel.bind(NioDomainSocketUtil.newUnixDomainSocketAddress((String)file.getAbsolutePath())).syncUninterruptibly().channel();
            Assertions.assertTrue((boolean)channel.isActive());
            Assertions.assertTrue((boolean)channel.isOpen());
            channel.close().syncUninterruptibly();
            Assertions.assertFalse((boolean)channel.isOpen());
            Assertions.assertFalse((boolean)channel.isActive());
        }
        finally {
            group.shutdownGracefully();
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @ValueSource(booleans={false, true})
    public void testCreateChannelFromJdkChannel(boolean bindJdkChannel) throws Exception {
        File file = NioServerDomainSocketChannelTest.newRandomTmpFile();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            SocketAddress localAddress = NioDomainSocketUtil.newUnixDomainSocketAddress((String)file.getAbsolutePath());
            ServerSocketChannel jdkChannel = NioServerDomainSocketChannel.newChannel((SelectorProvider)SelectorProvider.provider());
            if (bindJdkChannel) {
                jdkChannel.bind(localAddress);
            }
            NioServerDomainSocketChannel serverSocketChannel = new NioServerDomainSocketChannel(jdkChannel);
            group.register((Channel)serverSocketChannel).syncUninterruptibly();
            Assertions.assertTrue((boolean)serverSocketChannel.isOpen());
            Assertions.assertEquals((Object)bindJdkChannel, (Object)serverSocketChannel.isActive());
            serverSocketChannel.close().syncUninterruptibly();
            Assertions.assertFalse((boolean)serverSocketChannel.isOpen());
            Assertions.assertFalse((boolean)serverSocketChannel.isActive());
        }
        finally {
            group.shutdownGracefully();
            file.delete();
        }
    }

    @Override
    protected NioServerDomainSocketChannel newNioChannel() {
        return new NioServerDomainSocketChannel();
    }

    @Override
    protected NetworkChannel jdkChannel(NioServerDomainSocketChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.IP_MULTICAST_IF;
    }

    private static File newRandomTmpFile() {
        return new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
    }
}

