/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NetworkChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoop;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.SocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.AbstractNioChannelTest;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.NetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public class NioSocketChannelTest
extends AbstractNioChannelTest<NioSocketChannel> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushCloseReentrance() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            final LinkedBlockingQueue futures = new LinkedBlockingQueue();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group).channel(NioServerSocketChannel.class);
            sb.childOption(ChannelOption.SO_SNDBUF, (Object)1024);
            sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    futures.add(ctx.write((Object)ctx.alloc().buffer().writeZero(0x100000)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE));
                    futures.add(ctx.write((Object)ctx.alloc().buffer().writeZero(0x100000)));
                    ctx.flush();
                    futures.add(ctx.write((Object)ctx.alloc().buffer().writeZero(0x100000)));
                    ctx.flush();
                }
            });
            SocketAddress address = sb.bind(0).sync().channel().localAddress();
            Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)address).getPort());
            InputStream in = s.getInputStream();
            byte[] buf = new byte[8192];
            while (in.read(buf) != -1) {
                Thread.sleep(10L);
            }
            s.close();
            MatcherAssert.assertThat((Object)futures.size(), (Matcher)CoreMatchers.is((Object)3));
            ChannelFuture f1 = (ChannelFuture)futures.poll();
            ChannelFuture f2 = (ChannelFuture)futures.poll();
            ChannelFuture f3 = (ChannelFuture)futures.poll();
            MatcherAssert.assertThat((Object)f1.isSuccess(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f2.isDone(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f2.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)f2.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            MatcherAssert.assertThat((Object)f3.isDone(), (Matcher)CoreMatchers.is((Object)true));
            MatcherAssert.assertThat((Object)f3.isSuccess(), (Matcher)CoreMatchers.is((Object)false));
            MatcherAssert.assertThat((Object)f3.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAfterGatheredFlush() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)group).channel(NioServerSocketChannel.class);
            sb.childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void channelActive(final ChannelHandlerContext ctx) throws Exception {
                    ctx.write((Object)Unpooled.wrappedBuffer((byte[])new byte[]{97}));
                    ChannelFuture f = ctx.write((Object)Unpooled.wrappedBuffer((byte[])new byte[]{98}));
                    f.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{99}));
                        }
                    });
                    ctx.flush();
                }
            });
            SocketAddress address = sb.bind(0).sync().channel().localAddress();
            Socket s = new Socket(NetUtil.LOCALHOST, ((InetSocketAddress)address).getPort());
            DataInputStream in = new DataInputStream(s.getInputStream());
            byte[] buf = new byte[3];
            in.readFully(buf);
            MatcherAssert.assertThat((Object)new String(buf, CharsetUtil.US_ASCII), (Matcher)CoreMatchers.is((Object)"abc"));
            s.close();
        }
        finally {
            group.shutdownGracefully().sync();
        }
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelReRegisterReadSameEventLoop() throws Exception {
        NioSocketChannelTest.testChannelReRegisterRead(true);
    }

    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testChannelReRegisterReadDifferentEventLoop() throws Exception {
        NioSocketChannelTest.testChannelReRegisterRead(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testChannelReRegisterRead(boolean sameEventLoop) throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup(2);
        final CountDownLatch latch = new CountDownLatch(1);
        byte[] bytes = new byte[1024];
        PlatformDependent.threadLocalRandom().nextBytes(bytes);
        Channel sc = null;
        Channel cc = null;
        ServerBootstrap b = new ServerBootstrap();
        try {
            ((ServerBootstrap)b.group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<Channel>((EventLoopGroup)group, sameEventLoop){
                final /* synthetic */ EventLoopGroup val$group;
                final /* synthetic */ boolean val$sameEventLoop;
                {
                    this.val$group = eventLoopGroup;
                    this.val$sameEventLoop = bl;
                }

                protected void initChannel(Channel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){

                        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf byteBuf) {
                            latch.countDown();
                        }

                        public void channelActive(final ChannelHandlerContext ctx) throws Exception {
                            final EventLoop loop = val$group.next();
                            if (val$sameEventLoop) {
                                this.deregister(ctx, loop);
                            } else {
                                loop.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        this.deregister(ctx, loop);
                                    }
                                });
                            }
                        }

                        private void deregister(ChannelHandlerContext ctx, final EventLoop loop) {
                            ctx.deregister().addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture cf) {
                                    Channel channel = cf.channel();
                                    Assertions.assertNotSame((Object)loop, (Object)channel.eventLoop());
                                    val$group.next().register(channel);
                                }
                            });
                        }
                    }});
                }
            });
            sc = b.bind(0).syncUninterruptibly().channel();
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)bootstrap.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
            bootstrap.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            cc = bootstrap.connect(sc.localAddress()).syncUninterruptibly().channel();
            cc.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])bytes)).syncUninterruptibly();
            latch.await();
        }
        finally {
            if (cc != null) {
                cc.close();
            }
            if (sc != null) {
                sc.close();
            }
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=3000L, unit=TimeUnit.MILLISECONDS)
    public void testShutdownOutputAndClose() throws IOException {
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        ServerSocket socket = new ServerSocket();
        socket.bind(new InetSocketAddress(0));
        Socket accepted = null;
        try {
            Bootstrap sb = new Bootstrap();
            ((Bootstrap)sb.group((EventLoopGroup)group)).channel(NioSocketChannel.class);
            sb.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            SocketChannel channel = (SocketChannel)sb.connect(socket.getLocalSocketAddress()).syncUninterruptibly().channel();
            accepted = socket.accept();
            channel.shutdownOutput().syncUninterruptibly();
            channel.close().syncUninterruptibly();
        }
        finally {
            if (accepted != null) {
                try {
                    accepted.close();
                }
                catch (IOException iOException) {}
            }
            try {
                socket.close();
            }
            catch (IOException iOException) {}
            group.shutdownGracefully();
        }
    }

    @Override
    protected NioSocketChannel newNioChannel() {
        return new NioSocketChannel();
    }

    @Override
    protected NetworkChannel jdkChannel(NioSocketChannel channel) {
        return channel.javaChannel();
    }

    @Override
    protected SocketOption<?> newInvalidOption() {
        return StandardSocketOptions.IP_MULTICAST_IF;
    }
}

