/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.address;

import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.address.ResolveAddressHandler;
import org.neo4j.driver.internal.shaded.io.netty.resolver.AbstractAddressResolver;
import org.neo4j.driver.internal.shaded.io.netty.resolver.AddressResolver;
import org.neo4j.driver.internal.shaded.io.netty.resolver.AddressResolverGroup;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutor;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;

public class ResolveAddressHandlerTest {
    private static final LocalAddress UNRESOLVED = new LocalAddress("unresolved-" + UUID.randomUUID());
    private static final LocalAddress RESOLVED = new LocalAddress("resolved-" + UUID.randomUUID());
    private static final Exception ERROR = new UnknownHostException();
    private static EventLoopGroup group;

    @BeforeAll
    public static void createEventLoop() {
        group = new DefaultEventLoopGroup();
    }

    @AfterAll
    public static void destroyEventLoop() {
        if (group != null) {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testResolveSuccessful() {
        ResolveAddressHandlerTest.testResolve(false);
    }

    @Test
    public void testResolveFails() {
        ResolveAddressHandlerTest.testResolve(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testResolve(boolean fail) {
        TestResolverGroup resolverGroup = new TestResolverGroup(fail);
        Bootstrap cb = new Bootstrap();
        ((Bootstrap)((Bootstrap)cb.group(group)).channel(LocalChannel.class)).handler((ChannelHandler)new ResolveAddressHandler((AddressResolverGroup)resolverGroup));
        ServerBootstrap sb = new ServerBootstrap();
        ((ServerBootstrap)sb.group(group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.close();
            }
        });
        Channel sc = sb.bind((SocketAddress)RESOLVED).syncUninterruptibly().channel();
        ChannelFuture future = cb.connect((SocketAddress)UNRESOLVED).awaitUninterruptibly();
        try {
            if (fail) {
                Assertions.assertSame((Object)ERROR, (Object)future.cause());
            } else {
                Assertions.assertTrue((boolean)future.isSuccess());
            }
            future.channel().close().syncUninterruptibly();
        }
        finally {
            future.channel().close().syncUninterruptibly();
            sc.close().syncUninterruptibly();
            resolverGroup.close();
        }
    }

    private static final class TestResolverGroup
    extends AddressResolverGroup<SocketAddress> {
        private final boolean fail;

        TestResolverGroup(boolean fail) {
            this.fail = fail;
        }

        protected AddressResolver<SocketAddress> newResolver(EventExecutor executor) {
            return new AbstractAddressResolver<SocketAddress>(executor){

                protected boolean doIsResolved(SocketAddress address) {
                    return address == RESOLVED;
                }

                protected void doResolve(SocketAddress unresolvedAddress, Promise<SocketAddress> promise) {
                    Assertions.assertSame((Object)UNRESOLVED, (Object)unresolvedAddress);
                    if (TestResolverGroup.this.fail) {
                        promise.setFailure((Throwable)ERROR);
                    } else {
                        promise.setSuccess((Object)RESOLVED);
                    }
                }

                protected void doResolveAll(SocketAddress unresolvedAddress, Promise<List<SocketAddress>> promise) {
                    Assertions.fail();
                }
            };
        }
    }
}

