/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.ByteToMessageCodec;

public class ByteToMessageCodecTest {
    @Test
    public void testSharable() {
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                new InvalidByteToMessageCodec();
            }
        });
    }

    @Test
    public void testSharable2() {
        Assertions.assertThrows(IllegalStateException.class, (Executable)new Executable(){

            public void execute() {
                new InvalidByteToMessageCodec2();
            }
        });
    }

    @Test
    public void testForwardPendingData() {
        ByteToMessageCodec<Integer> codec = new ByteToMessageCodec<Integer>(){

            protected void encode(ChannelHandlerContext ctx, Integer msg, ByteBuf out) {
                out.writeInt(msg.intValue());
            }

            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
                if (in.readableBytes() >= 4) {
                    out.add(in.readInt());
                }
            }
        };
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeInt(1);
        buffer.writeByte(48);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{codec});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{buffer}));
        ch.pipeline().remove((ChannelHandler)codec);
        Assertions.assertTrue((boolean)ch.finish());
        Assertions.assertEquals((int)1, (Integer)((Integer)ch.readInbound()));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])new byte[]{48}), (Object)buf);
        buf.release();
        Assertions.assertNull((Object)ch.readInbound());
        Assertions.assertNull((Object)ch.readOutbound());
    }

    @ChannelHandler.Sharable
    private static final class InvalidByteToMessageCodec2
    extends ByteToMessageCodec<Integer> {
        InvalidByteToMessageCodec2() {
            super(Integer.class, true);
        }

        protected void encode(ChannelHandlerContext ctx, Integer msg, ByteBuf out) throws Exception {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        }
    }

    @ChannelHandler.Sharable
    private static final class InvalidByteToMessageCodec
    extends ByteToMessageCodec<Integer> {
        InvalidByteToMessageCodec() {
            super(true);
        }

        protected void encode(ChannelHandlerContext ctx, Integer msg, ByteBuf out) throws Exception {
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        }
    }
}

