/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec;

import java.nio.charset.Charset;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.LineBasedFrameDecoder;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.TooLongFrameException;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class LineBasedFrameDecoderTest {
    @Test
    public void testDecodeWithStrip() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, true, false)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"first\r\nsecond\nthird", (Charset)CharsetUtil.US_ASCII)});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"first", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"second", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        ReferenceCountUtil.release((Object)ch.readInbound());
        buf.release();
        buf2.release();
    }

    @Test
    public void testDecodeWithoutStrip() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, false, false)});
        ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"first\r\nsecond\nthird", (Charset)CharsetUtil.US_ASCII)});
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"first\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"second\n", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assertions.assertNull((Object)ch.readInbound());
        ch.finish();
        ReferenceCountUtil.release((Object)ch.readInbound());
        buf.release();
        buf2.release();
    }

    @Test
    public void testTooLongLine1() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(16, false, false)});
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"12345678901234567890\r\nfirst\nsecond", (Charset)CharsetUtil.US_ASCII)});
            Assertions.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TooLongFrameException.class)));
        }
        ByteBuf buf = (ByteBuf)ch.readInbound();
        ByteBuf buf2 = Unpooled.copiedBuffer((CharSequence)"first\n", (Charset)CharsetUtil.US_ASCII);
        MatcherAssert.assertThat((Object)buf, (Matcher)CoreMatchers.is((Object)buf2));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        buf.release();
        buf2.release();
    }

    @Test
    public void testTooLongLine2() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(16, false, false)});
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"12345678901234567", (Charset)CharsetUtil.US_ASCII)}));
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"890\r\nfirst\r\n", (Charset)CharsetUtil.US_ASCII)});
            Assertions.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TooLongFrameException.class)));
        }
        ByteBuf buf = (ByteBuf)ch.readInbound();
        ByteBuf buf2 = Unpooled.copiedBuffer((CharSequence)"first\r\n", (Charset)CharsetUtil.US_ASCII);
        MatcherAssert.assertThat((Object)buf, (Matcher)CoreMatchers.is((Object)buf2));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        buf.release();
        buf2.release();
    }

    @Test
    public void testTooLongLineWithFailFast() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(16, false, true)});
        try {
            ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"12345678901234567", (Charset)CharsetUtil.US_ASCII)});
            Assertions.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(TooLongFrameException.class)));
        }
        MatcherAssert.assertThat((Object)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"890", (Charset)CharsetUtil.US_ASCII)}), (Matcher)CoreMatchers.is((Object)false));
        MatcherAssert.assertThat((Object)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"123\r\nfirst\r\n", (Charset)CharsetUtil.US_ASCII)}), (Matcher)CoreMatchers.is((Object)true));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        ByteBuf buf2 = Unpooled.copiedBuffer((CharSequence)"first\r\n", (Charset)CharsetUtil.US_ASCII);
        MatcherAssert.assertThat((Object)buf, (Matcher)CoreMatchers.is((Object)buf2));
        MatcherAssert.assertThat((Object)ch.finish(), (Matcher)CoreMatchers.is((Object)false));
        buf.release();
        buf2.release();
    }

    @Test
    public void testDecodeSplitsCorrectly() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, false, false)});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"line\r\n.\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"line\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)".\r\n", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assertions.assertFalse((boolean)ch.finishAndReleaseAll());
        buf.release();
        buf2.release();
    }

    @Test
    public void testFragmentedDecode() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, false, false)});
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"huu", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertNull((Object)ch.readInbound());
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"haa\r", (Charset)CharsetUtil.US_ASCII)}));
        Assertions.assertNull((Object)ch.readInbound());
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\nhuuhaa\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"huuhaa\r\n", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"huuhaa\r\n", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assertions.assertFalse((boolean)ch.finishAndReleaseAll());
        buf.release();
        buf2.release();
    }

    @Test
    public void testEmptyLine() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(8192, true, false)});
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.copiedBuffer((CharSequence)"\nabcna\r\n", (Charset)CharsetUtil.US_ASCII)}));
        ByteBuf buf = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"", (Object)buf.toString(CharsetUtil.US_ASCII));
        ByteBuf buf2 = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)"abcna", (Object)buf2.toString(CharsetUtil.US_ASCII));
        Assertions.assertFalse((boolean)ch.finishAndReleaseAll());
        buf.release();
        buf2.release();
    }

    @Test
    public void testNotFailFast() throws Exception {
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new LineBasedFrameDecoder(2, false, false)});
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0, 1, 2})}));
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{3, 4})}));
        try {
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{10})});
            Assertions.fail();
        }
        catch (TooLongFrameException tooLongFrameException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{53})}));
        Assertions.assertTrue((boolean)ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{10})}));
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{53, 10});
        ByteBuf buffer = (ByteBuf)ch.readInbound();
        Assertions.assertEquals((Object)expected, (Object)buffer);
        expected.release();
        buffer.release();
        Assertions.assertFalse((boolean)ch.finish());
    }
}

