/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.bytes;

import java.util.Random;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.bytes.ByteArrayDecoder;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.EmptyArrays;

public class ByteArrayDecoderTest {
    private EmbeddedChannel ch;

    @BeforeEach
    public void setUp() {
        this.ch = new EmbeddedChannel(new ChannelHandler[]{new ByteArrayDecoder()});
    }

    @Test
    public void testDecode() {
        byte[] b = new byte[2048];
        new Random().nextBytes(b);
        this.ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])b)});
        MatcherAssert.assertThat((Object)((byte[])this.ch.readInbound()), (Matcher)Is.is((Object)b));
    }

    @Test
    public void testDecodeEmpty() {
        this.ch.writeInbound(new Object[]{Unpooled.EMPTY_BUFFER});
        MatcherAssert.assertThat((Object)((byte[])this.ch.readInbound()), (Matcher)Is.is((Object)EmptyArrays.EMPTY_BYTES));
    }

    @Test
    public void testDecodeOtherType() {
        String str = "Meep!";
        this.ch.writeInbound(new Object[]{str});
        MatcherAssert.assertThat((Object)this.ch.readInbound(), (Matcher)Is.is((Object)str));
    }
}

