/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import java.io.InputStream;
import java.util.ArrayList;
import lzma.sdk.lzma.Decoder;
import lzma.streams.LzmaInputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufInputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.CompositeByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.AbstractEncoderTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.LzmaFrameEncoder;

public class LzmaFrameEncoderTest
extends AbstractEncoderTest {
    @Override
    protected EmbeddedChannel createChannel() {
        return new EmbeddedChannel(new ChannelHandler[]{new LzmaFrameEncoder()});
    }

    @Override
    @ParameterizedTest
    @MethodSource(value={"smallData"})
    public void testCompressionOfBatchedFlowOfData(ByteBuf data) throws Exception {
        this.testCompressionOfBatchedFlow(data);
    }

    @Override
    protected void testCompressionOfBatchedFlow(ByteBuf data) throws Exception {
        ByteBuf msg;
        ByteBuf in;
        ArrayList<Integer> originalLengths = new ArrayList<Integer>();
        int dataLength = data.readableBytes();
        int written = 0;
        int length = rand.nextInt(50);
        while (written + length < dataLength) {
            in = data.retainedSlice(written, length);
            Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
            written += length;
            originalLengths.add(length);
            length = rand.nextInt(50);
        }
        length = dataLength - written;
        in = data.retainedSlice(written, dataLength - written);
        originalLengths.add(length);
        Assertions.assertTrue((boolean)this.channel.writeOutbound(new Object[]{in}));
        Assertions.assertTrue((boolean)this.channel.finish());
        CompositeByteBuf decompressed = Unpooled.compositeBuffer();
        int i = 0;
        while ((msg = (ByteBuf)this.channel.readOutbound()) != null) {
            ByteBuf decompressedMsg = this.decompress(msg, (Integer)originalLengths.get(i++));
            decompressed.addComponent(true, decompressedMsg);
        }
        Assertions.assertEquals((int)originalLengths.size(), (int)i);
        Assertions.assertEquals((Object)data, (Object)decompressed);
        decompressed.release();
        data.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ByteBuf decompress(ByteBuf compressed, int originalLength) throws Exception {
        ByteBufInputStream is = new ByteBufInputStream(compressed, true);
        LzmaInputStream lzmaIs = null;
        byte[] decompressed = new byte[originalLength];
        try {
            int read;
            lzmaIs = new LzmaInputStream((InputStream)is, new Decoder());
            for (int remaining = originalLength; remaining > 0 && (read = lzmaIs.read(decompressed, originalLength - remaining, remaining)) > 0; remaining -= read) {
            }
            Assertions.assertEquals((int)-1, (int)lzmaIs.read());
        }
        finally {
            if (lzmaIs != null) {
                lzmaIs.close();
            }
            if (is != null) {
                is.close();
            }
        }
        return Unpooled.wrappedBuffer((byte[])decompressed);
    }
}

