/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression;

import java.nio.CharBuffer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.DecompressionException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.compression.Snappy;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

public class SnappyTest {
    private final Snappy snappy = new Snappy();

    @AfterEach
    public void resetSnappy() {
        this.snappy.reset();
    }

    @Test
    public void testDecodeLiteral() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{5, 16, 110, 101, 116, 116, 121});
        ByteBuf out = Unpooled.buffer((int)5);
        this.snappy.decode(in, out);
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        Assertions.assertEquals((Object)expected, (Object)out, (String)"Literal was not decoded correctly");
        in.release();
        out.release();
        expected.release();
    }

    @Test
    public void testDecodeCopyWith1ByteOffset() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{10, 16, 110, 101, 116, 116, 121, 5, 5});
        ByteBuf out = Unpooled.buffer((int)10);
        this.snappy.decode(in, out);
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121, 110, 101, 116, 116, 121});
        Assertions.assertEquals((Object)expected, (Object)out, (String)"Copy was not decoded correctly");
        in.release();
        out.release();
        expected.release();
    }

    @Test
    public void testDecodeCopyWithTinyOffset() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{11, 16, 110, 101, 116, 116, 121, 21, 0});
        final ByteBuf out = Unpooled.buffer((int)10);
        try {
            Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

                public void execute() {
                    SnappyTest.this.snappy.decode(in, out);
                }
            });
        }
        finally {
            in.release();
            out.release();
        }
    }

    @Test
    public void testDecodeCopyWithOffsetBeforeChunk() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{10, 16, 110, 101, 116, 116, 121, 21, 11});
        final ByteBuf out = Unpooled.buffer((int)10);
        try {
            Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

                public void execute() {
                    SnappyTest.this.snappy.decode(in, out);
                }
            });
        }
        finally {
            in.release();
            out.release();
        }
    }

    @Test
    public void testDecodeWithOverlyLongPreamble() {
        final ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{-128, -128, -128, -128, 127, 16, 110, 101, 116, 116, 121});
        final ByteBuf out = Unpooled.buffer((int)10);
        try {
            Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

                public void execute() {
                    SnappyTest.this.snappy.decode(in, out);
                }
            });
        }
        finally {
            in.release();
            out.release();
        }
    }

    @Test
    public void encodeShortTextIsLiteral() throws Exception {
        ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        ByteBuf out = Unpooled.buffer((int)7);
        this.snappy.encode(in, out, 5);
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{5, 16, 110, 101, 116, 116, 121});
        Assertions.assertEquals((Object)expected, (Object)out, (String)"Encoded literal was invalid");
        in.release();
        out.release();
        expected.release();
    }

    @Test
    public void encodeAndDecodeLongTextUsesCopy() throws Exception {
        String srcStr = "Netty has been designed carefully with the experiences earned from the implementation of a lot of protocols such as FTP, SMTP, HTTP, and various binary and text-based legacy protocols";
        ByteBuf in = Unpooled.wrappedBuffer((byte[])srcStr.getBytes("US-ASCII"));
        ByteBuf out = Unpooled.buffer((int)180);
        this.snappy.encode(in, out, in.readableBytes());
        ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[]{-73, 1, -16, 66, 78, 101, 116, 116, 121, 32, 104, 97, 115, 32, 98, 101, 101, 110, 32, 100, 101, 115, 105, 103, 110, 101, 100, 32, 99, 97, 114, 101, 102, 117, 108, 108, 121, 32, 119, 105, 116, 104, 32, 116, 104, 101, 32, 101, 120, 112, 101, 114, 105, 101, 110, 99, 101, 115, 32, 101, 97, 114, 110, 101, 100, 32, 102, 114, 111, 109, 32, 1, 28, 88, 105, 109, 112, 108, 101, 109, 101, 110, 116, 97, 116, 105, 111, 110, 32, 111, 102, 32, 97, 32, 108, 111, 116, 1, 9, 96, 112, 114, 111, 116, 111, 99, 111, 108, 115, 32, 115, 117, 99, 104, 32, 97, 115, 32, 70, 84, 80, 44, 32, 83, 77, 1, 6, 4, 72, 84, 1, 6, 68, 97, 110, 100, 32, 118, 97, 114, 105, 111, 117, 115, 32, 98, 105, 110, 97, 114, 121, 5, 19, 72, 116, 101, 120, 116, 45, 98, 97, 115, 101, 100, 32, 108, 101, 103, 97, 99, 121, 32, 112, 17, 76});
        Assertions.assertEquals((Object)expected, (Object)out, (String)"Encoded result was incorrect");
        ByteBuf outDecoded = Unpooled.buffer();
        this.snappy.decode(out, outDecoded);
        Assertions.assertEquals((Object)CharBuffer.wrap(srcStr), (Object)CharBuffer.wrap(outDecoded.getCharSequence(0, outDecoded.writerIndex(), CharsetUtil.US_ASCII)));
        in.release();
        out.release();
        outDecoded.release();
    }

    @Test
    public void testCalculateChecksum() {
        ByteBuf input = Unpooled.wrappedBuffer((byte[])new byte[]{110, 101, 116, 116, 121});
        Assertions.assertEquals((int)Snappy.maskChecksum((long)3603663701L), (int)Snappy.calculateChecksum((ByteBuf)input));
        input.release();
    }

    @Test
    public void testMaskChecksum() {
        ByteBuf input = Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 15, 0, 0, 0, 0, 95, 104, 101, 97, 114, 116, 98, 101, 97, 116, 95});
        Assertions.assertEquals((int)1151610911, (int)Snappy.calculateChecksum((ByteBuf)input));
        input.release();
    }

    @Test
    public void testValidateChecksumMatches() {
        ByteBuf input = Unpooled.wrappedBuffer((byte[])new byte[]{121, 116, 116, 101, 110});
        Snappy.validateChecksum((int)Snappy.maskChecksum((long)760034613L), (ByteBuf)input);
        input.release();
    }

    @Test
    public void testValidateChecksumFails() {
        final ByteBuf input = Unpooled.wrappedBuffer((byte[])new byte[]{121, 116, 116, 101, 110});
        try {
            Assertions.assertThrows(DecompressionException.class, (Executable)new Executable(){

                public void execute() {
                    Snappy.validateChecksum((int)Snappy.maskChecksum((long)-691303595L), (ByteBuf)input);
                }
            });
        }
        finally {
            input.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEncodeLiteralAndDecodeLiteral() {
        int[] lengths;
        for (int len : lengths = new int[]{17, 256, 4096, 0x100000, 0x1000001}) {
            ByteBuf in = Unpooled.wrappedBuffer((byte[])new byte[len]);
            ByteBuf encoded = Unpooled.buffer((int)10);
            ByteBuf decoded = Unpooled.buffer((int)10);
            ByteBuf expected = Unpooled.wrappedBuffer((byte[])new byte[len]);
            try {
                Snappy.encodeLiteral((ByteBuf)in, (ByteBuf)encoded, (int)len);
                byte tag = encoded.readByte();
                Snappy.decodeLiteral((byte)tag, (ByteBuf)encoded, (ByteBuf)decoded);
                Assertions.assertEquals((Object)expected, (Object)decoded, (String)"Encoded or decoded literal was incorrect");
            }
            finally {
                in.release();
                encoded.release();
                decoded.release();
                expected.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLarge2ByteLiteralLengthAndCopyOffset() {
        ByteBuf compressed = Unpooled.buffer();
        ByteBuf actualDecompressed = Unpooled.buffer();
        ByteBuf expectedDecompressed = Unpooled.buffer().writeByte(1).writeZero(32768).writeByte(1);
        try {
            compressed.writeByte(130).writeByte(128).writeByte(2);
            compressed.writeByte(244);
            compressed.writeShortLE(32768);
            compressed.writeByte(1).writeZero(32768);
            compressed.writeByte(2);
            compressed.writeShortLE(32769);
            this.snappy.decode(compressed, actualDecompressed);
            Assertions.assertEquals((Object)expectedDecompressed, (Object)actualDecompressed);
        }
        finally {
            compressed.release();
            actualDecompressed.release();
            expectedDecompressed.release();
        }
    }
}

