/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.codec.marshalling;

import java.io.IOException;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.marshalling.MarshallingConfiguration;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.neo4j.driver.internal.shaded.io.netty.util.internal.PlatformDependent;

public abstract class AbstractMarshallingTest {
    static final String SERIAL_FACTORY = "serial";
    static final String RIVER_FACTORY = "river";

    @BeforeAll
    public static void checkSupported() throws Throwable {
        Throwable error = null;
        try {
            AbstractMarshallingTest.checkFactorySupported(Marshalling.getProvidedMarshallerFactory((String)SERIAL_FACTORY));
            AbstractMarshallingTest.checkFactorySupported(Marshalling.getProvidedMarshallerFactory((String)RIVER_FACTORY));
        }
        catch (Throwable cause) {
            if (PlatformDependent.javaVersion() < 9) {
                throw cause;
            }
            error = cause;
        }
        Assumptions.assumeTrue((error == null ? 1 : 0) != 0, (String)(error + " was not null"));
    }

    private static void checkFactorySupported(MarshallerFactory factory) throws IOException {
        factory.createMarshaller(new MarshallingConfiguration()).close();
        factory.createUnmarshaller(new MarshallingConfiguration()).close();
    }
}

