/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.pcap;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufOutputStream;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelFuture;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelId;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOption;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultChannelId;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.embedded.EmbeddedChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.DatagramChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.DatagramChannelConfig;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.DatagramPacket;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.DefaultDatagramChannelConfig;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.SocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.pcap.CloseDetectingByteBufOutputStream;
import org.neo4j.driver.internal.shaded.io.netty.handler.pcap.DiscardingStatsOutputStream;
import org.neo4j.driver.internal.shaded.io.netty.handler.pcap.PcapWriteHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.pcap.State;
import org.neo4j.driver.internal.shaded.io.netty.util.NetUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;

public class PcapWriteHandlerTest {
    @Test
    public void udpV4SharedOutputStreamTest() throws InterruptedException {
        PcapWriteHandlerTest.udpV4(true, true);
    }

    @Test
    public void udpV4NonOutputStream() throws InterruptedException {
        PcapWriteHandlerTest.udpV4(false, true);
    }

    @Test
    public void udpV4NoGlobalHeaderOutputStream() throws InterruptedException {
        PcapWriteHandlerTest.udpV4(false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void udpV4(boolean sharedOutputStream, boolean writeGlobalHeaders) throws InterruptedException {
        ByteBuf byteBuf = Unpooled.buffer();
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("127.0.0.1", 0);
            InetSocketAddress clientAddr = new InetSocketAddress("127.0.0.1", 0);
            NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(2);
            Bootstrap server = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

                protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
                }
            });
            ChannelFuture channelFutureServer = server.bind((SocketAddress)serverAddr).sync();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)channelFutureServer.isSuccess());
            CloseDetectingByteBufOutputStream outputStream = new CloseDetectingByteBufOutputStream(byteBuf);
            Bootstrap client = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)PcapWriteHandler.builder().sharedOutputStream(sharedOutputStream).writePcapGlobalHeader(writeGlobalHeaders).build((OutputStream)((Object)outputStream)));
            ChannelFuture channelFutureClient = client.bind((SocketAddress)clientAddr).sync();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)channelFutureClient.isSuccess());
            Channel clientChannel = channelFutureClient.channel();
            DatagramPacket datagram = new DatagramPacket(payload.copy(), (InetSocketAddress)channelFutureServer.channel().localAddress());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)clientChannel.writeAndFlush((Object)datagram).sync().isSuccess());
            org.junit.jupiter.api.Assertions.assertTrue((boolean)eventLoopGroup.shutdownGracefully().sync().isSuccess());
            PcapWriteHandlerTest.verifyUdpCapture(!sharedOutputStream && writeGlobalHeaders, byteBuf, payload, (InetSocketAddress)channelFutureServer.channel().localAddress(), (InetSocketAddress)clientChannel.localAddress());
            org.junit.jupiter.api.Assertions.assertEquals((Object)(!sharedOutputStream ? 1 : 0), (Object)outputStream.closeCalled());
        }
        finally {
            byteBuf.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void embeddedUdp() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceUdpChannel(clientAddr, serverAddr).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            PcapWriteHandlerTest.verifyUdpCapture(true, pcapBuffer, payload, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyUdpCapture(false, pcapBuffer, payload, clientAddr, serverAddr);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpMixedAddress() throws SocketException {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("::", 3456);
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            PcapWriteHandlerTest.verifyUdpCapture(true, pcapBuffer, payload, serverAddr, new InetSocketAddress("0.0.0.0", 3456));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpLargeByteBufPayload() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        String payloadString = new String(new char[65508]).replace('\u0000', 'X');
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])payloadString.getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertEquals((int)24, (int)pcapBuffer.readableBytes());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpLargeDatagramPayload() {
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        ByteBuf pcapBuffer = Unpooled.buffer();
        String payloadString = new String(new char[65508]).replace('\u0000', 'X');
        DatagramPacket datagram = new DatagramPacket(Unpooled.wrappedBuffer((byte[])payloadString.getBytes()), serverAddr);
        try {
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{datagram.retainedDuplicate()}));
            DatagramPacket read = (DatagramPacket)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)datagram.content(), (Object)read.content());
            read.release();
            org.junit.jupiter.api.Assertions.assertEquals((int)24, (int)pcapBuffer.readableBytes());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            datagram.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpZeroLengthByteBufCaptured() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().captureZeroByte(true).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            PcapWriteHandlerTest.verifyUdpCapture(true, pcapBuffer, payload, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyUdpCapture(false, pcapBuffer, payload, clientAddr, serverAddr);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpZeroLengthByteBufDiscarded() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertEquals((int)24, (int)pcapBuffer.readableBytes());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpZeroLengthDatagramCaptured() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        DatagramPacket outbound = new DatagramPacket(payload.retainedDuplicate(), serverAddr);
        DatagramPacket inbound = new DatagramPacket(payload.retainedDuplicate(), clientAddr, serverAddr);
        try {
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().captureZeroByte(true).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{outbound.retainedDuplicate()}));
            DatagramPacket read = (DatagramPacket)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)outbound.content(), (Object)read.content());
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{inbound.retainedDuplicate()}));
            read = (DatagramPacket)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)inbound.content(), (Object)read.content());
            read.release();
            PcapWriteHandlerTest.verifyUdpCapture(true, pcapBuffer, payload, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyUdpCapture(false, pcapBuffer, payload, clientAddr, serverAddr);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            payload.release();
            outbound.release();
            inbound.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpZeroLengthDatagramDiscarded() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        DatagramPacket outbound = new DatagramPacket(payload.retainedDuplicate(), serverAddr);
        DatagramPacket inbound = new DatagramPacket(payload.retainedDuplicate(), clientAddr, serverAddr);
        try {
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{outbound.retainedDuplicate()}));
            DatagramPacket read = (DatagramPacket)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)outbound.content(), (Object)read.content());
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{inbound.retainedDuplicate()}));
            read = (DatagramPacket)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)inbound.content(), (Object)read.content());
            read.release();
            org.junit.jupiter.api.Assertions.assertEquals((int)24, (int)pcapBuffer.readableBytes());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
            payload.release();
            outbound.release();
            inbound.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void udpExceptionCaught() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        try {
            RuntimeException exception = new RuntimeException();
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            CloseDetectingByteBufOutputStream outputStream = new CloseDetectingByteBufOutputStream(pcapBuffer);
            EmbeddedDatagramChannel embeddedChannel = new EmbeddedDatagramChannel(clientAddr, serverAddr);
            embeddedChannel.pipeline().addLast(new ChannelHandler[]{PcapWriteHandler.builder().build((OutputStream)((Object)outputStream))});
            embeddedChannel.pipeline().fireExceptionCaught((Throwable)exception);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)outputStream.closeCalled());
            org.junit.jupiter.api.Assertions.assertEquals((int)24, (int)pcapBuffer.readableBytes());
            try {
                embeddedChannel.checkException();
                org.junit.jupiter.api.Assertions.fail();
            }
            catch (Throwable t) {
                org.junit.jupiter.api.Assertions.assertSame((Object)exception, (Object)t);
            }
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            pcapBuffer.release();
        }
    }

    @Test
    public void tcpV4SharedOutputStreamTest() throws Exception {
        PcapWriteHandlerTest.tcpV4(true, true);
    }

    @Test
    public void tcpV4NoGlobalHeaderOutputStream() throws Exception {
        PcapWriteHandlerTest.tcpV4(false, false);
    }

    @Test
    public void tcpV4NonOutputStream() throws Exception {
        PcapWriteHandlerTest.tcpV4(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tcpV4(final boolean sharedOutputStream, final boolean writeGlobalHeaders) throws Exception {
        final ByteBuf byteBuf = Unpooled.buffer();
        final ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        try {
            NioEventLoopGroup group = new NioEventLoopGroup(1);
            ServerBootstrap sb = new ServerBootstrap();
            final CountDownLatch serverLatch = new CountDownLatch(1);
            ((ServerBootstrap)((ServerBootstrap)sb.group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{PcapWriteHandler.builder().sharedOutputStream(sharedOutputStream).writePcapGlobalHeader(writeGlobalHeaders).build((OutputStream)new ByteBufOutputStream(byteBuf))});
                    p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int read;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            ByteBuf buf = (ByteBuf)msg;
                            this.read += buf.readableBytes();
                            ctx.writeAndFlush((Object)buf);
                            if (this.read == payload.readableBytes()) {
                                serverLatch.countDown();
                            }
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            ChannelFuture serverChannelFuture = sb.bind((SocketAddress)new InetSocketAddress("127.0.0.1", 0)).sync();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)serverChannelFuture.isSuccess());
            Bootstrap cb = new Bootstrap();
            final CountDownLatch clientLatch = new CountDownLatch(1);
            ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int read;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            ByteBuf buf = (ByteBuf)msg;
                            this.read += buf.readableBytes();
                            buf.release();
                            if (this.read == payload.readableBytes()) {
                                clientLatch.countDown();
                            }
                        }

                        public void channelActive(ChannelHandlerContext ctx) {
                            ctx.writeAndFlush((Object)payload.copy());
                        }

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            ctx.close();
                        }
                    }});
                }
            });
            InetSocketAddress serverAddress = (InetSocketAddress)serverChannelFuture.channel().localAddress();
            ChannelFuture clientChannelFuture = cb.connect((SocketAddress)serverAddress).sync();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)clientChannelFuture.isSuccess());
            InetSocketAddress clientAddress = (InetSocketAddress)clientChannelFuture.channel().localAddress();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)serverLatch.await(5L, TimeUnit.SECONDS));
            org.junit.jupiter.api.Assertions.assertTrue((boolean)clientLatch.await(5L, TimeUnit.SECONDS));
            clientChannelFuture.channel().close().sync();
            serverChannelFuture.channel().close().sync();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)group.shutdownGracefully().sync().isSuccess());
            PcapWriteHandlerTest.verifyTcpHandshakeCapture(writeGlobalHeaders && !sharedOutputStream, byteBuf, serverAddress, clientAddress);
            PcapWriteHandlerTest.verifyTcpCapture(byteBuf, payload, serverAddress, clientAddress, 1L, 1L);
            PcapWriteHandlerTest.verifyTcpCapture(byteBuf, payload, clientAddress, serverAddress, 1L, 5L);
            PcapWriteHandlerTest.verifyTcpCloseCapture(byteBuf, serverAddress, clientAddress, 5, 5);
        }
        finally {
            byteBuf.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void embeddedTcpClient() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf readPayload = Unpooled.wrappedBuffer((byte[])"Read".getBytes());
        ByteBuf writePayload = Unpooled.wrappedBuffer((byte[])"Write".getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, false).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{readPayload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)readPayload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{writePayload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)writePayload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
            PcapWriteHandlerTest.verifyTcpHandshakeCapture(true, pcapBuffer, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, readPayload, clientAddr, serverAddr, 1L, 1L);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, writePayload, serverAddr, clientAddr, 1L, 5L);
            PcapWriteHandlerTest.verifyTcpCloseCapture(pcapBuffer, serverAddr, clientAddr, 6, 5);
        }
        finally {
            pcapBuffer.release();
            readPayload.release();
            writePayload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void embeddedTcpServer() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf readPayload = Unpooled.wrappedBuffer((byte[])"Read".getBytes());
        ByteBuf writePayload = Unpooled.wrappedBuffer((byte[])"Write".getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, true).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{readPayload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)readPayload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{writePayload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)writePayload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
            PcapWriteHandlerTest.verifyTcpHandshakeCapture(true, pcapBuffer, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, readPayload, serverAddr, clientAddr, 1L, 1L);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, writePayload, clientAddr, serverAddr, 1L, 5L);
            PcapWriteHandlerTest.verifyTcpCloseCapture(pcapBuffer, serverAddr, clientAddr, 5, 6);
        }
        finally {
            pcapBuffer.release();
            readPayload.release();
            writePayload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tcpLargePayload() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        String payloadString = new String(new char[65496]).replace('\u0000', 'X');
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])payloadString.getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, false).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
            PcapWriteHandlerTest.verifyTcpHandshakeCapture(true, pcapBuffer, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, payload.slice(0, 65495), serverAddr, clientAddr, 1L, 1L);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, payload.slice(65495, 1), serverAddr, clientAddr, 65496L, 1L);
            PcapWriteHandlerTest.verifyTcpCloseCapture(pcapBuffer, serverAddr, clientAddr, 65497, 1);
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tcpZeroByteCaptured() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, false).captureZeroByte(true).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
            PcapWriteHandlerTest.verifyTcpHandshakeCapture(true, pcapBuffer, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, payload, serverAddr, clientAddr, 1L, 1L);
            PcapWriteHandlerTest.verifyTcpCapture(pcapBuffer, payload, clientAddr, serverAddr, 1L, 1L);
            PcapWriteHandlerTest.verifyTcpCloseCapture(pcapBuffer, serverAddr, clientAddr, 1, 1);
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tcpZeroByteDiscarded() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBuf payload = Unpooled.buffer();
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, false).build((OutputStream)new ByteBufOutputStream(pcapBuffer))});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
            PcapWriteHandlerTest.verifyTcpHandshakeCapture(true, pcapBuffer, serverAddr, clientAddr);
            PcapWriteHandlerTest.verifyTcpCloseCapture(pcapBuffer, serverAddr, clientAddr, 1, 1);
        }
        finally {
            pcapBuffer.release();
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void tcpExceptionCaught() {
        ByteBuf pcapBuffer = Unpooled.buffer();
        final RuntimeException exception = new RuntimeException();
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        CloseDetectingByteBufOutputStream outputStream = new CloseDetectingByteBufOutputStream(pcapBuffer);
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                super.channelActive(ctx);
                ctx.fireExceptionCaught((Throwable)exception);
            }
        }, PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, false).build((OutputStream)((Object)outputStream))});
        org.junit.jupiter.api.Assertions.assertTrue((boolean)outputStream.closeCalled());
        PcapWriteHandlerTest.verifyTcpHandshakeCapture(true, pcapBuffer, serverAddr, clientAddr);
        ByteBuf tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(pcapBuffer, serverAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)20, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
        try {
            embeddedChannel.checkException();
            org.junit.jupiter.api.Assertions.fail();
        }
        catch (Throwable t) {
            org.junit.jupiter.api.Assertions.assertSame((Object)exception, (Object)t);
        }
        finally {
            pcapBuffer.release();
        }
        org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writePcapGreaterThan4Gb() {
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        class RecordingOutputStream
        extends OutputStream {
            private long bytesWritten;
            private ByteArrayOutputStream out;

            RecordingOutputStream() {
            }

            @Override
            public void write(int b) {
                ++this.bytesWritten;
                if (this.out != null) {
                    this.out.write(b);
                }
            }

            @Override
            public void write(byte[] b, int off, int len) {
                this.bytesWritten += (long)len;
                if (this.out != null) {
                    this.out.write(b, off, len);
                }
            }

            void record() {
                this.out = new ByteArrayOutputStream();
            }

            void reset() {
                this.out = null;
            }

            byte[] recordedBytes() {
                return this.out.toByteArray();
            }

            long bytesWritten() {
                return this.bytesWritten;
            }
        }
        RecordingOutputStream outputStream = new RecordingOutputStream();
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{new DiscardingWritesAndFlushesHandler(), PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, true).build((OutputStream)outputStream), new DiscardingReadsHandler()});
        int chunkSize = 65495;
        String payloadString = new String(new char[chunkSize]).replace('\u0000', 'X');
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])payloadString.getBytes());
        try {
            long fourGB = 0xFFFFFFFFL;
            long msgCount = fourGB / (long)chunkSize + 2L;
            int i = 0;
            while ((long)i < msgCount) {
                if ((long)i == msgCount - 1L) {
                    outputStream.record();
                }
                embeddedChannel.writeInbound(new Object[]{payload.retainedDuplicate()});
                ++i;
            }
            long sequenceNumber = (msgCount - 1L) * (long)chunkSize - fourGB;
            long ackNumber = 1L;
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])outputStream.recordedBytes());
            PcapWriteHandlerTest.verifyTcpCapture(buf, payload, serverAddr, clientAddr, sequenceNumber, ackNumber);
            buf.release();
            outputStream.reset();
            int i2 = 0;
            while ((long)i2 < msgCount) {
                if ((long)i2 == msgCount - 1L) {
                    outputStream.record();
                }
                embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()});
                ++i2;
            }
            ackNumber = sequenceNumber + (long)chunkSize;
            buf = Unpooled.wrappedBuffer((byte[])outputStream.recordedBytes());
            PcapWriteHandlerTest.verifyTcpCapture(buf, payload, clientAddr, serverAddr, sequenceNumber, ackNumber);
            buf.release();
            outputStream.reset();
            Assertions.assertThat((long)outputStream.bytesWritten()).isGreaterThan(2L * (fourGB + 1000L));
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writerStateTest() throws Exception {
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])"Meow".getBytes());
        try {
            InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
            InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
            PcapWriteHandler pcapWriteHandler = PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, true).build(new OutputStream(){

                @Override
                public void write(int b) {
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((Object)State.INIT, (Object)pcapWriteHandler.state());
            EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{pcapWriteHandler});
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{payload.retainedDuplicate()}));
            ByteBuf read = (ByteBuf)embeddedChannel.readInbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeOutbound(new Object[]{payload.retainedDuplicate()}));
            read = (ByteBuf)embeddedChannel.readOutbound();
            org.junit.jupiter.api.Assertions.assertEquals((Object)payload, (Object)read);
            read.release();
            org.junit.jupiter.api.Assertions.assertEquals((Object)State.WRITING, (Object)pcapWriteHandler.state());
            pcapWriteHandler.pCapWriter().close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)State.CLOSED, (Object)pcapWriteHandler.state());
            pcapWriteHandler.close();
            org.junit.jupiter.api.Assertions.assertEquals((Object)State.CLOSED, (Object)pcapWriteHandler.state());
            org.junit.jupiter.api.Assertions.assertFalse((boolean)embeddedChannel.finishAndReleaseAll());
        }
        finally {
            payload.release();
        }
    }

    @Test
    public void pauseResumeTest() throws Exception {
        int i;
        byte[] payload = "Meow".getBytes();
        InetSocketAddress serverAddr = new InetSocketAddress("1.1.1.1", 1234);
        InetSocketAddress clientAddr = new InetSocketAddress("2.2.2.2", 3456);
        DiscardingStatsOutputStream discardingStatsOutputStream = new DiscardingStatsOutputStream();
        PcapWriteHandler pcapWriteHandler = PcapWriteHandler.builder().forceTcpChannel(serverAddr, clientAddr, true).build((OutputStream)discardingStatsOutputStream);
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)discardingStatsOutputStream.writesCalled());
        EmbeddedChannel embeddedChannel = new EmbeddedChannel(new ChannelHandler[]{pcapWriteHandler});
        for (int i2 = 0; i2 < 10; ++i2) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        }
        int initialWritesCalled = discardingStatsOutputStream.writesCalled();
        Assertions.assertThat((int)initialWritesCalled).isGreaterThan(0);
        pcapWriteHandler.pause();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.PAUSED, (Object)pcapWriteHandler.state());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)pcapWriteHandler.isWriting());
        for (i = 0; i < 100; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        }
        org.junit.jupiter.api.Assertions.assertEquals((int)initialWritesCalled, (int)discardingStatsOutputStream.writesCalled());
        pcapWriteHandler.resume();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.WRITING, (Object)pcapWriteHandler.state());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)pcapWriteHandler.isWriting());
        for (i = 0; i < 100; ++i) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])payload)}));
        }
        Assertions.assertThat((int)discardingStatsOutputStream.writesCalled()).isGreaterThan(initialWritesCalled);
        pcapWriteHandler.close();
        org.junit.jupiter.api.Assertions.assertEquals((Object)State.CLOSED, (Object)pcapWriteHandler.state());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)embeddedChannel.finishAndReleaseAll());
    }

    @Test
    public void globalHeadersStandalone() throws IOException {
        ByteBuf pcapBuffer = Unpooled.buffer();
        ByteBufOutputStream outputStream = new ByteBufOutputStream(pcapBuffer, true);
        PcapWriteHandler.writeGlobalHeader((OutputStream)outputStream);
        PcapWriteHandlerTest.verifyGlobalHeaders(pcapBuffer);
        outputStream.close();
    }

    private static void verifyGlobalHeaders(ByteBuf byteBuf) {
        org.junit.jupiter.api.Assertions.assertEquals((int)-1582119980, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)byteBuf.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)4, (int)byteBuf.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)byteBuf.readInt());
    }

    private static void verifyTcpCapture(ByteBuf byteBuf, ByteBuf expectedPayload, InetSocketAddress destinationAddr, InetSocketAddress sourceAddr, long sequenceNumber, long ackNumber) {
        int expectedPayloadLength = expectedPayload.readableBytes();
        ByteBuf tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, destinationAddr, expectedPayloadLength);
        org.junit.jupiter.api.Assertions.assertEquals((int)(sourceAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(destinationAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)sequenceNumber, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)ackNumber, (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])ByteBufUtil.getBytes((ByteBuf)expectedPayload), (byte[])ByteBufUtil.getBytes((ByteBuf)tcpPacket));
        tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, sourceAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(destinationAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(sourceAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)ackNumber, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)(sequenceNumber + (long)expectedPayloadLength), (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
    }

    private static void verifyTcpHandshakeCapture(boolean verifyGlobalHeaders, ByteBuf byteBuf, InetSocketAddress serverAddr, InetSocketAddress clientAddr) {
        if (verifyGlobalHeaders) {
            PcapWriteHandlerTest.verifyGlobalHeaders(byteBuf);
        }
        ByteBuf tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, serverAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
        tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, clientAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)18, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
        tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, serverAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
    }

    private static void verifyTcpCloseCapture(ByteBuf byteBuf, InetSocketAddress serverAddr, InetSocketAddress clientAddr, int sequenceNumber, int ackNumber) {
        ByteBuf tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, serverAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)sequenceNumber, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)ackNumber, (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)17, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
        tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, clientAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)ackNumber, (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)sequenceNumber, (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)17, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
        tcpPacket = PcapWriteHandlerTest.verifyTcpBaseHeaders(byteBuf, serverAddr, 0);
        org.junit.jupiter.api.Assertions.assertEquals((int)(clientAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(serverAddr.getPort() & 0xFFFF), (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((long)(sequenceNumber + 1), (long)tcpPacket.readUnsignedInt());
        org.junit.jupiter.api.Assertions.assertEquals((long)(ackNumber + 1), (long)tcpPacket.readUnsignedInt());
        tcpPacket.readByte();
        org.junit.jupiter.api.Assertions.assertEquals((int)16, (int)tcpPacket.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)65535, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)tcpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)tcpPacket.readUnsignedShort());
    }

    private static ByteBuf verifyTcpBaseHeaders(ByteBuf byteBuf, InetSocketAddress destinationAddress, int expectedPayloadLength) {
        byteBuf.readInt();
        byteBuf.readInt();
        org.junit.jupiter.api.Assertions.assertEquals((int)(54 + expectedPayloadLength), (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)(54 + expectedPayloadLength), (int)byteBuf.readInt());
        ByteBuf ethernetPacket = byteBuf.readSlice(54 + expectedPayloadLength);
        ByteBuf dstMac = ethernetPacket.readSlice(6);
        ByteBuf srcMac = ethernetPacket.readSlice(6);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, -1}, (byte[])ByteBufUtil.getBytes((ByteBuf)dstMac));
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, 0}, (byte[])ByteBufUtil.getBytes((ByteBuf)srcMac));
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)ethernetPacket.readShort());
        ByteBuf ipv4Packet = ethernetPacket.readSlice(40 + expectedPayloadLength);
        org.junit.jupiter.api.Assertions.assertEquals((int)69, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)(40 + expectedPayloadLength), (int)ipv4Packet.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((byte)-1, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((byte)6, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        ipv4Packet.readInt();
        org.junit.jupiter.api.Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)destinationAddress.getAddress())), (int)ipv4Packet.readInt());
        return ipv4Packet.readSlice(20 + expectedPayloadLength);
    }

    private static void verifyUdpCapture(boolean verifyGlobalHeaders, ByteBuf byteBuf, ByteBuf expectedPayload, InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        if (verifyGlobalHeaders) {
            PcapWriteHandlerTest.verifyGlobalHeaders(byteBuf);
        }
        int expectedPayloadLength = expectedPayload.readableBytes();
        byteBuf.readInt();
        byteBuf.readInt();
        org.junit.jupiter.api.Assertions.assertEquals((int)(42 + expectedPayloadLength), (int)byteBuf.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)(42 + expectedPayloadLength), (int)byteBuf.readInt());
        ByteBuf ethernetPacket = byteBuf.readBytes(42 + expectedPayloadLength);
        ByteBuf dstMac = ethernetPacket.readBytes(6);
        ByteBuf srcMac = ethernetPacket.readBytes(6);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, -1}, (byte[])ByteBufUtil.getBytes((ByteBuf)dstMac));
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, 0}, (byte[])ByteBufUtil.getBytes((ByteBuf)srcMac));
        org.junit.jupiter.api.Assertions.assertEquals((int)2048, (int)ethernetPacket.readShort());
        ByteBuf ipv4Packet = ethernetPacket.readBytes(28 + expectedPayloadLength);
        org.junit.jupiter.api.Assertions.assertEquals((int)69, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)(28 + expectedPayloadLength), (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((byte)-1, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((byte)17, (byte)ipv4Packet.readByte());
        org.junit.jupiter.api.Assertions.assertEquals((int)0, (int)ipv4Packet.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)localAddress.getAddress())), (int)ipv4Packet.readInt());
        org.junit.jupiter.api.Assertions.assertEquals((int)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)remoteAddress.getAddress())), (int)ipv4Packet.readInt());
        ByteBuf udpPacket = ipv4Packet.readBytes(8 + expectedPayloadLength);
        org.junit.jupiter.api.Assertions.assertEquals((int)(localAddress.getPort() & 0xFFFF), (int)udpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(remoteAddress.getPort() & 0xFFFF), (int)udpPacket.readUnsignedShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)(8 + expectedPayloadLength), (int)udpPacket.readShort());
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)udpPacket.readShort());
        ByteBuf payload = udpPacket.readBytes(expectedPayloadLength);
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])ByteBufUtil.getBytes((ByteBuf)expectedPayload), (byte[])ByteBufUtil.getBytes((ByteBuf)payload));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)dstMac.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)srcMac.release());
        if (expectedPayloadLength > 0) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)payload.release());
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ethernetPacket.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)ipv4Packet.release());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)udpPacket.release());
    }

    static class DiscardingWritesAndFlushesHandler
    extends ChannelOutboundHandlerAdapter {
        DiscardingWritesAndFlushesHandler() {
        }

        public void flush(ChannelHandlerContext ctx) {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ReferenceCountUtil.release((Object)msg);
            promise.setSuccess();
        }
    }

    static final class DiscardingReadsHandler
    extends ChannelInboundHandlerAdapter {
        DiscardingReadsHandler() {
        }

        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private static class EmbeddedDatagramChannel
    extends EmbeddedChannel
    implements DatagramChannel {
        private final InetSocketAddress local;
        private final InetSocketAddress remote;
        private DatagramChannelConfig config;

        EmbeddedDatagramChannel(InetSocketAddress local, InetSocketAddress remote) {
            super((ChannelId)DefaultChannelId.newInstance(), false, new ChannelHandler[0]);
            this.local = local;
            this.remote = remote;
        }

        public boolean isConnected() {
            return true;
        }

        public DatagramChannelConfig config() {
            if (this.config == null) {
                try {
                    this.config = new DefaultDatagramChannelConfig((DatagramChannel)this, new DatagramSocket());
                }
                catch (SocketException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.config;
        }

        public InetSocketAddress localAddress() {
            return (InetSocketAddress)super.localAddress();
        }

        public InetSocketAddress remoteAddress() {
            return (InetSocketAddress)super.remoteAddress();
        }

        protected SocketAddress localAddress0() {
            return this.local;
        }

        protected SocketAddress remoteAddress0() {
            return this.remote;
        }

        public ChannelFuture joinGroup(InetAddress multicastAddress) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture joinGroup(InetAddress multicastAddress, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture joinGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture leaveGroup(InetAddress multicastAddress) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture leaveGroup(InetAddress multicastAddress, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture leaveGroup(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress source, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture block(InetAddress multicastAddress, NetworkInterface networkInterface, InetAddress sourceToBlock, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock) {
            throw new UnsupportedOperationException();
        }

        public ChannelFuture block(InetAddress multicastAddress, InetAddress sourceToBlock, ChannelPromise future) {
            throw new UnsupportedOperationException();
        }
    }
}

