/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.File;
import java.net.SocketAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.Bootstrap;
import org.neo4j.driver.internal.shaded.io.netty.bootstrap.ServerBootstrap;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufAllocator;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelInitializer;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.channel.DefaultEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalAddress;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalChannel;
import org.neo4j.driver.internal.shaded.io.netty.channel.local.LocalServerChannel;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContextBuilder;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslProvider;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.util.SelfSignedCertificate;
import org.neo4j.driver.internal.shaded.io.netty.util.ReferenceCountUtil;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;

public class CipherSuiteCanaryTest {
    private static EventLoopGroup GROUP;
    private static SelfSignedCertificate CERT;

    static Collection<Object[]> parameters() {
        ArrayList<Object[]> dst = new ArrayList<Object[]>();
        dst.addAll(CipherSuiteCanaryTest.expand("TLS_DHE_RSA_WITH_AES_128_GCM_SHA256"));
        return dst;
    }

    @BeforeAll
    public static void init() throws Exception {
        GROUP = new DefaultEventLoopGroup();
        CERT = new SelfSignedCertificate();
    }

    @AfterAll
    public static void destroy() {
        GROUP.shutdownGracefully();
        CERT.delete();
    }

    private static void assumeCipherAvailable(SslProvider provider, String cipher) throws NoSuchAlgorithmException {
        boolean cipherSupported = false;
        if (provider == SslProvider.JDK) {
            SSLEngine engine = SSLContext.getDefault().createSSLEngine();
            for (String c : engine.getSupportedCipherSuites()) {
                if (!cipher.equals(c)) continue;
                cipherSupported = true;
                break;
            }
        } else {
            cipherSupported = OpenSsl.isCipherSuiteAvailable((String)cipher);
        }
        Assumptions.assumeTrue((boolean)cipherSupported, (String)("Unsupported cipher: " + cipher));
    }

    private static SslHandler newSslHandler(SslContext sslCtx, ByteBufAllocator allocator, Executor executor) {
        if (executor == null) {
            return sslCtx.newHandler(allocator);
        }
        return sslCtx.newHandler(allocator, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest(name="{index}: serverSslProvider = {0}, clientSslProvider = {1}, rfcCipherName = {2}, delegate = {3}")
    @MethodSource(value={"parameters"})
    public void testHandshake(SslProvider serverSslProvider, SslProvider clientSslProvider, String rfcCipherName, boolean delegate) throws Exception {
        CipherSuiteCanaryTest.assumeCipherAvailable(serverSslProvider, rfcCipherName);
        CipherSuiteCanaryTest.assumeCipherAvailable(clientSslProvider, rfcCipherName);
        List<String> ciphers = Collections.singletonList(rfcCipherName);
        final SslContext sslServerContext = SslContextBuilder.forServer((File)CERT.certificate(), (File)CERT.privateKey()).sslProvider(serverSslProvider).ciphers(ciphers).protocols(new String[]{"TLSv1.2"}).build();
        final ExecutorService executorService = delegate ? Executors.newCachedThreadPool() : null;
        try {
            final SslContext sslClientContext = SslContextBuilder.forClient().sslProvider(clientSslProvider).ciphers(ciphers).protocols(new String[]{"TLSv1.2"}).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            try {
                final Promise serverPromise = GROUP.next().newPromise();
                final Promise clientPromise = GROUP.next().newPromise();
                ChannelInitializer<Channel> serverHandler = new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ChannelPipeline pipeline = ch.pipeline();
                        pipeline.addLast(new ChannelHandler[]{CipherSuiteCanaryTest.newSslHandler(sslServerContext, ch.alloc(), executorService)});
                        pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Object>(){

                            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                serverPromise.cancel(true);
                                ctx.fireChannelInactive();
                            }

                            public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                                if (serverPromise.trySuccess(null)) {
                                    ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{80, 79, 78, 71}));
                                }
                                ctx.close();
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                if (!serverPromise.tryFailure(cause)) {
                                    ctx.fireExceptionCaught(cause);
                                }
                            }
                        }});
                    }
                };
                LocalAddress address = new LocalAddress("test-" + serverSslProvider + '-' + clientSslProvider + '-' + rfcCipherName);
                Channel server = CipherSuiteCanaryTest.server(address, (ChannelHandler)serverHandler);
                try {
                    ChannelInitializer<Channel> clientHandler = new ChannelInitializer<Channel>(){

                        protected void initChannel(Channel ch) throws Exception {
                            ChannelPipeline pipeline = ch.pipeline();
                            pipeline.addLast(new ChannelHandler[]{CipherSuiteCanaryTest.newSslHandler(sslClientContext, ch.alloc(), executorService)});
                            pipeline.addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<Object>(){

                                public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                                    clientPromise.cancel(true);
                                    ctx.fireChannelInactive();
                                }

                                public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
                                    clientPromise.trySuccess(null);
                                    ctx.close();
                                }

                                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                    if (!clientPromise.tryFailure(cause)) {
                                        ctx.fireExceptionCaught(cause);
                                    }
                                }
                            }});
                        }
                    };
                    Channel client = CipherSuiteCanaryTest.client(server, (ChannelHandler)clientHandler);
                    try {
                        client.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{80, 73, 78, 71})).syncUninterruptibly();
                        Assertions.assertTrue((boolean)clientPromise.await(5L, TimeUnit.SECONDS), (String)"client timeout");
                        Assertions.assertTrue((boolean)serverPromise.await(5L, TimeUnit.SECONDS), (String)"server timeout");
                        clientPromise.sync();
                        serverPromise.sync();
                    }
                    finally {
                        client.close().sync();
                    }
                }
                finally {
                    server.close().sync();
                }
            }
            finally {
                ReferenceCountUtil.release((Object)sslClientContext);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)sslServerContext);
            if (executorService != null) {
                executorService.shutdown();
            }
        }
    }

    private static Channel server(LocalAddress address, ChannelHandler handler) throws Exception {
        ServerBootstrap bootstrap = ((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).group(GROUP).childHandler(handler);
        return bootstrap.bind((SocketAddress)address).sync().channel();
    }

    private static Channel client(Channel server, ChannelHandler handler) throws Exception {
        SocketAddress remoteAddress = server.localAddress();
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(LocalChannel.class)).group(GROUP)).handler(handler);
        return bootstrap.connect(remoteAddress).sync().channel();
    }

    private static List<Object[]> expand(String rfcCipherName) {
        ArrayList<Object[]> dst = new ArrayList<Object[]>();
        SslProvider[] sslProviders = SslProvider.values();
        for (int i = 0; i < sslProviders.length; ++i) {
            SslProvider serverSslProvider = sslProviders[i];
            for (int j = 0; j < sslProviders.length; ++j) {
                SslProvider clientSslProvider = sslProviders[j];
                if ((serverSslProvider != SslProvider.JDK || clientSslProvider != SslProvider.JDK) && !OpenSsl.isAvailable()) continue;
                dst.add(new Object[]{serverSslProvider, clientSslProvider, rfcCipherName, true});
                dst.add(new Object[]{serverSslProvider, clientSslProvider, rfcCipherName, false});
            }
        }
        if (dst.isEmpty()) {
            throw new IllegalStateException();
        }
        return dst;
    }
}

