/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.util.List;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSsl;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OpenSslSessionTicketKey;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SSLEngineTest;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;

final class OpenSslEngineTestParam
extends SSLEngineTest.SSLEngineTestParam {
    final boolean useTasks;
    final boolean useTickets;

    static void expandCombinations(SSLEngineTest.SSLEngineTestParam param, List<? super OpenSslEngineTestParam> output) {
        output.add(new OpenSslEngineTestParam(true, false, param));
        output.add(new OpenSslEngineTestParam(false, false, param));
        if (OpenSsl.isBoringSSL()) {
            output.add(new OpenSslEngineTestParam(true, true, param));
            output.add(new OpenSslEngineTestParam(false, true, param));
        }
    }

    static SslContext wrapContext(SSLEngineTest.SSLEngineTestParam param, SslContext context) {
        if (context instanceof OpenSslContext) {
            OpenSslContext ctx = (OpenSslContext)context;
            if (param instanceof OpenSslEngineTestParam) {
                OpenSslEngineTestParam openSslParam = (OpenSslEngineTestParam)param;
                ctx.setUseTasks(openSslParam.useTasks);
                if (openSslParam.useTickets) {
                    ctx.sessionContext().setTicketKeys(new OpenSslSessionTicketKey[0]);
                }
            }
            ctx.sessionContext().setSessionCacheEnabled(true);
        }
        return context;
    }

    static boolean isUsingTickets(SSLEngineTest.SSLEngineTestParam param) {
        if (param instanceof OpenSslEngineTestParam) {
            return ((OpenSslEngineTestParam)param).useTickets;
        }
        return false;
    }

    OpenSslEngineTestParam(boolean useTasks, boolean useTickets, SSLEngineTest.SSLEngineTestParam param) {
        super(param.type(), param.combo(), param.delegate());
        this.useTasks = useTasks;
        this.useTickets = useTickets;
    }

    @Override
    public String toString() {
        return "OpenSslEngineTestParam{type=" + (Object)((Object)this.type()) + ", protocolCipherCombo=" + this.combo() + ", delegate=" + this.delegate() + ", useTasks=" + this.useTasks + ", useTickets=" + this.useTickets + '}';
    }
}

