/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.Unpooled;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandler;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPipeline;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.OptionalSslHandler;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.SslHandler;

public class OptionalSslHandlerTest {
    private static final String SSL_HANDLER_NAME = "sslhandler";
    private static final String HANDLER_NAME = "handler";
    @Mock
    private ChannelHandlerContext context;
    @Mock
    private SslContext sslContext;
    @Mock
    private ChannelPipeline pipeline;

    @BeforeEach
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.context.pipeline()).thenReturn((Object)this.pipeline);
    }

    @Test
    public void handlerRemoved() throws Exception {
        OptionalSslHandler handler = new OptionalSslHandler(this.sslContext);
        ByteBuf payload = Unpooled.copiedBuffer((byte[])"plaintext".getBytes());
        try {
            handler.decode(this.context, payload, null);
            ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).remove((ChannelHandler)handler);
        }
        finally {
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void handlerReplaced() throws Exception {
        final ChannelHandler nonSslHandler = (ChannelHandler)Mockito.mock(ChannelHandler.class);
        OptionalSslHandler handler = new OptionalSslHandler(this.sslContext){

            protected ChannelHandler newNonSslHandler(ChannelHandlerContext context) {
                return nonSslHandler;
            }

            protected String newNonSslHandlerName() {
                return OptionalSslHandlerTest.HANDLER_NAME;
            }
        };
        ByteBuf payload = Unpooled.copiedBuffer((byte[])"plaintext".getBytes());
        try {
            handler.decode(this.context, payload, null);
            ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).replace((ChannelHandler)handler, HANDLER_NAME, nonSslHandler);
        }
        finally {
            payload.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void sslHandlerReplaced() throws Exception {
        final SslHandler sslHandler = (SslHandler)Mockito.mock(SslHandler.class);
        OptionalSslHandler handler = new OptionalSslHandler(this.sslContext){

            protected SslHandler newSslHandler(ChannelHandlerContext context, SslContext sslContext) {
                return sslHandler;
            }

            protected String newSslHandlerName() {
                return OptionalSslHandlerTest.SSL_HANDLER_NAME;
            }
        };
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])new byte[]{22, 3, 1, 0, 5});
        try {
            handler.decode(this.context, payload, null);
            ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).replace((ChannelHandler)handler, SSL_HANDLER_NAME, (ChannelHandler)sslHandler);
        }
        finally {
            payload.release();
        }
    }

    @Test
    public void decodeBuffered() throws Exception {
        OptionalSslHandler handler = new OptionalSslHandler(this.sslContext);
        ByteBuf payload = Unpooled.wrappedBuffer((byte[])new byte[]{22, 3});
        try {
            handler.decode(this.context, payload, null);
            Mockito.verifyZeroInteractions((Object[])new Object[]{this.pipeline});
        }
        finally {
            payload.release();
        }
    }
}

