/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.io.netty.handler.ssl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.handler.ssl.PemReader;
import org.neo4j.driver.internal.shaded.io.netty.util.CharsetUtil;

class PemReaderTest {
    PemReaderTest() {
    }

    @Test
    public void mustBeAbleToReadMultipleCertificates() throws Exception {
        byte[] certs = "-----BEGIN CERTIFICATE-----\nMIICqjCCAZKgAwIBAgIIEaz8uuDHTcIwDQYJKoZIhvcNAQELBQAwFDESMBAGA1UEAwwJbG9jYWxo\nb3N0MCAXDTIxMDYxNjE3MjYyOFoYDzk5OTkxMjMxMjM1OTU5WjAUMRIwEAYDVQQDDAlsb2NhbGhv\nc3QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCVjENomtpMqHkg1yJ/uYZgSWmf/0Gb\nU4yMDf30muPvMYb3gO6peEnoXa2b0WDOjLbLrcltp1YdjTlLhRRTYgDo9TAvHoUdoMGlTnfQtQne\n2o+/92bnlZTroRIjUT0lqSxQ6UNXcOi9tNqVD4tML3vk20fudwBur8Plx+3hOhM/v64GbV46k06+\nAblrFwBt9u6V0uIVtvgraOd+NgL4yNf594uND30mbB7Q7xe/Y6DiPhI6cVI/CbLlXVwKLvC5OziS\nJKZ7svP0K3DBRxk+dOD9pg4SdaAEQVtR734ZlDh1XJ+mZssuDDda3NGZAjpCU4rkeV/J3Tr5KKMD\ng3NEOmifAgMBAAEwDQYJKoZIhvcNAQELBQADggEBABejZGeRNCyPdIqac6cyAf99JPp5OySEMWHU\nQXVCHEbQ8Eh6hsmrXSEaZS2zy/5dixPb5Rin0xaX5fqZdfLIUc0Mw/zXV/RiOIjrtUKez15Ko/4K\nONyxELjUq+SaJx2C1UcKEMfQBeq7O6XO60CLQ2AtVozmvJU9pt4KYQv0Kr+br3iNFpRuR43IYHyx\nHP7QsD3L3LEqIqW/QtYEnAAngZofUiq0XELh4GB0L8DbcSJIxfZmYagFl7c2go9OZPD14mlaTnMV\nPjd+OkwMif5T7v+r+KVSmDSMQwa+NfW+V6Xngg5/bN3kWHdw9qFQGANojl9wsRVN/B3pu3Cc2XFD\nMmQ=\n-----END CERTIFICATE-----\n-----BEGIN CERTIFICATE-----\nMIICqjCCAZKgAwIBAgIIIsUS6UkDau4wDQYJKoZIhvcNAQELBQAwFDESMBAGA1UEAwwJbG9jYWxo\nb3N0MCAXDTIxMDYxNjE3MjYyOFoYDzk5OTkxMjMxMjM1OTU5WjAUMRIwEAYDVQQDDAlsb2NhbGhv\nc3QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCTZmahFZXB0Dv3N8t6gfXTeqhTxRng\nmIBBPmrbZBODrZm06vrR5KNhxB2FhWIq1Yu8xXXv8sO+PaO2Sw/h6TeslRJ4EkrNd9zmYhT2cJvP\nd1CtkX5EHyMZRUKj7Eg4eUO1k/+JnhMmaY+nUAG7fCtvs8pS9SEXbEqYW7S4AQ1oopbCAMqQekly\nKCdnjGlVhXwL2Lj2rr/uw1Fc2+WvY/leQGo0rbIqoc7OSAktsP+MXI6iQ1RWJOec15V6iFRzcdE3\nQ4ODSMZ/R8wm9DH+4hkeQNPMbcc1wlvVZpDZ/FZegr1XimcYcJr2AoAQf3Xe1yFKAtBMXCjCIGm8\nveCQ+xeHAgMBAAEwDQYJKoZIhvcNAQELBQADggEBAGyV+dib2MdpenbntKk7PdZEx+/vNl9cEpwL\nBfWmQN/j2RmHUxrUM+PVkLTgyCq8okdCKqCvraKwBkF6vlzp4u5CL4L323z+/uxAi6pzbcWnG1EH\nJpSkf1OhTUFu6UhLfpg3XqeiIujYdVZTpHr7KHVLRYUSQPprt4HjLZeCIg4P2pZ0yQ3SEBhVed89\nGMj/+O4jjvuZv5NQc57NpMIrE9fNINczLG1CPTgnhvqMP42W6ahBuexQUe4gP+jmB/BZmBYKoauU\nmPBKruq3mNuoXtbHufv5I7CFVXNgJ0/aT+lvEkQ4IlCIcJyvTgyUTOQVbqDp+SswymAIRowaRdxa\n7Ss=\n-----END CERTIFICATE-----\n".getBytes(CharsetUtil.US_ASCII);
        ByteArrayInputStream in = new ByteArrayInputStream(certs);
        ByteBuf[] bufs = PemReader.readCertificates((InputStream)in);
        in.close();
        Assertions.assertThat((int)bufs.length).isEqualTo(2);
        for (ByteBuf buf : bufs) {
            buf.release();
        }
    }

    @Test
    public void mustBeAbleToReadPrivateKey() throws Exception {
        byte[] key = "-----BEGIN PRIVATE KEY-----\nMIICqjCCAZKgAwIBAgIIEaz8uuDHTcIwDQYJKoZIhvcNAQELBQAwFDESMBAGA1UEAwwJbG9jYWxo\nb3N0MCAXDTIxMDYxNjE3MjYyOFoYDzk5OTkxMjMxMjM1OTU5WjAUMRIwEAYDVQQDDAlsb2NhbGhv\nc3QwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCVjENomtpMqHkg1yJ/uYZgSWmf/0Gb\nU4yMDf30muPvMYb3gO6peEnoXa2b0WDOjLbLrcltp1YdjTlLhRRTYgDo9TAvHoUdoMGlTnfQtQne\n2o+/92bnlZTroRIjUT0lqSxQ6UNXcOi9tNqVD4tML3vk20fudwBur8Plx+3hOhM/v64GbV46k06+\nAblrFwBt9u6V0uIVtvgraOd+NgL4yNf594uND30mbB7Q7xe/Y6DiPhI6cVI/CbLlXVwKLvC5OziS\nJKZ7svP0K3DBRxk+dOD9pg4SdaAEQVtR734ZlDh1XJ+mZssuDDda3NGZAjpCU4rkeV/J3Tr5KKMD\ng3NEOmifAgMBAAEwDQYJKoZIhvcNAQELBQADggEBABejZGeRNCyPdIqac6cyAf99JPp5OySEMWHU\nQXVCHEbQ8Eh6hsmrXSEaZS2zy/5dixPb5Rin0xaX5fqZdfLIUc0Mw/zXV/RiOIjrtUKez15Ko/4K\nONyxELjUq+SaJx2C1UcKEMfQBeq7O6XO60CLQ2AtVozmvJU9pt4KYQv0Kr+br3iNFpRuR43IYHyx\nHP7QsD3L3LEqIqW/QtYEnAAngZofUiq0XELh4GB0L8DbcSJIxfZmYagFl7c2go9OZPD14mlaTnMV\nPjd+OkwMif5T7v+r+KVSmDSMQwa+NfW+V6Xngg5/bN3kWHdw9qFQGANojl9wsRVN/B3pu3Cc2XFD\nMmQ=\n-----END PRIVATE KEY-----\n".getBytes(CharsetUtil.US_ASCII);
        ByteArrayInputStream in = new ByteArrayInputStream(key);
        ByteBuf buf = PemReader.readPrivateKey((InputStream)in);
        in.close();
        Assertions.assertThat((int)buf.readableBytes()).isEqualTo(686);
        buf.release();
    }
}

